// Boost.Geometry (aka GGL, Generic Geometry Library)

// Copyright (c) 2008-2012 Barend Gehrels, Amsterdam, the Netherlands.

// This file was modified by Oracle on 2017, 2018, 2020, 2022.
// Modifications copyright (c) 2017-2022, Oracle and/or its affiliates.
// Contributed and/or modified by Vissarion Fysikopoulos, on behalf of Oracle
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)


#ifndef BOOST_GEOMETRY_PROJECTIONS_EPGS_HPP
#define BOOST_GEOMETRY_PROJECTIONS_EPGS_HPP


#include <algorithm>

#include <boost/geometry/srs/projections/code.hpp>


namespace boost { namespace geometry { namespace projections
{


#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

    inline srs::dpar::parameters<> epsg_to_parameters(int code)
    {
        using namespace srs::dpar;

        using p = code_parameter;
        using ps = std::array<p, 13>;
        using ce = code_element;
        using towgs84 = std::array<double, 7>;

        static constexpr std::array<code_element, 3998> arr = {
            ce(2000, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-62), p(k,0.9995000000000001), p(x_0,400000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(2001, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-62), p(k,0.9995000000000001), p(x_0,400000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(2002, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-62), p(k,0.9995000000000001), p(x_0,400000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{725,685,536,0,0,0,0}),
            ce(2003, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-62), p(k,0.9995000000000001), p(x_0,400000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{72,213.7,93,0,0,0,0}),
            ce(2004, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-62), p(k,0.9995000000000001), p(x_0,400000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{174,359,365,0,0,0,0}),
            ce(2005, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-62), p(k,0.9995000000000001), p(x_0,400000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(2006, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-62), p(k,0.9995000000000001), p(x_0,400000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-149,128,296,0,0,0,0}),
            ce(2007, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-62), p(k,0.9995000000000001), p(x_0,400000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{195.671,332.517,274.607,0,0,0,0}),
            ce(2008, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-55.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2009, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-58.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2010, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-61.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2011, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-64.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2012, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-67.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2013, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-70.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2014, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-73.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2015, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-76.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2016, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-79.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2017, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-73.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2018, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-76.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2019, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-79.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2020, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-82.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2021, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-81), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2022, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-84), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2023, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-87), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2024, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-90), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2025, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-93), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2026, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-96), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2027, ps{p(proj_utm), p(zone,15), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2028, ps{p(proj_utm), p(zone,16), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2029, ps{p(proj_utm), p(zone,17), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2030, ps{p(proj_utm), p(zone,18), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2031, ps{p(proj_utm), p(zone,17), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2032, ps{p(proj_utm), p(zone,18), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2033, ps{p(proj_utm), p(zone,19), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2034, ps{p(proj_utm), p(zone,20), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2035, ps{p(proj_utm), p(zone,21), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2036, ps{p(proj_sterea), p(lat_0,46.5), p(lon_0,-66.5), p(k,0.999912), p(x_0,2500000), p(y_0,7500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2037, ps{p(proj_utm), p(zone,19), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2038, ps{p(proj_utm), p(zone,20), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2039, ps{p(proj_tmerc), p(lat_0,31.73439361111111), p(lon_0,35.20451694444445), p(k,1.0000067), p(x_0,219529.584), p(y_0,626907.39), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{-48,55,52,0,0,0,0}),
            ce(2040, ps{p(proj_utm), p(zone,30), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-125,53,467,0,0,0,0}),
            ce(2041, ps{p(proj_utm), p(zone,30), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-124.76,53,466.79,0,0,0,0}),
            ce(2042, ps{p(proj_utm), p(zone,29), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-125,53,467,0,0,0,0}),
            ce(2043, ps{p(proj_utm), p(zone,29), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-124.76,53,466.79,0,0,0,0}),
            ce(2044, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,18500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{-17.51,-108.32,-62.39,0,0,0,0}),
            ce(2045, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,19500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{-17.51,-108.32,-62.39,0,0,0,0}),
            //{2046}
            //{2047}
            //{2048}
            //{2049}
            //{2050}
            //{2051}
            //{2052}
            //{2053}
            //{2054}
            //{2055}
            ce(2056, ps{p(proj_somerc), p(lat_0,46.95240555555556), p(lon_0,7.439583333333333), p(k_0,1), p(x_0,2600000), p(y_0,1200000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{674.374,15.056,405.346,0,0,0,0}),
            ce(2057, ps{p(proj_omerc), p(lat_0,27.51882880555555), p(lonc,52.60353916666667), p(alpha,0.5716611944444444), p(k,0.999895934), p(x_0,658377.437), p(y_0,3044969.194), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-133.63,-157.5,-158.62,0,0,0,0}),
            ce(2058, ps{p(proj_utm), p(zone,38), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2059, ps{p(proj_utm), p(zone,39), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2060, ps{p(proj_utm), p(zone,40), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2061, ps{p(proj_utm), p(zone,41), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2062, ps{p(proj_lcc), p(lat_1,40), p(lat_0,40), p(lon_0,0), p(k_0,0.9988085293), p(x_0,600000), p(y_0,600000), p(a,6378298.3), p(b,6356657.142669561), p(pm_madrid), p(units_m), p(no_defs)}),
            ce(2063, ps{p(proj_utm), p(zone,28), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{-23,259,-9,0,0,0,0}),
            ce(2064, ps{p(proj_utm), p(zone,29), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{-23,259,-9,0,0,0,0}),
            ce(2065, ps{p(proj_krovak), p(lat_0,49.5), p(lon_0,42.5), p(alpha,30.28813972222222), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(2066, ps{p(proj_cass), p(lat_0,11.25217861111111), p(lon_0,-60.68600888888889), p(x_0,37718.66159325), p(y_0,36209.91512952), p(a,6378293.645208759), p(b,6356617.987679838), p(to_meter,0.201166195164), p(no_defs)}),
            ce(2067, ps{p(proj_utm), p(zone,20), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2068, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2069, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,11), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2070, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,13), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2071, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2072, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,17), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2073, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,19), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2074, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2075, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,23), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2076, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,25), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2077, ps{p(proj_utm), p(zone,32), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2078, ps{p(proj_utm), p(zone,33), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2079, ps{p(proj_utm), p(zone,34), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2080, ps{p(proj_utm), p(zone,35), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2081, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-69), p(k,1), p(x_0,2500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2082, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-69), p(k,1), p(x_0,2500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{27.5,14,186.4,0,0,0,0}),
            ce(2083, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-69), p(k,1), p(x_0,2500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2084, ps{p(proj_utm), p(zone,19), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2085, ps{p(proj_lcc), p(lat_1,22.35), p(lat_0,22.35), p(lon_0,-81), p(k_0,0.99993602), p(x_0,500000), p(y_0,280296.016), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(2086, ps{p(proj_lcc), p(lat_1,20.71666666666667), p(lat_0,20.71666666666667), p(lon_0,-76.83333333333333), p(k_0,0.99994848), p(x_0,500000), p(y_0,229126.939), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(2087, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2088, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,11), p(k,0.9996), p(x_0,500000), p(y_0,0), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(2089, ps{p(proj_utm), p(zone,38), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2090, ps{p(proj_utm), p(zone,39), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2091, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,8500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{-76,-138,67,0,0,0,0}),
            ce(2092, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,9500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{-76,-138,67,0,0,0,0}),
            ce(2093, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,106), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{-17.51,-108.32,-62.39,0,0,0,0}),
            ce(2094, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,106), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(2095, ps{p(proj_utm), p(zone,28), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-173,253,27,0,0,0,0}),
            ce(2096, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,129), p(k,1), p(x_0,200000), p(y_0,500000), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(2097, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,127), p(k,1), p(x_0,200000), p(y_0,500000), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(2098, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,125), p(k,1), p(x_0,200000), p(y_0,500000), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(2099, ps{p(proj_cass), p(lat_0,25.38236111111111), p(lon_0,50.76138888888889), p(x_0,100000), p(y_0,100000), p(ellps_helmert), p(units_m), p(no_defs)}),
            ce(2100, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{-199.87,74.79,246.62,0,0,0,0}),
            ce(2101, ps{p(proj_lcc), p(lat_1,10.16666666666667), p(lat_0,10.16666666666667), p(lon_0,-71.60561777777777), p(k_0,1), p(x_0,0), p(y_0,-52684.972), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2102, ps{p(proj_lcc), p(lat_1,10.16666666666667), p(lat_0,10.16666666666667), p(lon_0,-71.60561777777777), p(k_0,1), p(x_0,200000), p(y_0,147315.028), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2103, ps{p(proj_lcc), p(lat_1,10.16666666666667), p(lat_0,10.16666666666667), p(lon_0,-71.60561777777777), p(k_0,1), p(x_0,500000), p(y_0,447315.028), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2104, ps{p(proj_lcc), p(lat_1,10.16666666666667), p(lat_0,10.16666666666667), p(lon_0,-71.60561777777777), p(k_0,1), p(x_0,-17044), p(y_0,-23139.97), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2105, ps{p(proj_tmerc), p(lat_0,-36.87972222222222), p(lon_0,174.7641666666667), p(k,0.9999), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2106, ps{p(proj_tmerc), p(lat_0,-37.76111111111111), p(lon_0,176.4661111111111), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2107, ps{p(proj_tmerc), p(lat_0,-38.62444444444444), p(lon_0,177.8855555555556), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2108, ps{p(proj_tmerc), p(lat_0,-39.65083333333333), p(lon_0,176.6736111111111), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2109, ps{p(proj_tmerc), p(lat_0,-39.13555555555556), p(lon_0,174.2277777777778), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2110, ps{p(proj_tmerc), p(lat_0,-39.51222222222222), p(lon_0,175.64), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2111, ps{p(proj_tmerc), p(lat_0,-40.24194444444444), p(lon_0,175.4880555555555), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2112, ps{p(proj_tmerc), p(lat_0,-40.92527777777777), p(lon_0,175.6472222222222), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2113, ps{p(proj_tmerc), p(lat_0,-41.3011111111111), p(lon_0,174.7763888888889), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2114, ps{p(proj_tmerc), p(lat_0,-40.71472222222223), p(lon_0,172.6719444444444), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2115, ps{p(proj_tmerc), p(lat_0,-41.27444444444444), p(lon_0,173.2991666666667), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2116, ps{p(proj_tmerc), p(lat_0,-41.28972222222222), p(lon_0,172.1088888888889), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2117, ps{p(proj_tmerc), p(lat_0,-41.81055555555555), p(lon_0,171.5811111111111), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2118, ps{p(proj_tmerc), p(lat_0,-42.33361111111111), p(lon_0,171.5497222222222), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2119, ps{p(proj_tmerc), p(lat_0,-42.68888888888888), p(lon_0,173.01), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2120, ps{p(proj_tmerc), p(lat_0,-41.54444444444444), p(lon_0,173.8019444444444), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2121, ps{p(proj_tmerc), p(lat_0,-42.88611111111111), p(lon_0,170.9797222222222), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2122, ps{p(proj_tmerc), p(lat_0,-43.11), p(lon_0,170.2608333333333), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2123, ps{p(proj_tmerc), p(lat_0,-43.97777777777778), p(lon_0,168.6061111111111), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2124, ps{p(proj_tmerc), p(lat_0,-43.59055555555556), p(lon_0,172.7269444444445), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2125, ps{p(proj_tmerc), p(lat_0,-43.74861111111111), p(lon_0,171.3605555555555), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2126, ps{p(proj_tmerc), p(lat_0,-44.40194444444445), p(lon_0,171.0572222222222), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2127, ps{p(proj_tmerc), p(lat_0,-44.735), p(lon_0,169.4675), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2128, ps{p(proj_tmerc), p(lat_0,-45.13277777777778), p(lon_0,168.3986111111111), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2129, ps{p(proj_tmerc), p(lat_0,-45.56361111111111), p(lon_0,167.7386111111111), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2130, ps{p(proj_tmerc), p(lat_0,-45.81611111111111), p(lon_0,170.6283333333333), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2131, ps{p(proj_tmerc), p(lat_0,-45.86138888888889), p(lon_0,170.2825), p(k,0.99996), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2132, ps{p(proj_tmerc), p(lat_0,-46.6), p(lon_0,168.3427777777778), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2133, ps{p(proj_utm), p(zone,58), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2134, ps{p(proj_utm), p(zone,59), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2135, ps{p(proj_utm), p(zone,60), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2136, ps{p(proj_tmerc), p(lat_0,4.666666666666667), p(lon_0,-1), p(k,0.99975), p(x_0,274319.7391633579), p(y_0,0), p(a,6378300), p(b,6356751.689189189), p(to_meter,0.3047997101815088), p(no_defs)}, towgs84{-199,32,322,0,0,0,0}),
            ce(2137, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-1), p(k,0.9996), p(x_0,500000), p(y_0,0), p(a,6378300), p(b,6356751.689189189), p(units_m), p(no_defs)}, towgs84{-199,32,322,0,0,0,0}),
            ce(2138, ps{p(proj_lcc), p(lat_1,60), p(lat_2,46), p(lat_0,44), p(lon_0,-68.5), p(x_0,0), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2139, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-55.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2140, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-58.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2141, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-61.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2142, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-64.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2143, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-67.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2144, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-70.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2145, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-73.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2146, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-76.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2147, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-79.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2148, ps{p(proj_utm), p(zone,21), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2149, ps{p(proj_utm), p(zone,18), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2150, ps{p(proj_utm), p(zone,17), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2151, ps{p(proj_utm), p(zone,13), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2152, ps{p(proj_utm), p(zone,12), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2153, ps{p(proj_utm), p(zone,11), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2154, ps{p(proj_lcc), p(lat_1,49), p(lat_2,44), p(lat_0,46.5), p(lon_0,3), p(x_0,700000), p(y_0,6600000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2155, ps{p(proj_lcc), p(lat_1,-14.26666666666667), p(lat_0,-14.26666666666667), p(lon_0,170), p(k_0,1), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{-115,118,426,0,0,0,0}),
            ce(2156, ps{p(proj_utm), p(zone,59), p(south), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2157, ps{p(proj_tmerc), p(lat_0,53.5), p(lon_0,-8), p(k,0.99982), p(x_0,600000), p(y_0,750000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2158, ps{p(proj_utm), p(zone,29), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2159, ps{p(proj_tmerc), p(lat_0,6.666666666666667), p(lon_0,-12), p(k,1), p(x_0,152399.8550907544), p(y_0,0), p(a,6378300), p(b,6356751.689189189), p(to_meter,0.3047997101815088), p(no_defs)}),
            ce(2160, ps{p(proj_tmerc), p(lat_0,6.666666666666667), p(lon_0,-12), p(k,1), p(x_0,243839.7681452071), p(y_0,182879.8261089053), p(a,6378300), p(b,6356751.689189189), p(to_meter,0.3047997101815088), p(no_defs)}),
            ce(2161, ps{p(proj_utm), p(zone,28), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-88,4,101,0,0,0,0}),
            ce(2162, ps{p(proj_utm), p(zone,29), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-88,4,101,0,0,0,0}),
            ce(2163, ps{p(proj_laea), p(lat_0,45), p(lon_0,-100), p(x_0,0), p(y_0,0), p(r,6370997), p(units_m), p(no_defs)}),
            ce(2164, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-5), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-125,53,467,0,0,0,0}),
            ce(2165, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-5), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-124.76,53,466.79,0,0,0,0}),
            ce(2166, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{24,-123,-94,0.02,-0.25,-0.13,1.1}),
            ce(2167, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{24,-123,-94,0.02,-0.25,-0.13,1.1}),
            ce(2168, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{24,-123,-94,0.02,-0.25,-0.13,1.1}),
            ce(2169, ps{p(proj_tmerc), p(lat_0,49.83333333333334), p(lon_0,6.166666666666667), p(k,1), p(x_0,80000), p(y_0,100000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-193,13.7,-39.3,-0.41,-2.933,2.688,0.43}),
            ce(2170, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(2171, ps{p(proj_sterea), p(lat_0,50.625), p(lon_0,21.08333333333333), p(k,0.9998), p(x_0,4637000), p(y_0,5647000), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(2172, ps{p(proj_sterea), p(lat_0,53.00194444444445), p(lon_0,21.50277777777778), p(k,0.9998), p(x_0,4603000), p(y_0,5806000), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(2173, ps{p(proj_sterea), p(lat_0,53.58333333333334), p(lon_0,17.00833333333333), p(k,0.9998), p(x_0,3501000), p(y_0,5999000), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(2174, ps{p(proj_sterea), p(lat_0,51.67083333333333), p(lon_0,16.67222222222222), p(k,0.9998), p(x_0,3703000), p(y_0,5627000), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(2175, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18.95833333333333), p(k,0.999983), p(x_0,237000), p(y_0,-4700000), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(2176, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,0.999923), p(x_0,5500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2177, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,0.999923), p(x_0,6500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2178, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,0.999923), p(x_0,7500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2179, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,0.999923), p(x_0,8500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2180, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,19), p(k,0.9993), p(x_0,500000), p(y_0,-5300000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2188, ps{p(proj_utm), p(zone,25), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2189, ps{p(proj_utm), p(zone,26), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-104,167,-38,0,0,0,0}),
            ce(2190, ps{p(proj_utm), p(zone,26), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-203,141,53,0,0,0,0}),
            ce(2191, ps{p(proj_utm), p(zone,28), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2192, ps{p(proj_lcc), p(lat_1,46.8), p(lat_0,46.8), p(lon_0,2.337229166666667), p(k_0,0.99987742), p(x_0,600000), p(y_0,2200000), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2193, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,173), p(k,0.9996), p(x_0,1600000), p(y_0,10000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2194, ps{p(proj_lcc), p(lat_1,-14.26666666666667), p(lat_0,-14.26666666666667), p(lon_0,-170), p(k_0,1), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{-115,118,426,0,0,0,0}),
            ce(2195, ps{p(proj_utm), p(zone,2), p(south), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2196, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9.5), p(k,0.99995), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2197, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2198, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2199, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2200, ps{p(proj_sterea), p(lat_0,46.5), p(lon_0,-66.5), p(k,0.999912), p(x_0,300000), p(y_0,800000), p(a,6378135), p(b,6356750.304921594), p(units_m), p(no_defs)}),
            ce(2201, ps{p(proj_utm), p(zone,18), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2202, ps{p(proj_utm), p(zone,19), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2203, ps{p(proj_utm), p(zone,20), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2204, ps{p(proj_lcc), p(lat_1,35.25), p(lat_2,36.41666666666666), p(lat_0,34.66666666666666), p(lon_0,-86), p(x_0,609601.2192024384), p(y_0,30480.06096012192), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2205, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,38.96666666666667), p(lat_0,37.5), p(lon_0,-84.25), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(2206, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,9500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2207, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,30), p(k,1), p(x_0,10500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2208, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,11500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2209, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,36), p(k,1), p(x_0,12500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2210, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,13500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2211, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,42), p(k,1), p(x_0,14500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2212, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,15500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2213, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,30), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2214, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,10.5), p(k,0.999), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-206.1,-174.7,-87.7,0,0,0,0}),
            ce(2215, ps{p(proj_utm), p(zone,32), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{-70.9,-151.8,-41.4,0,0,0,0}),
            ce(2216, ps{p(proj_utm), p(zone,22), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2217, ps{p(proj_utm), p(zone,23), p(ellps_intl), p(units_m), p(no_defs)}),
            //{2218}
            ce(2219, ps{p(proj_utm), p(zone,19), p(a,6378135), p(b,6356750.304921594), p(units_m), p(no_defs)}),
            ce(2220, ps{p(proj_utm), p(zone,20), p(a,6378135), p(b,6356750.304921594), p(units_m), p(no_defs)}),
            //{2221}
            ce(2222, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-110.1666666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2223, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-111.9166666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2224, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-113.75), p(k,0.999933333), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2225, ps{p(proj_lcc), p(lat_1,41.66666666666666), p(lat_2,40), p(lat_0,39.33333333333334), p(lon_0,-122), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2226, ps{p(proj_lcc), p(lat_1,39.83333333333334), p(lat_2,38.33333333333334), p(lat_0,37.66666666666666), p(lon_0,-122), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2227, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.06666666666667), p(lat_0,36.5), p(lon_0,-120.5), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2228, ps{p(proj_lcc), p(lat_1,37.25), p(lat_2,36), p(lat_0,35.33333333333334), p(lon_0,-119), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2229, ps{p(proj_lcc), p(lat_1,35.46666666666667), p(lat_2,34.03333333333333), p(lat_0,33.5), p(lon_0,-118), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2230, ps{p(proj_lcc), p(lat_1,33.88333333333333), p(lat_2,32.78333333333333), p(lat_0,32.16666666666666), p(lon_0,-116.25), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2231, ps{p(proj_lcc), p(lat_1,40.78333333333333), p(lat_2,39.71666666666667), p(lat_0,39.33333333333334), p(lon_0,-105.5), p(x_0,914401.8288036576), p(y_0,304800.6096012192), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2232, ps{p(proj_lcc), p(lat_1,39.75), p(lat_2,38.45), p(lat_0,37.83333333333334), p(lon_0,-105.5), p(x_0,914401.8288036576), p(y_0,304800.6096012192), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2233, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.23333333333333), p(lat_0,36.66666666666666), p(lon_0,-105.5), p(x_0,914401.8288036576), p(y_0,304800.6096012192), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2234, ps{p(proj_lcc), p(lat_1,41.86666666666667), p(lat_2,41.2), p(lat_0,40.83333333333334), p(lon_0,-72.75), p(x_0,304800.6096012192), p(y_0,152400.3048006096), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2235, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,-75.41666666666667), p(k,0.999995), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2236, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-81), p(k,0.999941177), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2237, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-82), p(k,0.999941177), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2238, ps{p(proj_lcc), p(lat_1,30.75), p(lat_2,29.58333333333333), p(lat_0,29), p(lon_0,-84.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2239, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-82.16666666666667), p(k,0.9999), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2240, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-84.16666666666667), p(k,0.9999), p(x_0,699999.9998983998), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2241, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-112.1666666666667), p(k,0.9999473679999999), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2242, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-114), p(k,0.9999473679999999), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2243, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-115.75), p(k,0.999933333), p(x_0,800000.0001016001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2244, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.999966667), p(x_0,99999.99989839978), p(y_0,249364.9987299975), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2245, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.999966667), p(x_0,900000), p(y_0,249364.9987299975), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2246, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,38.96666666666667), p(lat_0,37.5), p(lon_0,-84.25), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2247, ps{p(proj_lcc), p(lat_1,37.93333333333333), p(lat_2,36.73333333333333), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,500000.0001016001), p(y_0,500000.0001016001), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2248, ps{p(proj_lcc), p(lat_1,39.45), p(lat_2,38.3), p(lat_0,37.66666666666666), p(lon_0,-77), p(x_0,399999.9998983998), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2249, ps{p(proj_lcc), p(lat_1,42.68333333333333), p(lat_2,41.71666666666667), p(lat_0,41), p(lon_0,-71.5), p(x_0,200000.0001016002), p(y_0,750000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2250, ps{p(proj_lcc), p(lat_1,41.48333333333333), p(lat_2,41.28333333333333), p(lat_0,41), p(lon_0,-70.5), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2251, ps{p(proj_lcc), p(lat_1,47.08333333333334), p(lat_2,45.48333333333333), p(lat_0,44.78333333333333), p(lon_0,-87), p(x_0,7999999.999968001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2252, ps{p(proj_lcc), p(lat_1,45.7), p(lat_2,44.18333333333333), p(lat_0,43.31666666666667), p(lon_0,-84.36666666666666), p(x_0,5999999.999976001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2253, ps{p(proj_lcc), p(lat_1,43.66666666666666), p(lat_2,42.1), p(lat_0,41.5), p(lon_0,-84.36666666666666), p(x_0,3999999.999984), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2254, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-88.83333333333333), p(k,0.99995), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2255, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-90.33333333333333), p(k,0.99995), p(x_0,699999.9998983998), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2256, ps{p(proj_lcc), p(lat_1,49), p(lat_2,45), p(lat_0,44.25), p(lon_0,-109.5), p(x_0,599999.9999976), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2257, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-104.3333333333333), p(k,0.999909091), p(x_0,165000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2258, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-106.25), p(k,0.9999), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2259, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-107.8333333333333), p(k,0.999916667), p(x_0,830000.0001016001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2260, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2261, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-76.58333333333333), p(k,0.9999375), p(x_0,249999.9998983998), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2262, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-78.58333333333333), p(k,0.9999375), p(x_0,350000.0001016001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2263, ps{p(proj_lcc), p(lat_1,41.03333333333333), p(lat_2,40.66666666666666), p(lat_0,40.16666666666666), p(lon_0,-74), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2264, ps{p(proj_lcc), p(lat_1,36.16666666666666), p(lat_2,34.33333333333334), p(lat_0,33.75), p(lon_0,-79), p(x_0,609601.2192024384), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2265, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.43333333333333), p(lat_0,47), p(lon_0,-100.5), p(x_0,599999.9999976), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2266, ps{p(proj_lcc), p(lat_1,47.48333333333333), p(lat_2,46.18333333333333), p(lat_0,45.66666666666666), p(lon_0,-100.5), p(x_0,599999.9999976), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2267, ps{p(proj_lcc), p(lat_1,36.76666666666667), p(lat_2,35.56666666666667), p(lat_0,35), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2268, ps{p(proj_lcc), p(lat_1,35.23333333333333), p(lat_2,33.93333333333333), p(lat_0,33.33333333333334), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2269, ps{p(proj_lcc), p(lat_1,46), p(lat_2,44.33333333333334), p(lat_0,43.66666666666666), p(lon_0,-120.5), p(x_0,2500000.0001424), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2270, ps{p(proj_lcc), p(lat_1,44), p(lat_2,42.33333333333334), p(lat_0,41.66666666666666), p(lon_0,-120.5), p(x_0,1500000.0001464), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2271, ps{p(proj_lcc), p(lat_1,41.95), p(lat_2,40.88333333333333), p(lat_0,40.16666666666666), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2272, ps{p(proj_lcc), p(lat_1,40.96666666666667), p(lat_2,39.93333333333333), p(lat_0,39.33333333333334), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2273, ps{p(proj_lcc), p(lat_1,34.83333333333334), p(lat_2,32.5), p(lat_0,31.83333333333333), p(lon_0,-81), p(x_0,609600), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2274, ps{p(proj_lcc), p(lat_1,36.41666666666666), p(lat_2,35.25), p(lat_0,34.33333333333334), p(lon_0,-86), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2275, ps{p(proj_lcc), p(lat_1,36.18333333333333), p(lat_2,34.65), p(lat_0,34), p(lon_0,-101.5), p(x_0,200000.0001016002), p(y_0,999999.9998983998), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2276, ps{p(proj_lcc), p(lat_1,33.96666666666667), p(lat_2,32.13333333333333), p(lat_0,31.66666666666667), p(lon_0,-98.5), p(x_0,600000), p(y_0,2000000.0001016), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2277, ps{p(proj_lcc), p(lat_1,31.88333333333333), p(lat_2,30.11666666666667), p(lat_0,29.66666666666667), p(lon_0,-100.3333333333333), p(x_0,699999.9998983998), p(y_0,3000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2278, ps{p(proj_lcc), p(lat_1,30.28333333333333), p(lat_2,28.38333333333333), p(lat_0,27.83333333333333), p(lon_0,-99), p(x_0,600000), p(y_0,3999999.9998984), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2279, ps{p(proj_lcc), p(lat_1,27.83333333333333), p(lat_2,26.16666666666667), p(lat_0,25.66666666666667), p(lon_0,-98.5), p(x_0,300000.0000000001), p(y_0,5000000.0001016), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2280, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.71666666666667), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000.0001504), p(y_0,999999.9999960001), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2281, ps{p(proj_lcc), p(lat_1,40.65), p(lat_2,39.01666666666667), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000.0001504), p(y_0,1999999.999992), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2282, ps{p(proj_lcc), p(lat_1,38.35), p(lat_2,37.21666666666667), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000.0001504), p(y_0,2999999.999988), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2283, ps{p(proj_lcc), p(lat_1,39.2), p(lat_2,38.03333333333333), p(lat_0,37.66666666666666), p(lon_0,-78.5), p(x_0,3500000.0001016), p(y_0,2000000.0001016), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2284, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,36.76666666666667), p(lat_0,36.33333333333334), p(lon_0,-78.5), p(x_0,3500000.0001016), p(y_0,999999.9998983998), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2285, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.5), p(lat_0,47), p(lon_0,-120.8333333333333), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2286, ps{p(proj_lcc), p(lat_1,47.33333333333334), p(lat_2,45.83333333333334), p(lat_0,45.33333333333334), p(lon_0,-120.5), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2287, ps{p(proj_lcc), p(lat_1,46.76666666666667), p(lat_2,45.56666666666667), p(lat_0,45.16666666666666), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2288, ps{p(proj_lcc), p(lat_1,45.5), p(lat_2,44.25), p(lat_0,43.83333333333334), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2289, ps{p(proj_lcc), p(lat_1,44.06666666666667), p(lat_2,42.73333333333333), p(lat_0,42), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2290, ps{p(proj_sterea), p(lat_0,47.25), p(lon_0,-63), p(k,0.999912), p(x_0,700000), p(y_0,400000), p(a,6378135), p(b,6356750.304921594), p(units_m), p(no_defs)}),
            ce(2291, ps{p(proj_sterea), p(lat_0,47.25), p(lon_0,-63), p(k,0.999912), p(x_0,400000), p(y_0,800000), p(a,6378135), p(b,6356750.304921594), p(units_m), p(no_defs)}),
            ce(2292, ps{p(proj_sterea), p(lat_0,47.25), p(lon_0,-63), p(k,0.999912), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2294, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-61.5), p(k,0.9999), p(x_0,4500000), p(y_0,0), p(a,6378135), p(b,6356750.304921594), p(units_m), p(no_defs)}),
            ce(2295, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-64.5), p(k,0.9999), p(x_0,5500000), p(y_0,0), p(a,6378135), p(b,6356750.304921594), p(units_m), p(no_defs)}),
            //{2296}
            //{2297}
            //{2298}
            //{2299}
            //{2300}
            //{2301}
            //{2302}
            //{2303}
            //{2304}
            //{2305}
            //{2306}
            //{2307}
            ce(2308, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,109), p(k,0.9996), p(x_0,500000), p(y_0,10000000), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(2309, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,116), p(k,0.9996), p(x_0,500000), p(y_0,10000000), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(2310, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,132), p(k,0.9996), p(x_0,500000), p(y_0,10000000), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(2311, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,6), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(2312, ps{p(proj_utm), p(zone,33), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(2313, ps{p(proj_utm), p(zone,33), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(2314, ps{p(proj_cass), p(lat_0,10.44166666666667), p(lon_0,-61.33333333333334), p(x_0,86501.46392052001), p(y_0,65379.0134283), p(a,6378293.645208759), p(b,6356617.987679838), p(to_meter,0.3047972654), p(no_defs)}),
            ce(2315, ps{p(proj_utm), p(zone,19), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2316, ps{p(proj_utm), p(zone,20), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2317, ps{p(proj_lcc), p(lat_1,9), p(lat_2,3), p(lat_0,6), p(lon_0,-66), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2318, ps{p(proj_lcc), p(lat_1,17), p(lat_2,33), p(lat_0,25.08951), p(lon_0,48), p(x_0,0), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2319, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2320, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,30), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2321, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2322, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,36), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2323, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2324, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,42), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2325, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2326, ps{p(proj_tmerc), p(lat_0,22.31213333333334), p(lon_0,114.1785555555556), p(k,1), p(x_0,836694.05), p(y_0,819069.8), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425}),
            ce(2327, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,13500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2328, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,14500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2329, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,15500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2330, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,16500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2331, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,17500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2332, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,18500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2333, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,19500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2334, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,20500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2335, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,21500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2336, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,22500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2337, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,23500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2338, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2339, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2340, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2341, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2342, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2343, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2344, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2345, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2346, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2347, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2348, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2349, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,25500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2350, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,78), p(k,1), p(x_0,26500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2351, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,27500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2352, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,84), p(k,1), p(x_0,28500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2353, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,29500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2354, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,90), p(k,1), p(x_0,30500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2355, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,31500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2356, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,96), p(k,1), p(x_0,32500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2357, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,33500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2358, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,102), p(k,1), p(x_0,34500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2359, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,35500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2360, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,108), p(k,1), p(x_0,36500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2361, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,37500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2362, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,114), p(k,1), p(x_0,38500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2363, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,39500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2364, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,120), p(k,1), p(x_0,40500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2365, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,41500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2366, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,126), p(k,1), p(x_0,42500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2367, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,43500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2368, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,132), p(k,1), p(x_0,44500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2369, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,45500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2370, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2371, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,78), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2372, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2373, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,84), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2374, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2375, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,90), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2376, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2377, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,96), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2378, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2379, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,102), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2380, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2381, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,108), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2382, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2383, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,114), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2384, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2385, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,120), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2386, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2387, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,126), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2388, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2389, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,132), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2390, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(a,6378140), p(b,6356755.288157528), p(units_m), p(no_defs)}),
            ce(2391, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2392, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,1), p(x_0,2500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2393, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2394, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,30), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2395, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,8500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{-76,-138,67,0,0,0,0}),
            ce(2396, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,9500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{-76,-138,67,0,0,0,0}),
            ce(2397, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{24,-123,-94,0.02,-0.25,-0.13,1.1}),
            ce(2398, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{24,-123,-94,0.02,-0.25,-0.13,1.1}),
            ce(2399, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{24,-123,-94,0.02,-0.25,-0.13,1.1}),
            ce(2400, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15.80827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(2401, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,25500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2402, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,78), p(k,1), p(x_0,26500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2403, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,27500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2404, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,84), p(k,1), p(x_0,28500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2405, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,29500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2406, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,90), p(k,1), p(x_0,30500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2407, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,31500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2408, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,96), p(k,1), p(x_0,32500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2409, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,33500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2410, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,102), p(k,1), p(x_0,34500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2411, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,35500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2412, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,108), p(k,1), p(x_0,36500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2413, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,37500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2414, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,114), p(k,1), p(x_0,38500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2415, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,39500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2416, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,120), p(k,1), p(x_0,40500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2417, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,41500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2418, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,126), p(k,1), p(x_0,42500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2419, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,43500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2420, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,132), p(k,1), p(x_0,44500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2421, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,45500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2422, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2423, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,78), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2424, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2425, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,84), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2426, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2427, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,90), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2428, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2429, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,96), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2430, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2431, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,102), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2432, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2433, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,108), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2434, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2435, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,114), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2436, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2437, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,120), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2438, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2439, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,126), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2440, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2441, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,132), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2442, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2443, ps{p(proj_tmerc), p(lat_0,33), p(lon_0,129.5), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2444, ps{p(proj_tmerc), p(lat_0,33), p(lon_0,131), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2445, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,132.1666666666667), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2446, ps{p(proj_tmerc), p(lat_0,33), p(lon_0,133.5), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2447, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,134.3333333333333), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2448, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,136), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2449, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,137.1666666666667), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2450, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,138.5), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2451, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,139.8333333333333), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2452, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,140.8333333333333), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2453, ps{p(proj_tmerc), p(lat_0,44), p(lon_0,140.25), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2454, ps{p(proj_tmerc), p(lat_0,44), p(lon_0,142.25), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2455, ps{p(proj_tmerc), p(lat_0,44), p(lon_0,144.25), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2456, ps{p(proj_tmerc), p(lat_0,26), p(lon_0,142), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2457, ps{p(proj_tmerc), p(lat_0,26), p(lon_0,127.5), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2458, ps{p(proj_tmerc), p(lat_0,26), p(lon_0,124), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2459, ps{p(proj_tmerc), p(lat_0,26), p(lon_0,131), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2460, ps{p(proj_tmerc), p(lat_0,20), p(lon_0,136), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2461, ps{p(proj_tmerc), p(lat_0,26), p(lon_0,154), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2462, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2463, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2464, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2465, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2466, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2467, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2468, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2469, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,57), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2470, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,63), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2471, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,69), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2472, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2473, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2474, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2475, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2476, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2477, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2478, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2479, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2480, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2481, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2482, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2483, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,141), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2484, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,147), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2485, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,153), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2486, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,159), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2487, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,165), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2488, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2489, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2490, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2491, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2492, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2493, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2494, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2495, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2496, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2497, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2498, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2499, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2500, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,57), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2501, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,63), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2502, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,69), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2503, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2504, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2505, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2506, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2507, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2508, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2509, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2510, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2511, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2512, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2513, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2514, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,141), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2515, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,147), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2516, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,153), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2517, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,159), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2518, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,165), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2519, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2520, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2521, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2522, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2523, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,7500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2524, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,1), p(x_0,8500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2525, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,9500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2526, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,30), p(k,1), p(x_0,10500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2527, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,11500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2528, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,36), p(k,1), p(x_0,12500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2529, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,13500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2530, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,42), p(k,1), p(x_0,14500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2531, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,15500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2532, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,48), p(k,1), p(x_0,16500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2533, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,17500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2534, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,54), p(k,1), p(x_0,18500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2535, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,57), p(k,1), p(x_0,19500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2536, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,60), p(k,1), p(x_0,20500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2537, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,63), p(k,1), p(x_0,21500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2538, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,66), p(k,1), p(x_0,22500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2539, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,69), p(k,1), p(x_0,23500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2540, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,72), p(k,1), p(x_0,24500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2541, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,25500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2542, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,78), p(k,1), p(x_0,26500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2543, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,27500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2544, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,84), p(k,1), p(x_0,28500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2545, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,29500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2546, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,90), p(k,1), p(x_0,30500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2547, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,31500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2548, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,96), p(k,1), p(x_0,32500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2549, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,33500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2550, ps{p(proj_utm), p(zone,50), p(south), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{-404.78,685.68,45.47,0,0,0,0}),
            ce(2551, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,102), p(k,1), p(x_0,34500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2552, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,35500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2553, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,108), p(k,1), p(x_0,36500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2554, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,37500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2555, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,114), p(k,1), p(x_0,38500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2556, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,39500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2557, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,120), p(k,1), p(x_0,40500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2558, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,41500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2559, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,126), p(k,1), p(x_0,42500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2560, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,43500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2561, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,132), p(k,1), p(x_0,44500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2562, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,45500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2563, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,138), p(k,1), p(x_0,46500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2564, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,141), p(k,1), p(x_0,47500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2565, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,144), p(k,1), p(x_0,48500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2566, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,147), p(k,1), p(x_0,49500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2567, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,150), p(k,1), p(x_0,50500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2568, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,153), p(k,1), p(x_0,51500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2569, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,156), p(k,1), p(x_0,52500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2570, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,159), p(k,1), p(x_0,53500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2571, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,162), p(k,1), p(x_0,54500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2572, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,165), p(k,1), p(x_0,55500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2573, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,168), p(k,1), p(x_0,56500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2574, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,171), p(k,1), p(x_0,57500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2575, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,174), p(k,1), p(x_0,58500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2576, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,177), p(k,1), p(x_0,59500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2577, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,180), p(k,1), p(x_0,60000000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2578, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-177), p(k,1), p(x_0,61500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2579, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-174), p(k,1), p(x_0,62500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2580, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-171), p(k,1), p(x_0,63500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2581, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-168), p(k,1), p(x_0,64500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2582, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2583, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2584, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2585, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,30), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2586, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2587, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,36), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2588, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2589, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,42), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2590, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2591, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,48), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2592, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2593, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,54), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2594, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,57), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2595, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,60), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2596, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,63), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2597, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,66), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2598, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,69), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2599, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,72), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2600, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,0.9998), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2601, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2602, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,78), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2603, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2604, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,84), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2605, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2606, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,90), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2607, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2608, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,96), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2609, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2610, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,102), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2611, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2612, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,108), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2613, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2614, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,114), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2615, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2616, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,120), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2617, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2618, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,126), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2619, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2620, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,132), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2621, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2622, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,138), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2623, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,141), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2624, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,144), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2625, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,147), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2626, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,150), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2627, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,153), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2628, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,156), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2629, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,159), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2630, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,162), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2631, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,165), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2632, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,168), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2633, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2634, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,174), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2635, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2636, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,180), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2637, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2638, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-174), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2639, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2640, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-168), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2641, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,7500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2642, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,1), p(x_0,8500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2643, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,9500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2644, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,30), p(k,1), p(x_0,10500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2645, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,11500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2646, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,36), p(k,1), p(x_0,12500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2647, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,13500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2648, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,42), p(k,1), p(x_0,14500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2649, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,15500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2650, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,48), p(k,1), p(x_0,16500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2651, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,17500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2652, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,54), p(k,1), p(x_0,18500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2653, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,57), p(k,1), p(x_0,19500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2654, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,60), p(k,1), p(x_0,20500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2655, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,63), p(k,1), p(x_0,21500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2656, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,66), p(k,1), p(x_0,22500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2657, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,69), p(k,1), p(x_0,23500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2658, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,72), p(k,1), p(x_0,24500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2659, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,25500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2660, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,78), p(k,1), p(x_0,26500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2661, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,27500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2662, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,84), p(k,1), p(x_0,28500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2663, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,29500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2664, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,90), p(k,1), p(x_0,30500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2665, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,31500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2666, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,96), p(k,1), p(x_0,32500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2667, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,33500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2668, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,102), p(k,1), p(x_0,34500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2669, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,35500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2670, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,108), p(k,1), p(x_0,36500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2671, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,37500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2672, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,114), p(k,1), p(x_0,38500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2673, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,39500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2674, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,120), p(k,1), p(x_0,40500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2675, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,41500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2676, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,126), p(k,1), p(x_0,42500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2677, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,43500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2678, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,132), p(k,1), p(x_0,44500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2679, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,45500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2680, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,138), p(k,1), p(x_0,46500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2681, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,141), p(k,1), p(x_0,47500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2682, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,144), p(k,1), p(x_0,48500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2683, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,147), p(k,1), p(x_0,49500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2684, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,150), p(k,1), p(x_0,50500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2685, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,153), p(k,1), p(x_0,51500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2686, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,156), p(k,1), p(x_0,52500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2687, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,159), p(k,1), p(x_0,53500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2688, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,162), p(k,1), p(x_0,54500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2689, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,165), p(k,1), p(x_0,55500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2690, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,168), p(k,1), p(x_0,56500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2691, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,171), p(k,1), p(x_0,57500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2692, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,174), p(k,1), p(x_0,58500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2693, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,177), p(k,1), p(x_0,59500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2694, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,180), p(k,1), p(x_0,60000000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2695, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-177), p(k,1), p(x_0,61500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2696, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-174), p(k,1), p(x_0,62500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2697, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-171), p(k,1), p(x_0,63500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2698, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-168), p(k,1), p(x_0,64500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2699, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2700, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2701, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2702, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,30), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2703, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2704, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,36), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2705, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2706, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,42), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2707, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2708, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,48), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2709, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2710, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,54), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2711, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,57), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2712, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,60), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2713, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,63), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2714, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,66), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2715, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,69), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2716, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,72), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2717, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2718, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,78), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2719, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2720, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,84), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2721, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2722, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,90), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2723, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2724, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,96), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2725, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2726, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,102), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2727, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2728, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,108), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2729, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2730, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,114), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2731, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2732, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,120), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2733, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2734, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,126), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2735, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2736, ps{p(proj_utm), p(zone,36), p(south), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2737, ps{p(proj_utm), p(zone,37), p(south), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(2738, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,132), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2739, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2740, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,138), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2741, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,141), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2742, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,144), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2743, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,147), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2744, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,150), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2745, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,153), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2746, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,156), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2747, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,159), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2748, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,162), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2749, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,165), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2750, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,168), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2751, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2752, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,174), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2753, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2754, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,180), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2755, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2756, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-174), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2757, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2758, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-168), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2759, ps{p(proj_tmerc), p(lat_0,30.5), p(lon_0,-85.83333333333333), p(k,0.99996), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2760, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-87.5), p(k,0.999933333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2761, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-110.1666666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2762, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-111.9166666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2763, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-113.75), p(k,0.999933333), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2764, ps{p(proj_lcc), p(lat_1,36.23333333333333), p(lat_2,34.93333333333333), p(lat_0,34.33333333333334), p(lon_0,-92), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2765, ps{p(proj_lcc), p(lat_1,34.76666666666667), p(lat_2,33.3), p(lat_0,32.66666666666666), p(lon_0,-92), p(x_0,400000), p(y_0,400000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2766, ps{p(proj_lcc), p(lat_1,41.66666666666666), p(lat_2,40), p(lat_0,39.33333333333334), p(lon_0,-122), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2767, ps{p(proj_lcc), p(lat_1,39.83333333333334), p(lat_2,38.33333333333334), p(lat_0,37.66666666666666), p(lon_0,-122), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2768, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.06666666666667), p(lat_0,36.5), p(lon_0,-120.5), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2769, ps{p(proj_lcc), p(lat_1,37.25), p(lat_2,36), p(lat_0,35.33333333333334), p(lon_0,-119), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2770, ps{p(proj_lcc), p(lat_1,35.46666666666667), p(lat_2,34.03333333333333), p(lat_0,33.5), p(lon_0,-118), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2771, ps{p(proj_lcc), p(lat_1,33.88333333333333), p(lat_2,32.78333333333333), p(lat_0,32.16666666666666), p(lon_0,-116.25), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2772, ps{p(proj_lcc), p(lat_1,40.78333333333333), p(lat_2,39.71666666666667), p(lat_0,39.33333333333334), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2773, ps{p(proj_lcc), p(lat_1,39.75), p(lat_2,38.45), p(lat_0,37.83333333333334), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2774, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.23333333333333), p(lat_0,36.66666666666666), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2775, ps{p(proj_lcc), p(lat_1,41.86666666666667), p(lat_2,41.2), p(lat_0,40.83333333333334), p(lon_0,-72.75), p(x_0,304800.6096), p(y_0,152400.3048), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2776, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,-75.41666666666667), p(k,0.999995), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2777, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-81), p(k,0.999941177), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2778, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-82), p(k,0.999941177), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2779, ps{p(proj_lcc), p(lat_1,30.75), p(lat_2,29.58333333333333), p(lat_0,29), p(lon_0,-84.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2780, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-82.16666666666667), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2781, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-84.16666666666667), p(k,0.9999), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2782, ps{p(proj_tmerc), p(lat_0,18.83333333333333), p(lon_0,-155.5), p(k,0.999966667), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2783, ps{p(proj_tmerc), p(lat_0,20.33333333333333), p(lon_0,-156.6666666666667), p(k,0.999966667), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2784, ps{p(proj_tmerc), p(lat_0,21.16666666666667), p(lon_0,-158), p(k,0.99999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2785, ps{p(proj_tmerc), p(lat_0,21.83333333333333), p(lon_0,-159.5), p(k,0.99999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2786, ps{p(proj_tmerc), p(lat_0,21.66666666666667), p(lon_0,-160.1666666666667), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2787, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-112.1666666666667), p(k,0.9999473679999999), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2788, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-114), p(k,0.9999473679999999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2789, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-115.75), p(k,0.999933333), p(x_0,800000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2790, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-88.33333333333333), p(k,0.9999749999999999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2791, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-90.16666666666667), p(k,0.999941177), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2792, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.999966667), p(x_0,100000), p(y_0,250000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2793, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.999966667), p(x_0,900000), p(y_0,250000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2794, ps{p(proj_lcc), p(lat_1,43.26666666666667), p(lat_2,42.06666666666667), p(lat_0,41.5), p(lon_0,-93.5), p(x_0,1500000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2795, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.61666666666667), p(lat_0,40), p(lon_0,-93.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2796, ps{p(proj_lcc), p(lat_1,39.78333333333333), p(lat_2,38.71666666666667), p(lat_0,38.33333333333334), p(lon_0,-98), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2797, ps{p(proj_lcc), p(lat_1,38.56666666666667), p(lat_2,37.26666666666667), p(lat_0,36.66666666666666), p(lon_0,-98.5), p(x_0,400000), p(y_0,400000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2798, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,38.96666666666667), p(lat_0,37.5), p(lon_0,-84.25), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2799, ps{p(proj_lcc), p(lat_1,37.93333333333333), p(lat_2,36.73333333333333), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,500000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2800, ps{p(proj_lcc), p(lat_1,32.66666666666666), p(lat_2,31.16666666666667), p(lat_0,30.5), p(lon_0,-92.5), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2801, ps{p(proj_lcc), p(lat_1,30.7), p(lat_2,29.3), p(lat_0,28.5), p(lon_0,-91.33333333333333), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2802, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2803, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.999966667), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2804, ps{p(proj_lcc), p(lat_1,39.45), p(lat_2,38.3), p(lat_0,37.66666666666666), p(lon_0,-77), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2805, ps{p(proj_lcc), p(lat_1,42.68333333333333), p(lat_2,41.71666666666667), p(lat_0,41), p(lon_0,-71.5), p(x_0,200000), p(y_0,750000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2806, ps{p(proj_lcc), p(lat_1,41.48333333333333), p(lat_2,41.28333333333333), p(lat_0,41), p(lon_0,-70.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2807, ps{p(proj_lcc), p(lat_1,47.08333333333334), p(lat_2,45.48333333333333), p(lat_0,44.78333333333333), p(lon_0,-87), p(x_0,8000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2808, ps{p(proj_lcc), p(lat_1,45.7), p(lat_2,44.18333333333333), p(lat_0,43.31666666666667), p(lon_0,-84.36666666666666), p(x_0,6000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2809, ps{p(proj_lcc), p(lat_1,43.66666666666666), p(lat_2,42.1), p(lat_0,41.5), p(lon_0,-84.36666666666666), p(x_0,4000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2810, ps{p(proj_lcc), p(lat_1,48.63333333333333), p(lat_2,47.03333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2811, ps{p(proj_lcc), p(lat_1,47.05), p(lat_2,45.61666666666667), p(lat_0,45), p(lon_0,-94.25), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2812, ps{p(proj_lcc), p(lat_1,45.21666666666667), p(lat_2,43.78333333333333), p(lat_0,43), p(lon_0,-94), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2813, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-88.83333333333333), p(k,0.99995), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2814, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-90.33333333333333), p(k,0.99995), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2815, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-90.5), p(k,0.999933333), p(x_0,250000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2816, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-92.5), p(k,0.999933333), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2817, ps{p(proj_tmerc), p(lat_0,36.16666666666666), p(lon_0,-94.5), p(k,0.999941177), p(x_0,850000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2818, ps{p(proj_lcc), p(lat_1,49), p(lat_2,45), p(lat_0,44.25), p(lon_0,-109.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2819, ps{p(proj_lcc), p(lat_1,43), p(lat_2,40), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2820, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-115.5833333333333), p(k,0.9999), p(x_0,200000), p(y_0,8000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2821, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-116.6666666666667), p(k,0.9999), p(x_0,500000), p(y_0,6000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2822, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-118.5833333333333), p(k,0.9999), p(x_0,800000), p(y_0,4000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2823, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-71.66666666666667), p(k,0.999966667), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2824, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2825, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-104.3333333333333), p(k,0.999909091), p(x_0,165000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2826, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-106.25), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2827, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-107.8333333333333), p(k,0.999916667), p(x_0,830000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2828, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2829, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-76.58333333333333), p(k,0.9999375), p(x_0,250000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2830, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-78.58333333333333), p(k,0.9999375), p(x_0,350000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2831, ps{p(proj_lcc), p(lat_1,41.03333333333333), p(lat_2,40.66666666666666), p(lat_0,40.16666666666666), p(lon_0,-74), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2832, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.43333333333333), p(lat_0,47), p(lon_0,-100.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2833, ps{p(proj_lcc), p(lat_1,47.48333333333333), p(lat_2,46.18333333333333), p(lat_0,45.66666666666666), p(lon_0,-100.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2834, ps{p(proj_lcc), p(lat_1,41.7), p(lat_2,40.43333333333333), p(lat_0,39.66666666666666), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2835, ps{p(proj_lcc), p(lat_1,40.03333333333333), p(lat_2,38.73333333333333), p(lat_0,38), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2836, ps{p(proj_lcc), p(lat_1,36.76666666666667), p(lat_2,35.56666666666667), p(lat_0,35), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2837, ps{p(proj_lcc), p(lat_1,35.23333333333333), p(lat_2,33.93333333333333), p(lat_0,33.33333333333334), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2838, ps{p(proj_lcc), p(lat_1,46), p(lat_2,44.33333333333334), p(lat_0,43.66666666666666), p(lon_0,-120.5), p(x_0,2500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2839, ps{p(proj_lcc), p(lat_1,44), p(lat_2,42.33333333333334), p(lat_0,41.66666666666666), p(lon_0,-120.5), p(x_0,1500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2840, ps{p(proj_tmerc), p(lat_0,41.08333333333334), p(lon_0,-71.5), p(k,0.99999375), p(x_0,100000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2841, ps{p(proj_lcc), p(lat_1,45.68333333333333), p(lat_2,44.41666666666666), p(lat_0,43.83333333333334), p(lon_0,-100), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2842, ps{p(proj_lcc), p(lat_1,44.4), p(lat_2,42.83333333333334), p(lat_0,42.33333333333334), p(lon_0,-100.3333333333333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2843, ps{p(proj_lcc), p(lat_1,36.41666666666666), p(lat_2,35.25), p(lat_0,34.33333333333334), p(lon_0,-86), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2844, ps{p(proj_lcc), p(lat_1,36.18333333333333), p(lat_2,34.65), p(lat_0,34), p(lon_0,-101.5), p(x_0,200000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2845, ps{p(proj_lcc), p(lat_1,33.96666666666667), p(lat_2,32.13333333333333), p(lat_0,31.66666666666667), p(lon_0,-98.5), p(x_0,600000), p(y_0,2000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2846, ps{p(proj_lcc), p(lat_1,31.88333333333333), p(lat_2,30.11666666666667), p(lat_0,29.66666666666667), p(lon_0,-100.3333333333333), p(x_0,700000), p(y_0,3000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2847, ps{p(proj_lcc), p(lat_1,30.28333333333333), p(lat_2,28.38333333333333), p(lat_0,27.83333333333333), p(lon_0,-99), p(x_0,600000), p(y_0,4000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2848, ps{p(proj_lcc), p(lat_1,27.83333333333333), p(lat_2,26.16666666666667), p(lat_0,25.66666666666667), p(lon_0,-98.5), p(x_0,300000), p(y_0,5000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2849, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.71666666666667), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2850, ps{p(proj_lcc), p(lat_1,40.65), p(lat_2,39.01666666666667), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000), p(y_0,2000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2851, ps{p(proj_lcc), p(lat_1,38.35), p(lat_2,37.21666666666667), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000), p(y_0,3000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2852, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-72.5), p(k,0.999964286), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2853, ps{p(proj_lcc), p(lat_1,39.2), p(lat_2,38.03333333333333), p(lat_0,37.66666666666666), p(lon_0,-78.5), p(x_0,3500000), p(y_0,2000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2854, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,36.76666666666667), p(lat_0,36.33333333333334), p(lon_0,-78.5), p(x_0,3500000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2855, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.5), p(lat_0,47), p(lon_0,-120.8333333333333), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2856, ps{p(proj_lcc), p(lat_1,47.33333333333334), p(lat_2,45.83333333333334), p(lat_0,45.33333333333334), p(lon_0,-120.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2857, ps{p(proj_lcc), p(lat_1,40.25), p(lat_2,39), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2858, ps{p(proj_lcc), p(lat_1,38.88333333333333), p(lat_2,37.48333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2859, ps{p(proj_lcc), p(lat_1,46.76666666666667), p(lat_2,45.56666666666667), p(lat_0,45.16666666666666), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2860, ps{p(proj_lcc), p(lat_1,45.5), p(lat_2,44.25), p(lat_0,43.83333333333334), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2861, ps{p(proj_lcc), p(lat_1,44.06666666666667), p(lat_2,42.73333333333333), p(lat_0,42), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2862, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-105.1666666666667), p(k,0.9999375), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2863, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-107.3333333333333), p(k,0.9999375), p(x_0,400000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2864, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-108.75), p(k,0.9999375), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2865, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-110.0833333333333), p(k,0.9999375), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2866, ps{p(proj_lcc), p(lat_1,18.43333333333333), p(lat_2,18.03333333333333), p(lat_0,17.83333333333333), p(lon_0,-66.43333333333334), p(x_0,200000), p(y_0,200000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2867, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-110.1666666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2868, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-111.9166666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2869, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-113.75), p(k,0.999933333), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2870, ps{p(proj_lcc), p(lat_1,41.66666666666666), p(lat_2,40), p(lat_0,39.33333333333334), p(lon_0,-122), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2871, ps{p(proj_lcc), p(lat_1,39.83333333333334), p(lat_2,38.33333333333334), p(lat_0,37.66666666666666), p(lon_0,-122), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2872, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.06666666666667), p(lat_0,36.5), p(lon_0,-120.5), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2873, ps{p(proj_lcc), p(lat_1,37.25), p(lat_2,36), p(lat_0,35.33333333333334), p(lon_0,-119), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2874, ps{p(proj_lcc), p(lat_1,35.46666666666667), p(lat_2,34.03333333333333), p(lat_0,33.5), p(lon_0,-118), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2875, ps{p(proj_lcc), p(lat_1,33.88333333333333), p(lat_2,32.78333333333333), p(lat_0,32.16666666666666), p(lon_0,-116.25), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2876, ps{p(proj_lcc), p(lat_1,40.78333333333333), p(lat_2,39.71666666666667), p(lat_0,39.33333333333334), p(lon_0,-105.5), p(x_0,914401.8288036576), p(y_0,304800.6096012192), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2877, ps{p(proj_lcc), p(lat_1,39.75), p(lat_2,38.45), p(lat_0,37.83333333333334), p(lon_0,-105.5), p(x_0,914401.8288036576), p(y_0,304800.6096012192), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2878, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.23333333333333), p(lat_0,36.66666666666666), p(lon_0,-105.5), p(x_0,914401.8288036576), p(y_0,304800.6096012192), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2879, ps{p(proj_lcc), p(lat_1,41.86666666666667), p(lat_2,41.2), p(lat_0,40.83333333333334), p(lon_0,-72.75), p(x_0,304800.6096012192), p(y_0,152400.3048006096), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2880, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,-75.41666666666667), p(k,0.999995), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2881, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-81), p(k,0.999941177), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2882, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-82), p(k,0.999941177), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2883, ps{p(proj_lcc), p(lat_1,30.75), p(lat_2,29.58333333333333), p(lat_0,29), p(lon_0,-84.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2884, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-82.16666666666667), p(k,0.9999), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2885, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-84.16666666666667), p(k,0.9999), p(x_0,699999.9998983998), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2886, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-112.1666666666667), p(k,0.9999473679999999), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2887, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-114), p(k,0.9999473679999999), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2888, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-115.75), p(k,0.999933333), p(x_0,800000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2889, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.999966667), p(x_0,99999.99989839978), p(y_0,249364.9987299975), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2890, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.999966667), p(x_0,900000), p(y_0,249364.9987299975), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2891, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,38.96666666666667), p(lat_0,37.5), p(lon_0,-84.25), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2892, ps{p(proj_lcc), p(lat_1,37.93333333333333), p(lat_2,36.73333333333333), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,500000.0001016001), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2893, ps{p(proj_lcc), p(lat_1,39.45), p(lat_2,38.3), p(lat_0,37.66666666666666), p(lon_0,-77), p(x_0,399999.9998983998), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2894, ps{p(proj_lcc), p(lat_1,42.68333333333333), p(lat_2,41.71666666666667), p(lat_0,41), p(lon_0,-71.5), p(x_0,200000.0001016002), p(y_0,750000), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2895, ps{p(proj_lcc), p(lat_1,41.48333333333333), p(lat_2,41.28333333333333), p(lat_0,41), p(lon_0,-70.5), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2896, ps{p(proj_lcc), p(lat_1,47.08333333333334), p(lat_2,45.48333333333333), p(lat_0,44.78333333333333), p(lon_0,-87), p(x_0,7999999.999968001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2897, ps{p(proj_lcc), p(lat_1,45.7), p(lat_2,44.18333333333333), p(lat_0,43.31666666666667), p(lon_0,-84.36666666666666), p(x_0,5999999.999976001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2898, ps{p(proj_lcc), p(lat_1,43.66666666666666), p(lat_2,42.1), p(lat_0,41.5), p(lon_0,-84.36666666666666), p(x_0,3999999.999984), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2899, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-88.83333333333333), p(k,0.99995), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2900, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-90.33333333333333), p(k,0.99995), p(x_0,699999.9998983998), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2901, ps{p(proj_lcc), p(lat_1,49), p(lat_2,45), p(lat_0,44.25), p(lon_0,-109.5), p(x_0,599999.9999976), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2902, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-104.3333333333333), p(k,0.999909091), p(x_0,165000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2903, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-106.25), p(k,0.9999), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2904, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-107.8333333333333), p(k,0.999916667), p(x_0,830000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2905, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2906, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-76.58333333333333), p(k,0.9999375), p(x_0,249999.9998983998), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2907, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-78.58333333333333), p(k,0.9999375), p(x_0,350000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2908, ps{p(proj_lcc), p(lat_1,41.03333333333333), p(lat_2,40.66666666666666), p(lat_0,40.16666666666666), p(lon_0,-74), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2909, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.43333333333333), p(lat_0,47), p(lon_0,-100.5), p(x_0,599999.9999976), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2910, ps{p(proj_lcc), p(lat_1,47.48333333333333), p(lat_2,46.18333333333333), p(lat_0,45.66666666666666), p(lon_0,-100.5), p(x_0,599999.9999976), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2911, ps{p(proj_lcc), p(lat_1,36.76666666666667), p(lat_2,35.56666666666667), p(lat_0,35), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2912, ps{p(proj_lcc), p(lat_1,35.23333333333333), p(lat_2,33.93333333333333), p(lat_0,33.33333333333334), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2913, ps{p(proj_lcc), p(lat_1,46), p(lat_2,44.33333333333334), p(lat_0,43.66666666666666), p(lon_0,-120.5), p(x_0,2500000.0001424), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2914, ps{p(proj_lcc), p(lat_1,44), p(lat_2,42.33333333333334), p(lat_0,41.66666666666666), p(lon_0,-120.5), p(x_0,1500000.0001464), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2915, ps{p(proj_lcc), p(lat_1,36.41666666666666), p(lat_2,35.25), p(lat_0,34.33333333333334), p(lon_0,-86), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2916, ps{p(proj_lcc), p(lat_1,36.18333333333333), p(lat_2,34.65), p(lat_0,34), p(lon_0,-101.5), p(x_0,200000.0001016002), p(y_0,999999.9998983998), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2917, ps{p(proj_lcc), p(lat_1,33.96666666666667), p(lat_2,32.13333333333333), p(lat_0,31.66666666666667), p(lon_0,-98.5), p(x_0,600000), p(y_0,2000000.0001016), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2918, ps{p(proj_lcc), p(lat_1,31.88333333333333), p(lat_2,30.11666666666667), p(lat_0,29.66666666666667), p(lon_0,-100.3333333333333), p(x_0,699999.9998983998), p(y_0,3000000), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2919, ps{p(proj_lcc), p(lat_1,30.28333333333333), p(lat_2,28.38333333333333), p(lat_0,27.83333333333333), p(lon_0,-99), p(x_0,600000), p(y_0,3999999.9998984), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2920, ps{p(proj_lcc), p(lat_1,27.83333333333333), p(lat_2,26.16666666666667), p(lat_0,25.66666666666667), p(lon_0,-98.5), p(x_0,300000.0000000001), p(y_0,5000000.0001016), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2921, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.71666666666667), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000.0001504), p(y_0,999999.9999960001), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2922, ps{p(proj_lcc), p(lat_1,40.65), p(lat_2,39.01666666666667), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000.0001504), p(y_0,1999999.999992), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2923, ps{p(proj_lcc), p(lat_1,38.35), p(lat_2,37.21666666666667), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000.0001504), p(y_0,2999999.999988), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2924, ps{p(proj_lcc), p(lat_1,39.2), p(lat_2,38.03333333333333), p(lat_0,37.66666666666666), p(lon_0,-78.5), p(x_0,3500000.0001016), p(y_0,2000000.0001016), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2925, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,36.76666666666667), p(lat_0,36.33333333333334), p(lon_0,-78.5), p(x_0,3500000.0001016), p(y_0,999999.9998983998), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2926, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.5), p(lat_0,47), p(lon_0,-120.8333333333333), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2927, ps{p(proj_lcc), p(lat_1,47.33333333333334), p(lat_2,45.83333333333334), p(lat_0,45.33333333333334), p(lon_0,-120.5), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2928, ps{p(proj_lcc), p(lat_1,46.76666666666667), p(lat_2,45.56666666666667), p(lat_0,45.16666666666666), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2929, ps{p(proj_lcc), p(lat_1,45.5), p(lat_2,44.25), p(lat_0,43.83333333333334), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2930, ps{p(proj_lcc), p(lat_1,44.06666666666667), p(lat_2,42.73333333333333), p(lat_0,42), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2931, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,13), p(k,0.9996), p(x_0,500000), p(y_0,0), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{-106,-87,188,0,0,0,0}),
            ce(2932, ps{p(proj_tmerc), p(lat_0,24.45), p(lon_0,51.21666666666667), p(k,0.99999), p(x_0,200000), p(y_0,300000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706}),
            ce(2933, ps{p(proj_utm), p(zone,50), p(south), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(2934, ps{p(proj_merc), p(lon_0,110), p(k,0.997), p(x_0,3900000), p(y_0,900000), p(ellps_bessel), p(pm_jakarta), p(units_m), p(no_defs)}),
            ce(2935, ps{p(proj_tmerc), p(lat_0,0.1166666666666667), p(lon_0,41.53333333333333), p(k,1), p(x_0,1300000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2936, ps{p(proj_tmerc), p(lat_0,0.1166666666666667), p(lon_0,44.53333333333333), p(k,1), p(x_0,2300000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2937, ps{p(proj_tmerc), p(lat_0,0.1166666666666667), p(lon_0,47.53333333333333), p(k,1), p(x_0,3300000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2938, ps{p(proj_tmerc), p(lat_0,0.1166666666666667), p(lon_0,50.53333333333333), p(k,1), p(x_0,4300000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2939, ps{p(proj_tmerc), p(lat_0,0.1333333333333333), p(lon_0,50.76666666666667), p(k,1), p(x_0,2300000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2940, ps{p(proj_tmerc), p(lat_0,0.1333333333333333), p(lon_0,53.76666666666667), p(k,1), p(x_0,3300000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2941, ps{p(proj_tmerc), p(lat_0,0.1333333333333333), p(lon_0,56.76666666666667), p(k,1), p(x_0,4300000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(2942, ps{p(proj_utm), p(zone,28), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-499,-249,314,0,0,0,0}),
            ce(2943, ps{p(proj_utm), p(zone,28), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2944, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-55.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2945, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-58.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2946, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-61.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2947, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-64.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2948, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-67.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2949, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-70.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2950, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-73.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2951, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-76.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2952, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-79.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2953, ps{p(proj_sterea), p(lat_0,46.5), p(lon_0,-66.5), p(k,0.999912), p(x_0,2500000), p(y_0,7500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2954, ps{p(proj_sterea), p(lat_0,47.25), p(lon_0,-63), p(k,0.999912), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2955, ps{p(proj_utm), p(zone,11), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2956, ps{p(proj_utm), p(zone,12), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2957, ps{p(proj_utm), p(zone,13), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2958, ps{p(proj_utm), p(zone,17), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2959, ps{p(proj_utm), p(zone,18), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2960, ps{p(proj_utm), p(zone,19), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2961, ps{p(proj_utm), p(zone,20), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2962, ps{p(proj_utm), p(zone,21), p(ellps_grs80), p(units_m), p(no_defs)}),
            //{2963}
            ce(2964, ps{p(proj_aea), p(lat_1,55), p(lat_2,65), p(lat_0,50), p(lon_0,-154), p(x_0,0), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2965, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.999966667), p(x_0,99999.99989839978), p(y_0,249999.9998983998), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2966, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.999966667), p(x_0,900000), p(y_0,249999.9998983998), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2967, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.999966667), p(x_0,99999.99989839978), p(y_0,249999.9998983998), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2968, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.999966667), p(x_0,900000), p(y_0,249999.9998983998), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(2969, ps{p(proj_utm), p(zone,20), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{137,248,-430,0,0,0,0}),
            ce(2970, ps{p(proj_utm), p(zone,20), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2971, ps{p(proj_utm), p(zone,22), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-186,230,110,0,0,0,0}),
            ce(2972, ps{p(proj_utm), p(zone,22), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{2,2,-2,0,0,0,0}),
            ce(2973, ps{p(proj_utm), p(zone,20), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2975, ps{p(proj_utm), p(zone,40), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2976, ps{p(proj_utm), p(zone,6), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{162,117,154,0,0,0,0}),
            ce(2977, ps{p(proj_utm), p(zone,5), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2978, ps{p(proj_utm), p(zone,7), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2979, ps{p(proj_utm), p(zone,42), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{145,-187,103,0,0,0,0}),
            ce(2980, ps{p(proj_utm), p(zone,38), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-382,-59,-262,0,0,0,0}),
            ce(2981, ps{p(proj_utm), p(zone,58), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2982, ps{p(proj_utm), p(zone,58), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2983, ps{p(proj_utm), p(zone,58), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798}),
            ce(2984, ps{p(proj_lcc), p(lat_1,-20.66666666666667), p(lat_2,-22.33333333333333), p(lat_0,-21.5), p(lon_0,166), p(x_0,400000), p(y_0,300000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            //{2985}
            //{2986}
            ce(2987, ps{p(proj_utm), p(zone,21), p(ellps_clrk66), p(units_m), p(no_defs)}, towgs84{30,430,368,0,0,0,0}),
            ce(2988, ps{p(proj_utm), p(zone,1), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2989, ps{p(proj_utm), p(zone,20), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(2990, ps{p(proj_tmerc), p(lat_0,-21.11666666666667), p(lon_0,55.53333333333333), p(k,1), p(x_0,50000), p(y_0,160000), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2991, ps{p(proj_lcc), p(lat_1,43), p(lat_2,45.5), p(lat_0,41.75), p(lon_0,-120.5), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(2992, ps{p(proj_lcc), p(lat_1,43), p(lat_2,45.5), p(lat_0,41.75), p(lon_0,-120.5), p(x_0,399999.9999984), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048), p(no_defs)}),
            ce(2993, ps{p(proj_lcc), p(lat_1,43), p(lat_2,45.5), p(lat_0,41.75), p(lon_0,-120.5), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(2994, ps{p(proj_lcc), p(lat_1,43), p(lat_2,45.5), p(lat_0,41.75), p(lon_0,-120.5), p(x_0,399999.9999984), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(2995, ps{p(proj_utm), p(zone,58), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2996, ps{p(proj_utm), p(zone,58), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2997, ps{p(proj_utm), p(zone,58), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7}),
            ce(2998, ps{p(proj_utm), p(zone,58), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(2999, ps{p(proj_utm), p(zone,38), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3000, ps{p(proj_merc), p(lon_0,110), p(k,0.997), p(x_0,3900000), p(y_0,900000), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3001, ps{p(proj_merc), p(lon_0,110), p(k,0.997), p(x_0,3900000), p(y_0,900000), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3002, ps{p(proj_merc), p(lon_0,110), p(k,0.997), p(x_0,3900000), p(y_0,900000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{-587.8,519.75,145.76,0,0,0,0}),
            ce(3003, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,0.9996), p(x_0,1500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3004, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,0.9996), p(x_0,2520000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3005, ps{p(proj_aea), p(lat_1,50), p(lat_2,58.5), p(lat_0,45), p(lon_0,-126), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3006, ps{p(proj_utm), p(zone,33), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3007, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3008, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,13.5), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3009, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3010, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,16.5), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3011, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3012, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,14.25), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3013, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15.75), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3014, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,17.25), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3015, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18.75), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3016, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,20.25), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3017, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21.75), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3018, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,23.25), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3019, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,11.30827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3020, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,13.55827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3021, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15.80827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3022, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18.05827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3023, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,20.30827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3024, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,22.55827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3025, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,11.30827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3026, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,13.55827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3027, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15.80827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3028, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18.05827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3029, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,20.30827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3030, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,22.55827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3031, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-71), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3032, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-71), p(lon_0,70), p(k,1), p(x_0,6000000), p(y_0,6000000), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3033, ps{p(proj_lcc), p(lat_1,-68.5), p(lat_2,-74.5), p(lat_0,-50), p(lon_0,70), p(x_0,6000000), p(y_0,6000000), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3034, ps{p(proj_lcc), p(lat_1,35), p(lat_2,65), p(lat_0,52), p(lon_0,10), p(x_0,4000000), p(y_0,2800000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3035, ps{p(proj_laea), p(lat_0,52), p(lon_0,10), p(x_0,4321000), p(y_0,3210000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3036, ps{p(proj_utm), p(zone,36), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,-0,-0,-0,0}),
            ce(3037, ps{p(proj_utm), p(zone,37), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,-0,-0,-0,0}),
            ce(3038, ps{p(proj_utm), p(zone,26), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3039, ps{p(proj_utm), p(zone,27), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3040, ps{p(proj_utm), p(zone,28), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3041, ps{p(proj_utm), p(zone,29), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3042, ps{p(proj_utm), p(zone,30), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3043, ps{p(proj_utm), p(zone,31), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3044, ps{p(proj_utm), p(zone,32), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3045, ps{p(proj_utm), p(zone,33), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3046, ps{p(proj_utm), p(zone,34), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3047, ps{p(proj_utm), p(zone,35), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3048, ps{p(proj_utm), p(zone,36), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3049, ps{p(proj_utm), p(zone,37), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3050, ps{p(proj_utm), p(zone,38), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3051, ps{p(proj_utm), p(zone,39), p(ellps_grs80), p(units_m), p(no_defs)}),
            //{3052}
            //{3053}
            ce(3054, ps{p(proj_utm), p(zone,26), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-73,46,-86,0,0,0,0}),
            ce(3055, ps{p(proj_utm), p(zone,27), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-73,46,-86,0,0,0,0}),
            ce(3056, ps{p(proj_utm), p(zone,28), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-73,46,-86,0,0,0,0}),
            ce(3057, ps{p(proj_lcc), p(lat_1,64.25), p(lat_2,65.75), p(lat_0,65), p(lon_0,-19), p(x_0,500000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3058, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-8.5), p(k,1), p(x_0,50000), p(y_0,-7800000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{982.609,552.753,-540.873,32.3934,-153.257,-96.2266,16.805}),
            ce(3059, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,0.9996), p(x_0,500000), p(y_0,-6000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3060, ps{p(proj_utm), p(zone,58), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3061, ps{p(proj_utm), p(zone,28), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3062, ps{p(proj_utm), p(zone,26), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3063, ps{p(proj_utm), p(zone,26), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3064, ps{p(proj_utm), p(zone,32), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3065, ps{p(proj_utm), p(zone,33), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3066, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,37), p(k,0.9998), p(x_0,500000), p(y_0,-3000000), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3067, ps{p(proj_utm), p(zone,35), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3068, ps{p(proj_cass), p(lat_0,52.41864827777778), p(lon_0,13.62720366666667), p(x_0,40000), p(y_0,10000), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(units_m), p(no_defs)}),
            ce(3069, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-90), p(k,0.9996), p(x_0,500000), p(y_0,-4500000), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3070, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-90), p(k,0.9996), p(x_0,520000), p(y_0,-4480000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3071, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-90), p(k,0.9996), p(x_0,520000), p(y_0,-4480000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3072, ps{p(proj_tmerc), p(lat_0,43.83333333333334), p(lon_0,-67.875), p(k,0.99998), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3073, ps{p(proj_tmerc), p(lat_0,43), p(lon_0,-69.125), p(k,0.99998), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3074, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.375), p(k,0.99998), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3075, ps{p(proj_tmerc), p(lat_0,43.83333333333334), p(lon_0,-67.875), p(k,0.99998), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3076, ps{p(proj_tmerc), p(lat_0,43), p(lon_0,-69.125), p(k,0.99998), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3077, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.375), p(k,0.99998), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3078, ps{p(proj_omerc), p(lat_0,45.30916666666666), p(lonc,-86), p(alpha,337.25556), p(k,0.9996), p(x_0,2546731.496), p(y_0,-4354009.816), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3079, ps{p(proj_omerc), p(lat_0,45.30916666666666), p(lonc,-86), p(alpha,337.25556), p(k,0.9996), p(x_0,2546731.496), p(y_0,-4354009.816), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3080, ps{p(proj_lcc), p(lat_1,27.41666666666667), p(lat_2,34.91666666666666), p(lat_0,31.16666666666667), p(lon_0,-100), p(x_0,914400), p(y_0,914400), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048), p(no_defs)}),
            ce(3081, ps{p(proj_lcc), p(lat_1,27.41666666666667), p(lat_2,34.91666666666666), p(lat_0,31.16666666666667), p(lon_0,-100), p(x_0,1000000), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3082, ps{p(proj_lcc), p(lat_1,27.5), p(lat_2,35), p(lat_0,18), p(lon_0,-100), p(x_0,1500000), p(y_0,5000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3083, ps{p(proj_aea), p(lat_1,27.5), p(lat_2,35), p(lat_0,18), p(lon_0,-100), p(x_0,1500000), p(y_0,6000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3084, ps{p(proj_lcc), p(lat_1,27.5), p(lat_2,35), p(lat_0,18), p(lon_0,-100), p(x_0,1500000), p(y_0,5000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3085, ps{p(proj_aea), p(lat_1,27.5), p(lat_2,35), p(lat_0,18), p(lon_0,-100), p(x_0,1500000), p(y_0,6000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3086, ps{p(proj_aea), p(lat_1,24), p(lat_2,31.5), p(lat_0,24), p(lon_0,-84), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3087, ps{p(proj_aea), p(lat_1,24), p(lat_2,31.5), p(lat_0,24), p(lon_0,-84), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3088, ps{p(proj_lcc), p(lat_1,37.08333333333334), p(lat_2,38.66666666666666), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,1500000), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3089, ps{p(proj_lcc), p(lat_1,37.08333333333334), p(lat_2,38.66666666666666), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,1500000), p(y_0,999999.9998983998), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3090, ps{p(proj_lcc), p(lat_1,37.08333333333334), p(lat_2,38.66666666666666), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,1500000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3091, ps{p(proj_lcc), p(lat_1,37.08333333333334), p(lat_2,38.66666666666666), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,1500000), p(y_0,999999.9998983998), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3092, ps{p(proj_utm), p(zone,51), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3093, ps{p(proj_utm), p(zone,52), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3094, ps{p(proj_utm), p(zone,53), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3095, ps{p(proj_utm), p(zone,54), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3096, ps{p(proj_utm), p(zone,55), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3097, ps{p(proj_utm), p(zone,51), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3098, ps{p(proj_utm), p(zone,52), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3099, ps{p(proj_utm), p(zone,53), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3100, ps{p(proj_utm), p(zone,54), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3101, ps{p(proj_utm), p(zone,55), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3102, ps{p(proj_lcc), p(lat_1,-14.26666666666667), p(lat_0,-14.26666666666667), p(lon_0,-170), p(k_0,1), p(x_0,152400.3048006096), p(y_0,95169.31165862332), p(ellps_clrk66), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{-115,118,426,0,0,0,0}),
            ce(3103, ps{p(proj_utm), p(zone,28), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3104, ps{p(proj_utm), p(zone,29), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3105, ps{p(proj_utm), p(zone,30), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3106, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,90), p(k,0.9996), p(x_0,500000), p(y_0,0), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}),
            ce(3107, ps{p(proj_lcc), p(lat_1,-28), p(lat_2,-36), p(lat_0,-32), p(lon_0,135), p(x_0,1000000), p(y_0,2000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3108, ps{p(proj_tmerc), p(lat_0,49.5), p(lon_0,-2.416666666666667), p(k,0.999997), p(x_0,47000), p(y_0,50000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3109, ps{p(proj_tmerc), p(lat_0,49.225), p(lon_0,-2.135), p(k,0.9999999000000001), p(x_0,40000), p(y_0,70000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3110, ps{p(proj_lcc), p(lat_1,-36), p(lat_2,-38), p(lat_0,-37), p(lon_0,145), p(x_0,2500000), p(y_0,4500000), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(3111, ps{p(proj_lcc), p(lat_1,-36), p(lat_2,-38), p(lat_0,-37), p(lon_0,145), p(x_0,2500000), p(y_0,2500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3112, ps{p(proj_lcc), p(lat_1,-18), p(lat_2,-36), p(lat_0,0), p(lon_0,134), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3113, ps{p(proj_tmerc), p(lat_0,-28), p(lon_0,153), p(k,0.99999), p(x_0,50000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3114, ps{p(proj_tmerc), p(lat_0,4.596200416666666), p(lon_0,-80.07750791666666), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3115, ps{p(proj_tmerc), p(lat_0,4.596200416666666), p(lon_0,-77.07750791666666), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3116, ps{p(proj_tmerc), p(lat_0,4.596200416666666), p(lon_0,-74.07750791666666), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3117, ps{p(proj_tmerc), p(lat_0,4.596200416666666), p(lon_0,-71.07750791666666), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3118, ps{p(proj_tmerc), p(lat_0,4.596200416666666), p(lon_0,-68.07750791666666), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3119, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,10.5), p(k,0.999), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-206.1,-174.7,-87.7,0,0,0,0}),
            ce(3120, ps{p(proj_sterea), p(lat_0,50.625), p(lon_0,21.08333333333333), p(k,0.9998), p(x_0,4637000), p(y_0,5467000), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(3121, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}, towgs84{-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06}),
            ce(3122, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,119), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}, towgs84{-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06}),
            ce(3123, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,121), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}, towgs84{-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06}),
            ce(3124, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}, towgs84{-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06}),
            ce(3125, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,125), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}, towgs84{-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06}),
            ce(3126, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,19), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3127, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,20), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3128, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3129, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,22), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3130, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,23), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3131, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3132, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,25), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3133, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,26), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3134, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3135, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,28), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3136, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,29), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3137, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,30), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3138, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,31), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            //{3139}
            ce(3140, ps{p(proj_cass), p(lat_0,-18), p(lon_0,178), p(x_0,109435.392), p(y_0,141622.272), p(a,6378306.3696), p(b,6356571.996), p(to_meter,0.201168), p(no_defs)}, towgs84{51,391,-36,0,0,0,0}),
            ce(3141, ps{p(proj_utm), p(zone,60), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{265.025,384.929,-194.046,0,0,0,0}),
            ce(3142, ps{p(proj_utm), p(zone,1), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{265.025,384.929,-194.046,0,0,0,0}),
            ce(3143, ps{p(proj_tmerc), p(lat_0,-17), p(lon_0,178.75), p(k,0.99985), p(x_0,2000000), p(y_0,4000000), p(ellps_wgs72), p(units_m), p(no_defs)}),
            //{3144}
            //{3145}
            ce(3146, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,1), p(x_0,6500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(3147, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(3148, ps{p(proj_utm), p(zone,48), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}),
            ce(3149, ps{p(proj_utm), p(zone,49), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}),
            ce(3150, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,1), p(x_0,6500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(3151, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(3152, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18.05779), p(k,0.99999425), p(x_0,100178.1808), p(y_0,-6500614.7836), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3153, ps{p(proj_aea), p(lat_1,50), p(lat_2,58.5), p(lat_0,45), p(lon_0,-126), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3154, ps{p(proj_utm), p(zone,7), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3155, ps{p(proj_utm), p(zone,8), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3156, ps{p(proj_utm), p(zone,9), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3157, ps{p(proj_utm), p(zone,10), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3158, ps{p(proj_utm), p(zone,14), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3159, ps{p(proj_utm), p(zone,15), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3160, ps{p(proj_utm), p(zone,16), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3161, ps{p(proj_lcc), p(lat_1,44.5), p(lat_2,53.5), p(lat_0,0), p(lon_0,-85), p(x_0,930000), p(y_0,6430000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3162, ps{p(proj_lcc), p(lat_1,44.5), p(lat_2,53.5), p(lat_0,0), p(lon_0,-85), p(x_0,930000), p(y_0,6430000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3163, ps{p(proj_lcc), p(lat_1,-20.66666666666667), p(lat_2,-22.33333333333333), p(lat_0,-21.5), p(lon_0,166), p(x_0,400000), p(y_0,300000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3164, ps{p(proj_utm), p(zone,58), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{-56.263,16.136,-22.856,0,0,0,0}),
            ce(3165, ps{p(proj_lcc), p(lat_1,-22.24469175), p(lat_2,-22.29469175), p(lat_0,-22.26969175), p(lon_0,166.44242575), p(x_0,0.66), p(y_0,1.02), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3166, ps{p(proj_lcc), p(lat_1,-22.24472222222222), p(lat_2,-22.29472222222222), p(lat_0,-22.26972222222222), p(lon_0,166.4425), p(x_0,8.313000000000001), p(y_0,-2.354), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3167, ps{p(proj_omerc), p(lat_0,4), p(lonc,102.25), p(alpha,323.0257905), p(k,0.99984), p(x_0,40000), p(y_0,0), p(a,6377295.664), p(b,6356094.667915204), p(to_meter,20.116756), p(no_defs)}),
            ce(3168, ps{p(proj_omerc), p(lat_0,4), p(lonc,102.25), p(alpha,323.0257905), p(k,0.99984), p(x_0,804670.24), p(y_0,0), p(a,6377295.664), p(b,6356094.667915204), p(units_m), p(no_defs)}),
            ce(3169, ps{p(proj_utm), p(zone,57), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3170, ps{p(proj_utm), p(zone,58), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3171, ps{p(proj_utm), p(zone,59), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3172, ps{p(proj_utm), p(zone,59), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            //{3173}
            ce(3174, ps{p(proj_aea), p(lat_1,42.122774), p(lat_2,49.01518), p(lat_0,45.568977), p(lon_0,-84.455955), p(x_0,1000000), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3175, ps{p(proj_aea), p(lat_1,42.122774), p(lat_2,49.01518), p(lat_0,45.568977), p(lon_0,-83.248627), p(x_0,1000000), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3176, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,106), p(k,0.9996), p(x_0,500000), p(y_0,0), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}),
            ce(3177, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,17), p(k,0.9965000000000001), p(x_0,1000000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3178, ps{p(proj_utm), p(zone,18), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3179, ps{p(proj_utm), p(zone,19), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3180, ps{p(proj_utm), p(zone,20), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3181, ps{p(proj_utm), p(zone,21), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3182, ps{p(proj_utm), p(zone,22), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3183, ps{p(proj_utm), p(zone,23), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3184, ps{p(proj_utm), p(zone,24), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3185, ps{p(proj_utm), p(zone,25), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3186, ps{p(proj_utm), p(zone,26), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3187, ps{p(proj_utm), p(zone,27), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3188, ps{p(proj_utm), p(zone,28), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3189, ps{p(proj_utm), p(zone,29), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3190, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,0.99995), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3191, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,11), p(k,0.99995), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3192, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,13), p(k,0.99995), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3193, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,0.99995), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3194, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,17), p(k,0.99995), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3195, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,19), p(k,0.99995), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3196, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,0.99995), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3197, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,23), p(k,0.99995), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3198, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,25), p(k,0.99995), p(x_0,200000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3199, ps{p(proj_utm), p(zone,32), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3200, ps{p(proj_lcc), p(lat_1,32.5), p(lat_0,32.5), p(lon_0,45), p(k_0,0.9987864078000001), p(x_0,1500000), p(y_0,1166200), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3201, ps{p(proj_utm), p(zone,33), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3202, ps{p(proj_utm), p(zone,34), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3203, ps{p(proj_utm), p(zone,35), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(3204, ps{p(proj_lcc), p(lat_1,-60.66666666666666), p(lat_2,-63.33333333333334), p(lat_0,-90), p(lon_0,-66), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3205, ps{p(proj_lcc), p(lat_1,-60.66666666666666), p(lat_2,-63.33333333333334), p(lat_0,-90), p(lon_0,-54), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3206, ps{p(proj_lcc), p(lat_1,-60.66666666666666), p(lat_2,-63.33333333333334), p(lat_0,-90), p(lon_0,-42), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3207, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,-174), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3208, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,-66), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3209, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,-54), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3210, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,42), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3211, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,54), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3212, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,66), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3213, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,78), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3214, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,90), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3215, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,102), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3216, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,114), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3217, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,126), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3218, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,138), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3219, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,150), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3220, ps{p(proj_lcc), p(lat_1,-64.66666666666667), p(lat_2,-67.33333333333333), p(lat_0,-90), p(lon_0,162), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3221, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,-102), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3222, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,-90), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3223, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,-78), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3224, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,-66), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3225, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,-18), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3226, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,-6), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3227, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,6), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3228, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,18), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3229, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,30), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3230, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,42), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3231, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,54), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3232, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,66), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3233, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,78), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3234, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,90), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3235, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,102), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3236, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,114), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3237, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,126), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3238, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,138), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3239, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,150), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3240, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,162), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3241, ps{p(proj_lcc), p(lat_1,-68.66666666666667), p(lat_2,-71.33333333333333), p(lat_0,-90), p(lon_0,174), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3242, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,-153), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3243, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,-135), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3244, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,-117), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3245, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,-99), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3246, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,-81), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3247, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,-63), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3248, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,-27), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3249, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,-9), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3250, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,9), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3251, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,27), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3252, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,45), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3253, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,63), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3254, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,81), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3255, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,99), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3256, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,117), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3257, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,135), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3258, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,153), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3259, ps{p(proj_lcc), p(lat_1,-72.66666666666667), p(lat_2,-75.33333333333333), p(lat_0,-90), p(lon_0,171), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3260, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,-168), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3261, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,-144), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3262, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,-120), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3263, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,-96), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3264, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,-72), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3265, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,-48), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3266, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,-24), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3267, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3268, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,24), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3269, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,48), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3270, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,72), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3271, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,96), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3272, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,120), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3273, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,144), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3274, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-90), p(lon_0,168), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3275, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,-165), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3276, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,-135), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3277, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,-105), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3278, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,-75), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3279, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,-45), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3280, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,-15), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3281, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,15), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3282, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,45), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3283, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,75), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3284, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,105), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3285, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,135), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3286, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,165), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3287, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,-150), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3288, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,-90), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3289, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,-30), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3290, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,30), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3291, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,90), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3292, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,150), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3293, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-80.23861111111111), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3294, ps{p(proj_lcc), p(lat_1,-76.66666666666667), p(lat_2,-79.33333333333333), p(lat_0,-78), p(lon_0,162), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            //{3295}
            ce(3296, ps{p(proj_utm), p(zone,5), p(south), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3297, ps{p(proj_utm), p(zone,6), p(south), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3298, ps{p(proj_utm), p(zone,7), p(south), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3299, ps{p(proj_utm), p(zone,8), p(south), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3300, ps{p(proj_lcc), p(lat_1,59.33333333333334), p(lat_2,58), p(lat_0,57.51755393055556), p(lon_0,24), p(x_0,500000), p(y_0,6375000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014}),
            ce(3301, ps{p(proj_lcc), p(lat_1,59.33333333333334), p(lat_2,58), p(lat_0,57.51755393055556), p(lon_0,24), p(x_0,500000), p(y_0,6375000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3302, ps{p(proj_utm), p(zone,7), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3303, ps{p(proj_utm), p(zone,7), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074}),
            ce(3304, ps{p(proj_utm), p(zone,6), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3305, ps{p(proj_utm), p(zone,6), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773}),
            ce(3306, ps{p(proj_utm), p(zone,5), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{217.037,86.959,23.956,0,0,0,0}),
            ce(3307, ps{p(proj_utm), p(zone,39), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,-0.15,0.68,0,0,0,0}),
            ce(3308, ps{p(proj_lcc), p(lat_1,-30.75), p(lat_2,-35.75), p(lat_0,-33.25), p(lon_0,147), p(x_0,9300000), p(y_0,4500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3309, ps{p(proj_aea), p(lat_1,34), p(lat_2,40.5), p(lat_0,0), p(lon_0,-120), p(x_0,0), p(y_0,-4000000), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3310, ps{p(proj_aea), p(lat_1,34), p(lat_2,40.5), p(lat_0,0), p(lon_0,-120), p(x_0,0), p(y_0,-4000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3311, ps{p(proj_aea), p(lat_1,34), p(lat_2,40.5), p(lat_0,0), p(lon_0,-120), p(x_0,0), p(y_0,-4000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3312, ps{p(proj_utm), p(zone,21), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-186,230,110,0,0,0,0}),
            ce(3313, ps{p(proj_utm), p(zone,21), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{2,2,-2,0,0,0,0}),
            ce(3314, ps{p(proj_lcc), p(lat_1,-6.5), p(lat_2,-11.5), p(lat_0,0), p(lon_0,26), p(x_0,0), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(3315, ps{p(proj_tmerc), p(lat_0,-9), p(lon_0,26), p(k,0.9998), p(x_0,0), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(3316, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,22), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3317, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3318, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3319, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,14), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3320, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,16), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3321, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3322, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,20), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3323, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,22), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3324, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3325, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,26), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3326, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,28), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3327, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,30), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3328, ps{p(proj_sterea), p(lat_0,52.16666666666666), p(lon_0,19.16666666666667), p(k,0.999714), p(x_0,500000), p(y_0,500000), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(3329, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(3330, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,1), p(x_0,6500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(3331, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,7500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(3332, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,1), p(x_0,8500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(3333, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(3334, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(3335, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(3336, ps{p(proj_utm), p(zone,42), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{145,-187,103,0,0,0,0}),
            ce(3337, ps{p(proj_lcc), p(lat_1,-20.19506944444445), p(lat_0,-20.19506944444445), p(lon_0,57.52182777777778), p(k_0,1), p(x_0,1000000), p(y_0,1000000), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-770.1,158.4,-498.2,0,0,0,0}),
            ce(3338, ps{p(proj_aea), p(lat_1,55), p(lat_2,65), p(lat_0,50), p(lon_0,-154), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3339, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-79.9,-158,-168.9,0,0,0,0}),
            ce(3340, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,14), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-79.9,-158,-168.9,0,0,0,0}),
            ce(3341, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,16), p(k,0.9999), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-79.9,-158,-168.9,0,0,0,0}),
            ce(3342, ps{p(proj_utm), p(zone,33), p(south), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-79.9,-158,-168.9,0,0,0,0}),
            ce(3343, ps{p(proj_utm), p(zone,28), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3344, ps{p(proj_utm), p(zone,29), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3345, ps{p(proj_utm), p(zone,30), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3346, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,0.9998), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3347, ps{p(proj_lcc), p(lat_1,49), p(lat_2,77), p(lat_0,63.390675), p(lon_0,-91.86666666666666), p(x_0,6200000), p(y_0,3000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3348, ps{p(proj_lcc), p(lat_1,49), p(lat_2,77), p(lat_0,63.390675), p(lon_0,-91.86666666666666), p(x_0,6200000), p(y_0,3000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3349, ps{p(proj_merc), p(lon_0,-150), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3350, ps{p(proj_tmerc), p(lat_0,0.1), p(lon_0,21.95), p(k,1), p(x_0,250000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(3351, ps{p(proj_tmerc), p(lat_0,0.1), p(lon_0,24.95), p(k,1), p(x_0,1250000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(3352, ps{p(proj_tmerc), p(lat_0,0.1), p(lon_0,27.95), p(k,1), p(x_0,2250000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(3353, ps{p(proj_utm), p(zone,32), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3354, ps{p(proj_utm), p(zone,32), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3355, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,31), p(k,1), p(x_0,615000), p(y_0,810000), p(ellps_helmert), p(units_m), p(no_defs)}, towgs84{-146.21,112.63,4.05,0,0,0,0}),
            ce(3356, ps{p(proj_utm), p(zone,17), p(ellps_clrk66), p(units_m), p(no_defs)}, towgs84{67.8,106.1,138.8,0,0,0,0}),
            ce(3357, ps{p(proj_utm), p(zone,17), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(3358, ps{p(proj_lcc), p(lat_1,36.16666666666666), p(lat_2,34.33333333333334), p(lat_0,33.75), p(lon_0,-79), p(x_0,609601.22), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3359, ps{p(proj_lcc), p(lat_1,36.16666666666666), p(lat_2,34.33333333333334), p(lat_0,33.75), p(lon_0,-79), p(x_0,609601.2192024385), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(3360, ps{p(proj_lcc), p(lat_1,34.83333333333334), p(lat_2,32.5), p(lat_0,31.83333333333333), p(lon_0,-81), p(x_0,609600), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3361, ps{p(proj_lcc), p(lat_1,34.83333333333334), p(lat_2,32.5), p(lat_0,31.83333333333333), p(lon_0,-81), p(x_0,609600), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}),
            ce(3362, ps{p(proj_lcc), p(lat_1,41.95), p(lat_2,40.88333333333333), p(lat_0,40.16666666666666), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3363, ps{p(proj_lcc), p(lat_1,41.95), p(lat_2,40.88333333333333), p(lat_0,40.16666666666666), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3364, ps{p(proj_lcc), p(lat_1,40.96666666666667), p(lat_2,39.93333333333333), p(lat_0,39.33333333333334), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3365, ps{p(proj_lcc), p(lat_1,40.96666666666667), p(lat_2,39.93333333333333), p(lat_0,39.33333333333334), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3366, ps{p(proj_cass), p(lat_0,22.31213333333334), p(lon_0,114.1785555555556), p(x_0,40243.57775604237), p(y_0,19069.93351512578), p(a,6378293.645208759), p(b,6356617.987679838), p(units_m), p(no_defs)}),
            ce(3367, ps{p(proj_utm), p(zone,28), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3368, ps{p(proj_utm), p(zone,29), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3369, ps{p(proj_utm), p(zone,30), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3370, ps{p(proj_utm), p(zone,59), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3371, ps{p(proj_utm), p(zone,60), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3372, ps{p(proj_utm), p(zone,59), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3373, ps{p(proj_utm), p(zone,60), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3374, ps{p(proj_utm), p(zone,29), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3375, ps{p(proj_omerc), p(lat_0,4), p(lonc,102.25), p(alpha,323.0257964666666), p(k,0.99984), p(x_0,804671), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3376, ps{p(proj_omerc), p(lat_0,4), p(lonc,115), p(alpha,53.31580995), p(k,0.99984), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3377, ps{p(proj_cass), p(lat_0,2.121679744444445), p(lon_0,103.4279362361111), p(x_0,-14810.562), p(y_0,8758.32), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3378, ps{p(proj_cass), p(lat_0,2.682347636111111), p(lon_0,101.9749050416667), p(x_0,3673.785), p(y_0,-4240.573), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3379, ps{p(proj_cass), p(lat_0,3.769388088888889), p(lon_0,102.3682989833333), p(x_0,-7368.228), p(y_0,6485.858), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3380, ps{p(proj_cass), p(lat_0,3.68464905), p(lon_0,101.3891079138889), p(x_0,-34836.161), p(y_0,56464.049), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3381, ps{p(proj_cass), p(lat_0,4.9762852), p(lon_0,103.070275625), p(x_0,19594.245), p(y_0,3371.895), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3382, ps{p(proj_cass), p(lat_0,5.421517541666667), p(lon_0,100.3443769638889), p(x_0,-23.414), p(y_0,62.283), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3383, ps{p(proj_cass), p(lat_0,5.964672713888889), p(lon_0,100.6363711111111), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3384, ps{p(proj_cass), p(lat_0,4.859063022222222), p(lon_0,100.8154105861111), p(x_0,-1.769), p(y_0,133454.779), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3385, ps{p(proj_cass), p(lat_0,5.972543658333334), p(lon_0,102.2952416694444), p(x_0,13227.851), p(y_0,8739.894), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3386, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3387, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3388, ps{p(proj_merc), p(lon_0,51), p(k,1), p(x_0,0), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(3389, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,180), p(k,1), p(x_0,60500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(3390, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,180), p(k,1), p(x_0,60500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(3391, ps{p(proj_utm), p(zone,37), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{84.1,-320.1,218.7,0,0,0,0}),
            ce(3392, ps{p(proj_utm), p(zone,38), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{84.1,-320.1,218.7,0,0,0,0}),
            ce(3393, ps{p(proj_utm), p(zone,39), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{84.1,-320.1,218.7,0,0,0,0}),
            ce(3394, ps{p(proj_lcc), p(lat_1,32.5), p(lat_0,32.5), p(lon_0,45), p(k_0,0.9987864078000001), p(x_0,1500000), p(y_0,1166200), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3395, ps{p(proj_merc), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3396, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3397, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3398, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3399, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(3400, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-115), p(k,0.9992), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3401, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-115), p(k,0.9992), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3402, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-115), p(k,0.9992), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3403, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-115), p(k,0.9992), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3404, ps{p(proj_lcc), p(lat_1,36.16666666666666), p(lat_2,34.33333333333334), p(lat_0,33.75), p(lon_0,-79), p(x_0,609601.2192024384), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3405, ps{p(proj_utm), p(zone,48), p(ellps_wgs84), p(units_m), p(no_defs)}),
            ce(3406, ps{p(proj_utm), p(zone,49), p(ellps_wgs84), p(units_m), p(no_defs)}),
            ce(3407, ps{p(proj_cass), p(lat_0,22.31213333333334), p(lon_0,114.1785555555556), p(x_0,40243.57775604237), p(y_0,19069.93351512578), p(a,6378293.645208759), p(b,6356617.987679838), p(to_meter,0.3047972654), p(no_defs)}),
            ce(3408, ps{p(proj_laea), p(lat_0,90), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371228), p(units_m), p(no_defs)}),
            ce(3409, ps{p(proj_laea), p(lat_0,-90), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371228), p(units_m), p(no_defs)}),
            ce(3410, ps{p(proj_cea), p(lon_0,0), p(lat_ts,30), p(x_0,0), p(y_0,0), p(r,6371228), p(units_m), p(no_defs)}),
            ce(3411, ps{p(proj_stere), p(lat_0,90), p(lat_ts,70), p(lon_0,-45), p(k,1), p(x_0,0), p(y_0,0), p(a,6378273), p(b,6356889.449), p(units_m), p(no_defs)}),
            ce(3412, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-70), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(a,6378273), p(b,6356889.449), p(units_m), p(no_defs)}),
            ce(3413, ps{p(proj_stere), p(lat_0,90), p(lat_ts,70), p(lon_0,-45), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3414, ps{p(proj_tmerc), p(lat_0,1.366666666666667), p(lon_0,103.8333333333333), p(k,1), p(x_0,28001.642), p(y_0,38744.572), p(ellps_wgs84), p(units_m), p(no_defs)}),
            ce(3415, ps{p(proj_lcc), p(lat_1,18), p(lat_2,24), p(lat_0,21), p(lon_0,114), p(x_0,500000), p(y_0,500000), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(3416, ps{p(proj_lcc), p(lat_1,49), p(lat_2,46), p(lat_0,47.5), p(lon_0,13.33333333333333), p(x_0,400000), p(y_0,400000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3417, ps{p(proj_lcc), p(lat_1,43.26666666666667), p(lat_2,42.06666666666667), p(lat_0,41.5), p(lon_0,-93.5), p(x_0,1500000), p(y_0,999999.9999898402), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3418, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.61666666666667), p(lat_0,40), p(lon_0,-93.5), p(x_0,500000.00001016), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3419, ps{p(proj_lcc), p(lat_1,39.78333333333333), p(lat_2,38.71666666666667), p(lat_0,38.33333333333334), p(lon_0,-98), p(x_0,399999.99998984), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3420, ps{p(proj_lcc), p(lat_1,38.56666666666667), p(lat_2,37.26666666666667), p(lat_0,36.66666666666666), p(lon_0,-98.5), p(x_0,399999.99998984), p(y_0,399999.99998984), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3421, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-115.5833333333333), p(k,0.9999), p(x_0,200000.00001016), p(y_0,8000000.000010163), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3422, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-116.6666666666667), p(k,0.9999), p(x_0,500000.00001016), p(y_0,6000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3423, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-118.5833333333333), p(k,0.9999), p(x_0,800000.0000101599), p(y_0,3999999.99998984), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3424, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3425, ps{p(proj_lcc), p(lat_1,43.26666666666667), p(lat_2,42.06666666666667), p(lat_0,41.5), p(lon_0,-93.5), p(x_0,1500000), p(y_0,999999.9999898402), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3426, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.61666666666667), p(lat_0,40), p(lon_0,-93.5), p(x_0,500000.00001016), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3427, ps{p(proj_lcc), p(lat_1,39.78333333333333), p(lat_2,38.71666666666667), p(lat_0,38.33333333333334), p(lon_0,-98), p(x_0,399999.99998984), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3428, ps{p(proj_lcc), p(lat_1,38.56666666666667), p(lat_2,37.26666666666667), p(lat_0,36.66666666666666), p(lon_0,-98.5), p(x_0,399999.99998984), p(y_0,399999.99998984), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3429, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-115.5833333333333), p(k,0.9999), p(x_0,200000.00001016), p(y_0,8000000.000010163), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3430, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-116.6666666666667), p(k,0.9999), p(x_0,500000.00001016), p(y_0,6000000), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3431, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-118.5833333333333), p(k,0.9999), p(x_0,800000.0000101599), p(y_0,3999999.99998984), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3432, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3433, ps{p(proj_lcc), p(lat_1,36.23333333333333), p(lat_2,34.93333333333333), p(lat_0,34.33333333333334), p(lon_0,-92), p(x_0,399999.99998984), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3434, ps{p(proj_lcc), p(lat_1,34.76666666666667), p(lat_2,33.3), p(lat_0,32.66666666666666), p(lon_0,-92), p(x_0,399999.99998984), p(y_0,399999.99998984), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3435, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-88.33333333333333), p(k,0.9999749999999999), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3436, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-90.16666666666667), p(k,0.999941177), p(x_0,699999.9999898402), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3437, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-71.66666666666667), p(k,0.999966667), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3438, ps{p(proj_tmerc), p(lat_0,41.08333333333334), p(lon_0,-71.5), p(k,0.99999375), p(x_0,99999.99998983997), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3439, ps{p(proj_utm), p(zone,39), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3440, ps{p(proj_utm), p(zone,40), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(3441, ps{p(proj_lcc), p(lat_1,36.23333333333333), p(lat_2,34.93333333333333), p(lat_0,34.33333333333334), p(lon_0,-92), p(x_0,399999.99998984), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3442, ps{p(proj_lcc), p(lat_1,34.76666666666667), p(lat_2,33.3), p(lat_0,32.66666666666666), p(lon_0,-92), p(x_0,399999.99998984), p(y_0,399999.99998984), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3443, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-88.33333333333333), p(k,0.9999749999999999), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3444, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-90.16666666666667), p(k,0.999941177), p(x_0,699999.9999898402), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3445, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-71.66666666666667), p(k,0.999966667), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3446, ps{p(proj_tmerc), p(lat_0,41.08333333333334), p(lon_0,-71.5), p(k,0.99999375), p(x_0,99999.99998983997), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3447, ps{p(proj_lcc), p(lat_1,49.83333333333334), p(lat_2,51.16666666666666), p(lat_0,50.797815), p(lon_0,4.359215833333333), p(x_0,150328), p(y_0,166262), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3448, ps{p(proj_lcc), p(lat_1,18), p(lat_0,18), p(lon_0,-77), p(k_0,1), p(x_0,750000), p(y_0,650000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3449, ps{p(proj_utm), p(zone,17), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3450, ps{p(proj_utm), p(zone,18), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3451, ps{p(proj_lcc), p(lat_1,32.66666666666666), p(lat_2,31.16666666666667), p(lat_0,30.5), p(lon_0,-92.5), p(x_0,999999.9999898402), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3452, ps{p(proj_lcc), p(lat_1,30.7), p(lat_2,29.3), p(lat_0,28.5), p(lon_0,-91.33333333333333), p(x_0,999999.9999898402), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3453, ps{p(proj_lcc), p(lat_1,27.83333333333333), p(lat_2,26.16666666666667), p(lat_0,25.5), p(lon_0,-91.33333333333333), p(x_0,999999.9999898402), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3454, ps{p(proj_lcc), p(lat_1,44.4), p(lat_2,42.83333333333334), p(lat_0,42.33333333333334), p(lon_0,-100.3333333333333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3455, ps{p(proj_lcc), p(lat_1,44.4), p(lat_2,42.83333333333334), p(lat_0,42.33333333333334), p(lon_0,-100.3333333333333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3456, ps{p(proj_lcc), p(lat_1,32.66666666666666), p(lat_2,31.16666666666667), p(lat_0,30.5), p(lon_0,-92.5), p(x_0,999999.9999898402), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3457, ps{p(proj_lcc), p(lat_1,30.7), p(lat_2,29.3), p(lat_0,28.5), p(lon_0,-91.33333333333333), p(x_0,999999.9999898402), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3458, ps{p(proj_lcc), p(lat_1,45.68333333333333), p(lat_2,44.41666666666666), p(lat_0,43.83333333333334), p(lon_0,-100), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3459, ps{p(proj_lcc), p(lat_1,44.4), p(lat_2,42.83333333333334), p(lat_0,42.33333333333334), p(lon_0,-100.3333333333333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3460, ps{p(proj_tmerc), p(lat_0,-17), p(lon_0,178.75), p(k,0.99985), p(x_0,2000000), p(y_0,4000000), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(3461, ps{p(proj_utm), p(zone,28), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{-83,37,124,0,0,0,0}),
            ce(3462, ps{p(proj_utm), p(zone,29), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{-83,37,124,0,0,0,0}),
            ce(3463, ps{p(proj_tmerc), p(lat_0,43.5), p(lon_0,-69.125), p(k,0.99998), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3464, ps{p(proj_tmerc), p(lat_0,43.5), p(lon_0,-69.125), p(k,0.99998), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3465, ps{p(proj_tmerc), p(lat_0,30.5), p(lon_0,-85.83333333333333), p(k,0.99996), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3466, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-87.5), p(k,0.999933333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3467, ps{p(proj_aea), p(lat_1,55), p(lat_2,65), p(lat_0,50), p(lon_0,-154), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3468, ps{p(proj_omerc), p(lat_0,57), p(lonc,-133.6666666666667), p(alpha,323.1301023611111), p(k,0.9999), p(x_0,5000000), p(y_0,-5000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3469, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-142), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3470, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-146), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3471, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-150), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3472, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-154), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3473, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-158), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3474, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-162), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3475, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-166), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3476, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-170), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3477, ps{p(proj_lcc), p(lat_1,53.83333333333334), p(lat_2,51.83333333333334), p(lat_0,51), p(lon_0,-176), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3478, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-111.9166666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3479, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-111.9166666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3480, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-110.1666666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3481, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-110.1666666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3482, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-113.75), p(k,0.999933333), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3483, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-113.75), p(k,0.999933333), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3484, ps{p(proj_lcc), p(lat_1,36.23333333333333), p(lat_2,34.93333333333333), p(lat_0,34.33333333333334), p(lon_0,-92), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3485, ps{p(proj_lcc), p(lat_1,36.23333333333333), p(lat_2,34.93333333333333), p(lat_0,34.33333333333334), p(lon_0,-92), p(x_0,399999.99998984), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3486, ps{p(proj_lcc), p(lat_1,34.76666666666667), p(lat_2,33.3), p(lat_0,32.66666666666666), p(lon_0,-92), p(x_0,400000), p(y_0,400000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3487, ps{p(proj_lcc), p(lat_1,34.76666666666667), p(lat_2,33.3), p(lat_0,32.66666666666666), p(lon_0,-92), p(x_0,399999.99998984), p(y_0,399999.99998984), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3488, ps{p(proj_aea), p(lat_1,34), p(lat_2,40.5), p(lat_0,0), p(lon_0,-120), p(x_0,0), p(y_0,-4000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3489, ps{p(proj_lcc), p(lat_1,41.66666666666666), p(lat_2,40), p(lat_0,39.33333333333334), p(lon_0,-122), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3490, ps{p(proj_lcc), p(lat_1,41.66666666666666), p(lat_2,40), p(lat_0,39.33333333333334), p(lon_0,-122), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3491, ps{p(proj_lcc), p(lat_1,39.83333333333334), p(lat_2,38.33333333333334), p(lat_0,37.66666666666666), p(lon_0,-122), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3492, ps{p(proj_lcc), p(lat_1,39.83333333333334), p(lat_2,38.33333333333334), p(lat_0,37.66666666666666), p(lon_0,-122), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3493, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.06666666666667), p(lat_0,36.5), p(lon_0,-120.5), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3494, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.06666666666667), p(lat_0,36.5), p(lon_0,-120.5), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3495, ps{p(proj_lcc), p(lat_1,37.25), p(lat_2,36), p(lat_0,35.33333333333334), p(lon_0,-119), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3496, ps{p(proj_lcc), p(lat_1,37.25), p(lat_2,36), p(lat_0,35.33333333333334), p(lon_0,-119), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3497, ps{p(proj_lcc), p(lat_1,35.46666666666667), p(lat_2,34.03333333333333), p(lat_0,33.5), p(lon_0,-118), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3498, ps{p(proj_lcc), p(lat_1,35.46666666666667), p(lat_2,34.03333333333333), p(lat_0,33.5), p(lon_0,-118), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3499, ps{p(proj_lcc), p(lat_1,33.88333333333333), p(lat_2,32.78333333333333), p(lat_0,32.16666666666666), p(lon_0,-116.25), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3500, ps{p(proj_lcc), p(lat_1,33.88333333333333), p(lat_2,32.78333333333333), p(lat_0,32.16666666666666), p(lon_0,-116.25), p(x_0,2000000.0001016), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3501, ps{p(proj_lcc), p(lat_1,39.75), p(lat_2,38.45), p(lat_0,37.83333333333334), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3502, ps{p(proj_lcc), p(lat_1,39.75), p(lat_2,38.45), p(lat_0,37.83333333333334), p(lon_0,-105.5), p(x_0,914401.8288036576), p(y_0,304800.6096012192), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3503, ps{p(proj_lcc), p(lat_1,40.78333333333333), p(lat_2,39.71666666666667), p(lat_0,39.33333333333334), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3504, ps{p(proj_lcc), p(lat_1,40.78333333333333), p(lat_2,39.71666666666667), p(lat_0,39.33333333333334), p(lon_0,-105.5), p(x_0,914401.8288036576), p(y_0,304800.6096012192), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3505, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.23333333333333), p(lat_0,36.66666666666666), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3506, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.23333333333333), p(lat_0,36.66666666666666), p(lon_0,-105.5), p(x_0,914401.8288036576), p(y_0,304800.6096012192), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3507, ps{p(proj_lcc), p(lat_1,41.86666666666667), p(lat_2,41.2), p(lat_0,40.83333333333334), p(lon_0,-72.75), p(x_0,304800.6096), p(y_0,152400.3048), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3508, ps{p(proj_lcc), p(lat_1,41.86666666666667), p(lat_2,41.2), p(lat_0,40.83333333333334), p(lon_0,-72.75), p(x_0,304800.6096012192), p(y_0,152400.3048006096), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3509, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,-75.41666666666667), p(k,0.999995), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3510, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,-75.41666666666667), p(k,0.999995), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3511, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-81), p(k,0.999941177), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3512, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-81), p(k,0.999941177), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3513, ps{p(proj_aea), p(lat_1,24), p(lat_2,31.5), p(lat_0,24), p(lon_0,-84), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3514, ps{p(proj_lcc), p(lat_1,30.75), p(lat_2,29.58333333333333), p(lat_0,29), p(lon_0,-84.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3515, ps{p(proj_lcc), p(lat_1,30.75), p(lat_2,29.58333333333333), p(lat_0,29), p(lon_0,-84.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3516, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-82), p(k,0.999941177), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3517, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-82), p(k,0.999941177), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3518, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-82.16666666666667), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3519, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-82.16666666666667), p(k,0.9999), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3520, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-84.16666666666667), p(k,0.9999), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3521, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-84.16666666666667), p(k,0.9999), p(x_0,699999.9998983998), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3522, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-114), p(k,0.9999473679999999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3523, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-114), p(k,0.9999473679999999), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3524, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-112.1666666666667), p(k,0.9999473679999999), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3525, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-112.1666666666667), p(k,0.9999473679999999), p(x_0,200000.0001016002), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3526, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-115.75), p(k,0.999933333), p(x_0,800000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3527, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-115.75), p(k,0.999933333), p(x_0,800000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3528, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-88.33333333333333), p(k,0.9999749999999999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3529, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-88.33333333333333), p(k,0.9999749999999999), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3530, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-90.16666666666667), p(k,0.999941177), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3531, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-90.16666666666667), p(k,0.999941177), p(x_0,699999.9999898402), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3532, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.999966667), p(x_0,100000), p(y_0,250000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3533, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.999966667), p(x_0,99999.99989839978), p(y_0,249999.9998983998), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3534, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.999966667), p(x_0,900000), p(y_0,250000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3535, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.999966667), p(x_0,900000), p(y_0,249999.9998983998), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3536, ps{p(proj_lcc), p(lat_1,43.26666666666667), p(lat_2,42.06666666666667), p(lat_0,41.5), p(lon_0,-93.5), p(x_0,1500000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3537, ps{p(proj_lcc), p(lat_1,43.26666666666667), p(lat_2,42.06666666666667), p(lat_0,41.5), p(lon_0,-93.5), p(x_0,1500000), p(y_0,999999.9999898402), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3538, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.61666666666667), p(lat_0,40), p(lon_0,-93.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3539, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.61666666666667), p(lat_0,40), p(lon_0,-93.5), p(x_0,500000.00001016), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3540, ps{p(proj_lcc), p(lat_1,39.78333333333333), p(lat_2,38.71666666666667), p(lat_0,38.33333333333334), p(lon_0,-98), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3541, ps{p(proj_lcc), p(lat_1,39.78333333333333), p(lat_2,38.71666666666667), p(lat_0,38.33333333333334), p(lon_0,-98), p(x_0,399999.99998984), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3542, ps{p(proj_lcc), p(lat_1,38.56666666666667), p(lat_2,37.26666666666667), p(lat_0,36.66666666666666), p(lon_0,-98.5), p(x_0,400000), p(y_0,400000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3543, ps{p(proj_lcc), p(lat_1,38.56666666666667), p(lat_2,37.26666666666667), p(lat_0,36.66666666666666), p(lon_0,-98.5), p(x_0,399999.99998984), p(y_0,399999.99998984), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3544, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,38.96666666666667), p(lat_0,37.5), p(lon_0,-84.25), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3545, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,38.96666666666667), p(lat_0,37.5), p(lon_0,-84.25), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3546, ps{p(proj_lcc), p(lat_1,37.08333333333334), p(lat_2,38.66666666666666), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,1500000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3547, ps{p(proj_lcc), p(lat_1,37.08333333333334), p(lat_2,38.66666666666666), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,1500000), p(y_0,999999.9998983998), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3548, ps{p(proj_lcc), p(lat_1,37.93333333333333), p(lat_2,36.73333333333333), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,500000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3549, ps{p(proj_lcc), p(lat_1,37.93333333333333), p(lat_2,36.73333333333333), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,500000.0001016001), p(y_0,500000.0001016001), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3550, ps{p(proj_lcc), p(lat_1,32.66666666666666), p(lat_2,31.16666666666667), p(lat_0,30.5), p(lon_0,-92.5), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3551, ps{p(proj_lcc), p(lat_1,32.66666666666666), p(lat_2,31.16666666666667), p(lat_0,30.5), p(lon_0,-92.5), p(x_0,999999.9999898402), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3552, ps{p(proj_lcc), p(lat_1,30.7), p(lat_2,29.3), p(lat_0,28.5), p(lon_0,-91.33333333333333), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3553, ps{p(proj_lcc), p(lat_1,30.7), p(lat_2,29.3), p(lat_0,28.5), p(lon_0,-91.33333333333333), p(x_0,999999.9999898402), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3554, ps{p(proj_tmerc), p(lat_0,43.5), p(lon_0,-69.125), p(k,0.99998), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3555, ps{p(proj_tmerc), p(lat_0,43.83333333333334), p(lon_0,-67.875), p(k,0.99998), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3556, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.375), p(k,0.99998), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3557, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3558, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.999966667), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3559, ps{p(proj_lcc), p(lat_1,39.45), p(lat_2,38.3), p(lat_0,37.66666666666666), p(lon_0,-77), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3560, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.71666666666667), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000.00001016), p(y_0,999999.9999898402), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3561, ps{p(proj_tmerc), p(lat_0,18.83333333333333), p(lon_0,-155.5), p(k,0.999966667), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3562, ps{p(proj_tmerc), p(lat_0,20.33333333333333), p(lon_0,-156.6666666666667), p(k,0.999966667), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3563, ps{p(proj_tmerc), p(lat_0,21.16666666666667), p(lon_0,-158), p(k,0.99999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3564, ps{p(proj_tmerc), p(lat_0,21.83333333333333), p(lon_0,-159.5), p(k,0.99999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3565, ps{p(proj_tmerc), p(lat_0,21.66666666666667), p(lon_0,-160.1666666666667), p(k,1), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3566, ps{p(proj_lcc), p(lat_1,40.65), p(lat_2,39.01666666666667), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000.00001016), p(y_0,2000000.00001016), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3567, ps{p(proj_lcc), p(lat_1,38.35), p(lat_2,37.21666666666667), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000.00001016), p(y_0,3000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3568, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.71666666666667), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000.00001016), p(y_0,999999.9999898402), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3569, ps{p(proj_lcc), p(lat_1,40.65), p(lat_2,39.01666666666667), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000.00001016), p(y_0,2000000.00001016), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3570, ps{p(proj_lcc), p(lat_1,38.35), p(lat_2,37.21666666666667), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000.00001016), p(y_0,3000000), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3571, ps{p(proj_laea), p(lat_0,90), p(lon_0,180), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3572, ps{p(proj_laea), p(lat_0,90), p(lon_0,-150), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3573, ps{p(proj_laea), p(lat_0,90), p(lon_0,-100), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3574, ps{p(proj_laea), p(lat_0,90), p(lon_0,-40), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3575, ps{p(proj_laea), p(lat_0,90), p(lon_0,10), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3576, ps{p(proj_laea), p(lat_0,90), p(lon_0,90), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3577, ps{p(proj_aea), p(lat_1,-18), p(lat_2,-36), p(lat_0,0), p(lon_0,132), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3578, ps{p(proj_aea), p(lat_1,61.66666666666666), p(lat_2,68), p(lat_0,59), p(lon_0,-132.5), p(x_0,500000), p(y_0,500000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3579, ps{p(proj_aea), p(lat_1,61.66666666666666), p(lat_2,68), p(lat_0,59), p(lon_0,-132.5), p(x_0,500000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3580, ps{p(proj_lcc), p(lat_1,62), p(lat_2,70), p(lat_0,0), p(lon_0,-112), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3581, ps{p(proj_lcc), p(lat_1,62), p(lat_2,70), p(lat_0,0), p(lon_0,-112), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3582, ps{p(proj_lcc), p(lat_1,39.45), p(lat_2,38.3), p(lat_0,37.66666666666666), p(lon_0,-77), p(x_0,399999.9998983998), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3583, ps{p(proj_lcc), p(lat_1,41.48333333333333), p(lat_2,41.28333333333333), p(lat_0,41), p(lon_0,-70.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3584, ps{p(proj_lcc), p(lat_1,41.48333333333333), p(lat_2,41.28333333333333), p(lat_0,41), p(lon_0,-70.5), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3585, ps{p(proj_lcc), p(lat_1,42.68333333333333), p(lat_2,41.71666666666667), p(lat_0,41), p(lon_0,-71.5), p(x_0,200000), p(y_0,750000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3586, ps{p(proj_lcc), p(lat_1,42.68333333333333), p(lat_2,41.71666666666667), p(lat_0,41), p(lon_0,-71.5), p(x_0,200000.0001016002), p(y_0,750000), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3587, ps{p(proj_webmerc), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3588, ps{p(proj_lcc), p(lat_1,45.7), p(lat_2,44.18333333333333), p(lat_0,43.31666666666667), p(lon_0,-84.36666666666666), p(x_0,5999999.999976001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3589, ps{p(proj_lcc), p(lat_1,47.08333333333334), p(lat_2,45.48333333333333), p(lat_0,44.78333333333333), p(lon_0,-87), p(x_0,8000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3590, ps{p(proj_lcc), p(lat_1,47.08333333333334), p(lat_2,45.48333333333333), p(lat_0,44.78333333333333), p(lon_0,-87), p(x_0,7999999.999968001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3591, ps{p(proj_omerc), p(lat_0,45.30916666666666), p(lonc,-86), p(alpha,337.25556), p(k,0.9996), p(x_0,2546731.496), p(y_0,-4354009.816), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3592, ps{p(proj_lcc), p(lat_1,43.66666666666666), p(lat_2,42.1), p(lat_0,41.5), p(lon_0,-84.36666666666666), p(x_0,4000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3593, ps{p(proj_lcc), p(lat_1,43.66666666666666), p(lat_2,42.1), p(lat_0,41.5), p(lon_0,-84.36666666666666), p(x_0,3999999.999984), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3594, ps{p(proj_lcc), p(lat_1,47.05), p(lat_2,45.61666666666667), p(lat_0,45), p(lon_0,-94.25), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3595, ps{p(proj_lcc), p(lat_1,48.63333333333333), p(lat_2,47.03333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3596, ps{p(proj_lcc), p(lat_1,45.21666666666667), p(lat_2,43.78333333333333), p(lat_0,43), p(lon_0,-94), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3597, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-88.83333333333333), p(k,0.99995), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3598, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-88.83333333333333), p(k,0.99995), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3599, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-90.33333333333333), p(k,0.99995), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3600, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-90.33333333333333), p(k,0.99995), p(x_0,699999.9998983998), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3601, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-92.5), p(k,0.999933333), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3602, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-90.5), p(k,0.999933333), p(x_0,250000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3603, ps{p(proj_tmerc), p(lat_0,36.16666666666666), p(lon_0,-94.5), p(k,0.999941177), p(x_0,850000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3604, ps{p(proj_lcc), p(lat_1,49), p(lat_2,45), p(lat_0,44.25), p(lon_0,-109.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3605, ps{p(proj_lcc), p(lat_1,49), p(lat_2,45), p(lat_0,44.25), p(lon_0,-109.5), p(x_0,599999.9999976), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3606, ps{p(proj_lcc), p(lat_1,43), p(lat_2,40), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3607, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-116.6666666666667), p(k,0.9999), p(x_0,500000), p(y_0,6000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3608, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-116.6666666666667), p(k,0.9999), p(x_0,500000.00001016), p(y_0,6000000), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3609, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-115.5833333333333), p(k,0.9999), p(x_0,200000), p(y_0,8000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3610, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-115.5833333333333), p(k,0.9999), p(x_0,200000.00001016), p(y_0,8000000.000010163), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3611, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-118.5833333333333), p(k,0.9999), p(x_0,800000), p(y_0,4000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3612, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-118.5833333333333), p(k,0.9999), p(x_0,800000.0000101599), p(y_0,3999999.99998984), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3613, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-71.66666666666667), p(k,0.999966667), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3614, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-71.66666666666667), p(k,0.999966667), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3615, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3616, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3617, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-106.25), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3618, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-106.25), p(k,0.9999), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3619, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-104.3333333333333), p(k,0.999909091), p(x_0,165000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3620, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-104.3333333333333), p(k,0.999909091), p(x_0,165000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3621, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-107.8333333333333), p(k,0.999916667), p(x_0,830000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3622, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-107.8333333333333), p(k,0.999916667), p(x_0,830000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3623, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-76.58333333333333), p(k,0.9999375), p(x_0,250000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3624, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-76.58333333333333), p(k,0.9999375), p(x_0,249999.9998983998), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3625, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3626, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3627, ps{p(proj_lcc), p(lat_1,41.03333333333333), p(lat_2,40.66666666666666), p(lat_0,40.16666666666666), p(lon_0,-74), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3628, ps{p(proj_lcc), p(lat_1,41.03333333333333), p(lat_2,40.66666666666666), p(lat_0,40.16666666666666), p(lon_0,-74), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3629, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-78.58333333333333), p(k,0.9999375), p(x_0,350000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3630, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-78.58333333333333), p(k,0.9999375), p(x_0,350000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3631, ps{p(proj_lcc), p(lat_1,36.16666666666666), p(lat_2,34.33333333333334), p(lat_0,33.75), p(lon_0,-79), p(x_0,609601.22), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3632, ps{p(proj_lcc), p(lat_1,36.16666666666666), p(lat_2,34.33333333333334), p(lat_0,33.75), p(lon_0,-79), p(x_0,609601.2192024384), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3633, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.43333333333333), p(lat_0,47), p(lon_0,-100.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3634, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.43333333333333), p(lat_0,47), p(lon_0,-100.5), p(x_0,599999.9999976), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3635, ps{p(proj_lcc), p(lat_1,47.48333333333333), p(lat_2,46.18333333333333), p(lat_0,45.66666666666666), p(lon_0,-100.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3636, ps{p(proj_lcc), p(lat_1,47.48333333333333), p(lat_2,46.18333333333333), p(lat_0,45.66666666666666), p(lon_0,-100.5), p(x_0,599999.9999976), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3637, ps{p(proj_lcc), p(lat_1,41.7), p(lat_2,40.43333333333333), p(lat_0,39.66666666666666), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3638, ps{p(proj_lcc), p(lat_1,40.03333333333333), p(lat_2,38.73333333333333), p(lat_0,38), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3639, ps{p(proj_lcc), p(lat_1,36.76666666666667), p(lat_2,35.56666666666667), p(lat_0,35), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3640, ps{p(proj_lcc), p(lat_1,36.76666666666667), p(lat_2,35.56666666666667), p(lat_0,35), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3641, ps{p(proj_lcc), p(lat_1,35.23333333333333), p(lat_2,33.93333333333333), p(lat_0,33.33333333333334), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3642, ps{p(proj_lcc), p(lat_1,35.23333333333333), p(lat_2,33.93333333333333), p(lat_0,33.33333333333334), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3643, ps{p(proj_lcc), p(lat_1,43), p(lat_2,45.5), p(lat_0,41.75), p(lon_0,-120.5), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3644, ps{p(proj_lcc), p(lat_1,43), p(lat_2,45.5), p(lat_0,41.75), p(lon_0,-120.5), p(x_0,399999.9999984), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3645, ps{p(proj_lcc), p(lat_1,46), p(lat_2,44.33333333333334), p(lat_0,43.66666666666666), p(lon_0,-120.5), p(x_0,2500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3646, ps{p(proj_lcc), p(lat_1,46), p(lat_2,44.33333333333334), p(lat_0,43.66666666666666), p(lon_0,-120.5), p(x_0,2500000.0001424), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3647, ps{p(proj_lcc), p(lat_1,44), p(lat_2,42.33333333333334), p(lat_0,41.66666666666666), p(lon_0,-120.5), p(x_0,1500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3648, ps{p(proj_lcc), p(lat_1,44), p(lat_2,42.33333333333334), p(lat_0,41.66666666666666), p(lon_0,-120.5), p(x_0,1500000.0001464), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3649, ps{p(proj_lcc), p(lat_1,41.95), p(lat_2,40.88333333333333), p(lat_0,40.16666666666666), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3650, ps{p(proj_lcc), p(lat_1,41.95), p(lat_2,40.88333333333333), p(lat_0,40.16666666666666), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3651, ps{p(proj_lcc), p(lat_1,40.96666666666667), p(lat_2,39.93333333333333), p(lat_0,39.33333333333334), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3652, ps{p(proj_lcc), p(lat_1,40.96666666666667), p(lat_2,39.93333333333333), p(lat_0,39.33333333333334), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3653, ps{p(proj_tmerc), p(lat_0,41.08333333333334), p(lon_0,-71.5), p(k,0.99999375), p(x_0,100000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3654, ps{p(proj_tmerc), p(lat_0,41.08333333333334), p(lon_0,-71.5), p(k,0.99999375), p(x_0,99999.99998983997), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3655, ps{p(proj_lcc), p(lat_1,34.83333333333334), p(lat_2,32.5), p(lat_0,31.83333333333333), p(lon_0,-81), p(x_0,609600), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3656, ps{p(proj_lcc), p(lat_1,34.83333333333334), p(lat_2,32.5), p(lat_0,31.83333333333333), p(lon_0,-81), p(x_0,609600), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3657, ps{p(proj_lcc), p(lat_1,45.68333333333333), p(lat_2,44.41666666666666), p(lat_0,43.83333333333334), p(lon_0,-100), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3658, ps{p(proj_lcc), p(lat_1,45.68333333333333), p(lat_2,44.41666666666666), p(lat_0,43.83333333333334), p(lon_0,-100), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3659, ps{p(proj_lcc), p(lat_1,44.4), p(lat_2,42.83333333333334), p(lat_0,42.33333333333334), p(lon_0,-100.3333333333333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3660, ps{p(proj_lcc), p(lat_1,44.4), p(lat_2,42.83333333333334), p(lat_0,42.33333333333334), p(lon_0,-100.3333333333333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3661, ps{p(proj_lcc), p(lat_1,36.41666666666666), p(lat_2,35.25), p(lat_0,34.33333333333334), p(lon_0,-86), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3662, ps{p(proj_lcc), p(lat_1,36.41666666666666), p(lat_2,35.25), p(lat_0,34.33333333333334), p(lon_0,-86), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3663, ps{p(proj_lcc), p(lat_1,31.88333333333333), p(lat_2,30.11666666666667), p(lat_0,29.66666666666667), p(lon_0,-100.3333333333333), p(x_0,700000), p(y_0,3000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3664, ps{p(proj_lcc), p(lat_1,31.88333333333333), p(lat_2,30.11666666666667), p(lat_0,29.66666666666667), p(lon_0,-100.3333333333333), p(x_0,699999.9998983998), p(y_0,3000000), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3665, ps{p(proj_aea), p(lat_1,27.5), p(lat_2,35), p(lat_0,18), p(lon_0,-100), p(x_0,1500000), p(y_0,6000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3666, ps{p(proj_lcc), p(lat_1,27.5), p(lat_2,35), p(lat_0,18), p(lon_0,-100), p(x_0,1500000), p(y_0,5000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3667, ps{p(proj_lcc), p(lat_1,36.18333333333333), p(lat_2,34.65), p(lat_0,34), p(lon_0,-101.5), p(x_0,200000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3668, ps{p(proj_lcc), p(lat_1,36.18333333333333), p(lat_2,34.65), p(lat_0,34), p(lon_0,-101.5), p(x_0,200000.0001016002), p(y_0,999999.9998983998), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3669, ps{p(proj_lcc), p(lat_1,33.96666666666667), p(lat_2,32.13333333333333), p(lat_0,31.66666666666667), p(lon_0,-98.5), p(x_0,600000), p(y_0,2000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3670, ps{p(proj_lcc), p(lat_1,33.96666666666667), p(lat_2,32.13333333333333), p(lat_0,31.66666666666667), p(lon_0,-98.5), p(x_0,600000), p(y_0,2000000.0001016), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3671, ps{p(proj_lcc), p(lat_1,27.83333333333333), p(lat_2,26.16666666666667), p(lat_0,25.66666666666667), p(lon_0,-98.5), p(x_0,300000), p(y_0,5000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3672, ps{p(proj_lcc), p(lat_1,27.83333333333333), p(lat_2,26.16666666666667), p(lat_0,25.66666666666667), p(lon_0,-98.5), p(x_0,300000.0000000001), p(y_0,5000000.0001016), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3673, ps{p(proj_lcc), p(lat_1,30.28333333333333), p(lat_2,28.38333333333333), p(lat_0,27.83333333333333), p(lon_0,-99), p(x_0,600000), p(y_0,4000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3674, ps{p(proj_lcc), p(lat_1,30.28333333333333), p(lat_2,28.38333333333333), p(lat_0,27.83333333333333), p(lon_0,-99), p(x_0,600000), p(y_0,3999999.9998984), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3675, ps{p(proj_lcc), p(lat_1,40.65), p(lat_2,39.01666666666667), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000), p(y_0,2000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3676, ps{p(proj_lcc), p(lat_1,40.65), p(lat_2,39.01666666666667), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000.0001504), p(y_0,1999999.999992), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3677, ps{p(proj_lcc), p(lat_1,40.65), p(lat_2,39.01666666666667), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000.00001016), p(y_0,2000000.00001016), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3678, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.71666666666667), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3679, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.71666666666667), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000.0001504), p(y_0,999999.9999960001), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3680, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.71666666666667), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000.00001016), p(y_0,999999.9999898402), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3681, ps{p(proj_lcc), p(lat_1,38.35), p(lat_2,37.21666666666667), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000), p(y_0,3000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3682, ps{p(proj_lcc), p(lat_1,38.35), p(lat_2,37.21666666666667), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000.0001504), p(y_0,2999999.999988), p(ellps_grs80), p(to_meter,0.3048), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3683, ps{p(proj_lcc), p(lat_1,38.35), p(lat_2,37.21666666666667), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000.00001016), p(y_0,3000000), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3684, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-72.5), p(k,0.999964286), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3685, ps{p(proj_lcc), p(lat_1,39.2), p(lat_2,38.03333333333333), p(lat_0,37.66666666666666), p(lon_0,-78.5), p(x_0,3500000), p(y_0,2000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3686, ps{p(proj_lcc), p(lat_1,39.2), p(lat_2,38.03333333333333), p(lat_0,37.66666666666666), p(lon_0,-78.5), p(x_0,3500000.0001016), p(y_0,2000000.0001016), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3687, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,36.76666666666667), p(lat_0,36.33333333333334), p(lon_0,-78.5), p(x_0,3500000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3688, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,36.76666666666667), p(lat_0,36.33333333333334), p(lon_0,-78.5), p(x_0,3500000.0001016), p(y_0,999999.9998983998), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3689, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.5), p(lat_0,47), p(lon_0,-120.8333333333333), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3690, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.5), p(lat_0,47), p(lon_0,-120.8333333333333), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3691, ps{p(proj_lcc), p(lat_1,47.33333333333334), p(lat_2,45.83333333333334), p(lat_0,45.33333333333334), p(lon_0,-120.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3692, ps{p(proj_lcc), p(lat_1,47.33333333333334), p(lat_2,45.83333333333334), p(lat_0,45.33333333333334), p(lon_0,-120.5), p(x_0,500000.0001016001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3693, ps{p(proj_lcc), p(lat_1,40.25), p(lat_2,39), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3694, ps{p(proj_lcc), p(lat_1,38.88333333333333), p(lat_2,37.48333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3695, ps{p(proj_lcc), p(lat_1,45.5), p(lat_2,44.25), p(lat_0,43.83333333333334), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3696, ps{p(proj_lcc), p(lat_1,45.5), p(lat_2,44.25), p(lat_0,43.83333333333334), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3697, ps{p(proj_lcc), p(lat_1,46.76666666666667), p(lat_2,45.56666666666667), p(lat_0,45.16666666666666), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3698, ps{p(proj_lcc), p(lat_1,46.76666666666667), p(lat_2,45.56666666666667), p(lat_0,45.16666666666666), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3699, ps{p(proj_lcc), p(lat_1,44.06666666666667), p(lat_2,42.73333333333333), p(lat_0,42), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3700, ps{p(proj_lcc), p(lat_1,44.06666666666667), p(lat_2,42.73333333333333), p(lat_0,42), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3701, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-90), p(k,0.9996), p(x_0,520000), p(y_0,-4480000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3702, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-105.1666666666667), p(k,0.9999375), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3703, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-107.3333333333333), p(k,0.9999375), p(x_0,400000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3704, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-108.75), p(k,0.9999375), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3705, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-110.0833333333333), p(k,0.9999375), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3706, ps{p(proj_utm), p(zone,59), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3707, ps{p(proj_utm), p(zone,60), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3708, ps{p(proj_utm), p(zone,1), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3709, ps{p(proj_utm), p(zone,2), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3710, ps{p(proj_utm), p(zone,3), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3711, ps{p(proj_utm), p(zone,4), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3712, ps{p(proj_utm), p(zone,5), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3713, ps{p(proj_utm), p(zone,6), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3714, ps{p(proj_utm), p(zone,7), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3715, ps{p(proj_utm), p(zone,8), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3716, ps{p(proj_utm), p(zone,9), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3717, ps{p(proj_utm), p(zone,10), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3718, ps{p(proj_utm), p(zone,11), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3719, ps{p(proj_utm), p(zone,12), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3720, ps{p(proj_utm), p(zone,13), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3721, ps{p(proj_utm), p(zone,14), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3722, ps{p(proj_utm), p(zone,15), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3723, ps{p(proj_utm), p(zone,16), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3724, ps{p(proj_utm), p(zone,17), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3725, ps{p(proj_utm), p(zone,18), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3726, ps{p(proj_utm), p(zone,19), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3727, ps{p(proj_tmerc), p(lat_0,-21.11666666666667), p(lon_0,55.53333333333333), p(k,1), p(x_0,160000), p(y_0,50000), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(3728, ps{p(proj_lcc), p(lat_1,41.7), p(lat_2,40.43333333333333), p(lat_0,39.66666666666666), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3729, ps{p(proj_lcc), p(lat_1,40.03333333333333), p(lat_2,38.73333333333333), p(lat_0,38), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3730, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-105.1666666666667), p(k,0.9999375), p(x_0,200000.00001016), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3731, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-107.3333333333333), p(k,0.9999375), p(x_0,399999.99998984), p(y_0,99999.99998983997), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3732, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-108.75), p(k,0.9999375), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3733, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-110.0833333333333), p(k,0.9999375), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3734, ps{p(proj_lcc), p(lat_1,41.7), p(lat_2,40.43333333333333), p(lat_0,39.66666666666666), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3735, ps{p(proj_lcc), p(lat_1,40.03333333333333), p(lat_2,38.73333333333333), p(lat_0,38), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3736, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-105.1666666666667), p(k,0.9999375), p(x_0,200000.00001016), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3737, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-107.3333333333333), p(k,0.9999375), p(x_0,399999.99998984), p(y_0,99999.99998983997), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3738, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-108.75), p(k,0.9999375), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3739, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-110.0833333333333), p(k,0.9999375), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3740, ps{p(proj_utm), p(zone,10), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3741, ps{p(proj_utm), p(zone,11), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3742, ps{p(proj_utm), p(zone,12), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3743, ps{p(proj_utm), p(zone,13), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3744, ps{p(proj_utm), p(zone,14), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3745, ps{p(proj_utm), p(zone,15), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3746, ps{p(proj_utm), p(zone,16), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3747, ps{p(proj_utm), p(zone,17), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3748, ps{p(proj_utm), p(zone,18), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3749, ps{p(proj_utm), p(zone,19), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3750, ps{p(proj_utm), p(zone,4), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3751, ps{p(proj_utm), p(zone,5), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3752, ps{p(proj_merc), p(lon_0,100), p(lat_ts,-41), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3753, ps{p(proj_lcc), p(lat_1,41.7), p(lat_2,40.43333333333333), p(lat_0,39.66666666666666), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3754, ps{p(proj_lcc), p(lat_1,40.03333333333333), p(lat_2,38.73333333333333), p(lat_0,38), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3755, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-105.1666666666667), p(k,0.9999375), p(x_0,200000.00001016), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3756, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-107.3333333333333), p(k,0.9999375), p(x_0,399999.99998984), p(y_0,99999.99998983997), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3757, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-108.75), p(k,0.9999375), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3758, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-110.0833333333333), p(k,0.9999375), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3759, ps{p(proj_tmerc), p(lat_0,21.16666666666667), p(lon_0,-158), p(k,0.99999), p(x_0,500000.00001016), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3760, ps{p(proj_tmerc), p(lat_0,21.16666666666667), p(lon_0,-158), p(k,0.99999), p(x_0,500000.00001016), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(3761, ps{p(proj_utm), p(zone,22), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3762, ps{p(proj_lcc), p(lat_1,-54), p(lat_2,-54.75), p(lat_0,-55), p(lon_0,-37), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3763, ps{p(proj_tmerc), p(lat_0,39.66825833333333), p(lon_0,-8.133108333333334), p(k,1), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3764, ps{p(proj_tmerc), p(lat_0,-44), p(lon_0,-176.5), p(k,1), p(x_0,400000), p(y_0,800000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3765, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,16.5), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3766, ps{p(proj_lcc), p(lat_1,45.91666666666666), p(lat_2,43.08333333333334), p(lat_0,0), p(lon_0,16.5), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3767, ps{p(proj_utm), p(zone,33), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3768, ps{p(proj_utm), p(zone,34), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3769, ps{p(proj_utm), p(zone,20), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(3770, ps{p(proj_tmerc), p(lat_0,32), p(lon_0,-64.75), p(k,1), p(x_0,550000), p(y_0,100000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3771, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-111), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3772, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-114), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3773, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-117), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3774, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-120), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3775, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-111), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3776, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-114), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3777, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-117), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3778, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-120), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3779, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-111), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3780, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-114), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3781, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-117), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3782, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-120), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3783, ps{p(proj_tmerc), p(lat_0,-25.06855261111111), p(lon_0,-130.1129671111111), p(k,1), p(x_0,14200), p(y_0,15500), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3784, ps{p(proj_utm), p(zone,9), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{185,165,42,0,0,0,0}),
            ce(3785, ps{p(proj_webmerc), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3786, ps{p(proj_eqc), p(lat_ts,0), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371007), p(units_m), p(no_defs)}),
            ce(3787, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,0.9999), p(x_0,500000), p(y_0,-5000000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(3788, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,166), p(k,1), p(x_0,3500000), p(y_0,10000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3789, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,169), p(k,1), p(x_0,3500000), p(y_0,10000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3790, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,179), p(k,1), p(x_0,3500000), p(y_0,10000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3791, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-178), p(k,1), p(x_0,3500000), p(y_0,10000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3793, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-176.5), p(k,1), p(x_0,3500000), p(y_0,10000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3794, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,0.9999), p(x_0,500000), p(y_0,-5000000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3795, ps{p(proj_lcc), p(lat_1,23), p(lat_2,21.7), p(lat_0,22.35), p(lon_0,-81), p(x_0,500000), p(y_0,280296.016), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3796, ps{p(proj_lcc), p(lat_1,21.3), p(lat_2,20.13333333333333), p(lat_0,20.71666666666667), p(lon_0,-76.83333333333333), p(x_0,500000), p(y_0,229126.939), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3797, ps{p(proj_lcc), p(lat_1,50), p(lat_2,46), p(lat_0,44), p(lon_0,-70), p(x_0,800000), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3798, ps{p(proj_lcc), p(lat_1,50), p(lat_2,46), p(lat_0,44), p(lon_0,-70), p(x_0,800000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3799, ps{p(proj_lcc), p(lat_1,50), p(lat_2,46), p(lat_0,44), p(lon_0,-70), p(x_0,800000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(3800, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-120), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(3801, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-120), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(3802, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-120), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            //{3812}
            //{3814}
            //{3815}
            //{3816}
            ce(3819, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{595.48,121.69,515.35,4.115,2.9383,-0.853,-0.7029504596901044}),
            ce(3821, ps{p(proj_longlat), p(ellps_aust_sa), p(no_defs)}),
            //{3822}
            ce(3823, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(3824, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{3825}
            //{3826}
            //{3827}
            //{3828}
            //{3829}
            //{3832}
            //{3833}
            //{3834}
            //{3835}
            //{3836}
            //{3837}
            //{3838}
            //{3839}
            //{3840}
            //{3841}
            //{3842}
            //{3843}
            //{3844}
            //{3845}
            //{3846}
            //{3847}
            //{3848}
            //{3849}
            //{3850}
            ce(3857, ps{p(proj_webmerc), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(3920, ps{p(proj_utm), p(zone,20), p(ellps_clrk66), p(units_m), p(no_defs)}, towgs84{11,72,-101,0,0,0,0}),
            ce(3942, ps{p(proj_lcc), p(lat_1,41.25), p(lat_2,42.75), p(lat_0,42), p(lon_0,3), p(x_0,1700000), p(y_0,1200000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3943, ps{p(proj_lcc), p(lat_1,42.25), p(lat_2,43.75), p(lat_0,43), p(lon_0,3), p(x_0,1700000), p(y_0,2200000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3944, ps{p(proj_lcc), p(lat_1,43.25), p(lat_2,44.75), p(lat_0,44), p(lon_0,3), p(x_0,1700000), p(y_0,3200000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3945, ps{p(proj_lcc), p(lat_1,44.25), p(lat_2,45.75), p(lat_0,45), p(lon_0,3), p(x_0,1700000), p(y_0,4200000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3946, ps{p(proj_lcc), p(lat_1,45.25), p(lat_2,46.75), p(lat_0,46), p(lon_0,3), p(x_0,1700000), p(y_0,5200000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3947, ps{p(proj_lcc), p(lat_1,46.25), p(lat_2,47.75), p(lat_0,47), p(lon_0,3), p(x_0,1700000), p(y_0,6200000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3948, ps{p(proj_lcc), p(lat_1,47.25), p(lat_2,48.75), p(lat_0,48), p(lon_0,3), p(x_0,1700000), p(y_0,7200000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3949, ps{p(proj_lcc), p(lat_1,48.25), p(lat_2,49.75), p(lat_0,49), p(lon_0,3), p(x_0,1700000), p(y_0,8200000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3950, ps{p(proj_lcc), p(lat_1,49.25), p(lat_2,50.75), p(lat_0,50), p(lon_0,3), p(x_0,1700000), p(y_0,9200000), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(3991, ps{p(proj_lcc), p(lat_1,18.43333333333333), p(lat_2,18.03333333333333), p(lat_0,17.83333333333333), p(lon_0,-66.43333333333334), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{11,72,-101,0,0,0,0}),
            ce(3992, ps{p(proj_lcc), p(lat_1,18.43333333333333), p(lat_2,18.03333333333333), p(lat_0,17.83333333333333), p(lon_0,-66.43333333333334), p(x_0,152400.3048006096), p(y_0,30480.06096012192), p(ellps_clrk66), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{11,72,-101,0,0,0,0}),
            //{3993}
            //{3994}
            //{3995}
            //{3996}
            //{3997}
            ce(4001, ps{p(proj_longlat), p(ellps_airy), p(no_defs)}),
            ce(4002, ps{p(proj_longlat), p(a,6377340.189), p(b,6356034.447938534), p(no_defs)}),
            ce(4003, ps{p(proj_longlat), p(ellps_aust_sa), p(no_defs)}),
            ce(4004, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4005, ps{p(proj_longlat), p(a,6377492.018), p(b,6356173.508712696), p(no_defs)}),
            ce(4006, ps{p(proj_longlat), p(ellps_bess_nam), p(no_defs)}),
            ce(4007, ps{p(proj_longlat), p(a,6378293.645208759), p(b,6356617.987679838), p(no_defs)}),
            ce(4008, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4009, ps{p(proj_longlat), p(a,6378450.047548896), p(b,6356826.621488444), p(no_defs)}),
            ce(4010, ps{p(proj_longlat), p(a,6378300.789), p(b,6356566.435), p(no_defs)}),
            ce(4011, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4012, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4013, ps{p(proj_longlat), p(a,6378249.145), p(b,6356514.966398753), p(no_defs)}),
            ce(4014, ps{p(proj_longlat), p(a,6378249.2), p(b,6356514.996941779), p(no_defs)}),
            ce(4015, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}),
            ce(4016, ps{p(proj_longlat), p(ellps_evrstss), p(no_defs)}),
            ce(4018, ps{p(proj_longlat), p(a,6377304.063), p(b,6356103.038993155), p(no_defs)}),
            ce(4019, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(4020, ps{p(proj_longlat), p(ellps_helmert), p(no_defs)}),
            ce(4021, ps{p(proj_longlat), p(a,6378160), p(b,6356774.50408554), p(no_defs)}),
            ce(4022, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4024, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(4025, ps{p(proj_longlat), p(ellps_wgs66), p(no_defs)}),
            ce(4027, ps{p(proj_longlat), p(a,6376523), p(b,6355862.933255573), p(no_defs)}),
            ce(4028, ps{p(proj_longlat), p(a,6378298.3), p(b,6356657.142669561), p(no_defs)}),
            ce(4029, ps{p(proj_longlat), p(a,6378300), p(b,6356751.689189189), p(no_defs)}),
            ce(4030, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}),
            ce(4031, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}),
            ce(4032, ps{p(proj_longlat), p(a,6378136.2), p(b,6356751.516927429), p(no_defs)}),
            ce(4033, ps{p(proj_longlat), p(a,6378136.3), p(b,6356751.616592146), p(no_defs)}),
            ce(4034, ps{p(proj_longlat), p(a,6378249.144808011), p(b,6356514.966204134), p(no_defs)}),
            ce(4035, ps{p(proj_longlat), p(r,6371000), p(no_defs)}),
            ce(4036, ps{p(proj_longlat), p(ellps_grs67), p(no_defs)}),
            ce(4041, ps{p(proj_longlat), p(a,6378135), p(b,6356750.304921594), p(no_defs)}),
            ce(4042, ps{p(proj_longlat), p(a,6377299.36559538), p(b,6356098.359005157), p(no_defs)}),
            ce(4043, ps{p(proj_longlat), p(ellps_wgs72), p(no_defs)}),
            ce(4044, ps{p(proj_longlat), p(a,6377301.243), p(b,6356100.230165384), p(no_defs)}),
            ce(4045, ps{p(proj_longlat), p(a,6377299.151), p(b,6356098.145120132), p(no_defs)}),
            ce(4047, ps{p(proj_longlat), p(r,6371007), p(no_defs)}),
            ce(4052, ps{p(proj_longlat), p(r,6370997), p(no_defs)}),
            ce(4053, ps{p(proj_longlat), p(r,6371228), p(no_defs)}),
            ce(4054, ps{p(proj_longlat), p(a,6378273), p(b,6356889.449), p(no_defs)}),
            ce(4055, ps{p(proj_longlat), p(r,6378137), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4120, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4121, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-199.87,74.79,246.62,0,0,0,0}),
            ce(4122, ps{p(proj_longlat), p(a,6378135), p(b,6356750.304921594), p(no_defs)}),
            ce(4123, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4124, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4125, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{-404.78,685.68,45.47,0,0,0,0}),
            ce(4126, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(4127, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4128, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4129, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4130, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,-0,-0,-0,0}),
            ce(4131, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}),
            ce(4132, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4133, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014}),
            ce(4134, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4135, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4136, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4137, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4138, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4139, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{11,72,-101,0,0,0,0}),
            ce(4140, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4141, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-48,55,52,0,0,0,0}),
            ce(4142, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-125,53,467,0,0,0,0}),
            ce(4143, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-124.76,53,466.79,0,0,0,0}),
            ce(4144, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}),
            ce(4145, ps{p(proj_longlat), p(a,6377301.243), p(b,6356100.230165384), p(no_defs)}),
            ce(4146, ps{p(proj_longlat), p(a,6377299.151), p(b,6356098.145120132), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(4147, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{-17.51,-108.32,-62.39,0,0,0,0}),
            ce(4148, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4149, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{674.374,15.056,405.346,0,0,0,0}),
            ce(4150, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{674.374,15.056,405.346,0,0,0,0}),
            ce(4151, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4152, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(4153, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-133.63,-157.5,-158.62,0,0,0,0}),
            ce(4154, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4155, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-83,37,124,0,0,0,0}),
            ce(4156, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4157, ps{p(proj_longlat), p(a,6378293.645208759), p(b,6356617.987679838), p(no_defs)}),
            ce(4158, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4159, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4160, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4161, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{27.5,14,186.4,0,0,0,0}),
            ce(4162, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4163, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4164, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{-76,-138,67,0,0,0,0}),
            ce(4165, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-173,253,27,0,0,0,0}),
            ce(4166, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4167, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4168, ps{p(proj_longlat), p(a,6378300), p(b,6356751.689189189), p(no_defs)}, towgs84{-199,32,322,0,0,0,0}),
            ce(4169, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{-115,118,426,0,0,0,0}),
            ce(4170, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4171, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4172, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4173, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4174, ps{p(proj_longlat), p(a,6378300), p(b,6356751.689189189), p(no_defs)}),
            ce(4175, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-88,4,101,0,0,0,0}),
            ce(4176, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4178, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{24,-123,-94,0.02,-0.25,-0.13,1.1}),
            ce(4179, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84}),
            ce(4180, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4181, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-193,13.7,-39.3,-0.41,-2.933,2.688,0.43}),
            ce(4182, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4183, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-104,167,-38,0,0,0,0}),
            ce(4184, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-203,141,53,0,0,0,0}),
            ce(4185, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4188, ps{p(proj_longlat), p(ellps_airy), p(no_defs)}, towgs84{482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15}),
            ce(4189, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4190, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(4191, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(4192, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-206.1,-174.7,-87.7,0,0,0,0}),
            ce(4193, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-70.9,-151.8,-41.4,0,0,0,0}),
            ce(4194, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4195, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{105,326,-102.5,0,0,0.814,-0.6}),
            ce(4196, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-45,417,-3.5,0,0,0.814,-0.6}),
            ce(4197, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4198, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4199, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4200, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(4201, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4202, ps{p(proj_longlat), p(ellps_aust_sa), p(no_defs)}),
            ce(4203, ps{p(proj_longlat), p(ellps_aust_sa), p(no_defs)}),
            ce(4204, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4205, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{-43,-163,45,0,0,0,0}),
            ce(4206, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4207, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4208, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4209, ps{p(proj_longlat), p(a,6378249.145), p(b,6356514.966398753), p(no_defs)}),
            ce(4210, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4211, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4212, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{31.95,300.99,419.19,0,0,0,0}),
            ce(4213, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-106,-87,188,0,0,0,0}),
            ce(4214, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(4215, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4216, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4218, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(4219, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{-384,664,-48,0,0,0,0}),
            ce(4220, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4221, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4222, ps{p(proj_longlat), p(a,6378249.145), p(b,6356514.966398753), p(no_defs)}),
            ce(4223, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4224, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-134,229,-29,0,0,0,0}),
            ce(4225, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-206,172,-6,0,0,0,0}),
            ce(4226, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4227, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4228, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4229, ps{p(proj_longlat), p(ellps_helmert), p(no_defs)}),
            ce(4230, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4231, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4232, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4233, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-133,-321,50,0,0,0,0}),
            ce(4234, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4235, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4236, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-637,-549,-203,0,0,0,0}),
            ce(4237, ps{p(proj_longlat), p(ellps_grs67), p(no_defs)}),
            ce(4238, ps{p(proj_longlat), p(a,6378160), p(b,6356774.50408554), p(no_defs)}),
            ce(4239, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}, towgs84{217,823,299,0,0,0,0}),
            ce(4240, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}),
            ce(4241, ps{p(proj_longlat), p(a,6378249.144808011), p(b,6356514.966204134), p(no_defs)}),
            ce(4242, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4243, ps{p(proj_longlat), p(a,6377299.36559538), p(b,6356098.359005157), p(no_defs)}),
            ce(4244, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}, towgs84{-97,787,86,0,0,0,0}),
            ce(4245, ps{p(proj_longlat), p(a,6377304.063), p(b,6356103.038993155), p(no_defs)}, towgs84{-11,851,5,0,0,0,0}),
            ce(4246, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-294.7,-200.1,525.5,0,0,0,0}),
            ce(4247, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-273.5,110.6,-357.9,0,0,0,0}),
            ce(4248, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4249, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4250, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-130,29,364,0,0,0,0}),
            ce(4251, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-90,40,88,0,0,0,0}),
            ce(4252, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4253, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4254, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4255, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-333,-222,114,0,0,0,0}),
            ce(4256, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{41,-220,-134,0,0,0,0}),
            ce(4257, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{-587.8,519.75,145.76,0,0,0,0}),
            ce(4258, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(4259, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4260, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-70.9,-151.8,-41.4,0,0,0,0}),
            ce(4261, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{31,146,47,0,0,0,0}),
            ce(4262, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{639,405,60,0,0,0,0}),
            ce(4263, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4264, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-252.95,-4.11,-96.38,0,0,0,0}),
            ce(4265, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4266, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4267, ps{p(proj_longlat), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(no_defs)}),
            ce(4268, ps{p(proj_longlat), p(a,6378450.047548896), p(b,6356826.621488444), p(no_defs)}),
            ce(4269, ps{p(proj_longlat), p(ellps_grs80), p(srs::dpar::datum_nad83), p(no_defs)}),
            ce(4270, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4271, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4272, ps{p(proj_longlat), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(no_defs)}),
            ce(4273, ps{p(proj_longlat), p(a,6377492.018), p(b,6356173.508712696), p(no_defs)}, towgs84{278.3,93,474.5,7.889,0.05,-6.61,6.21}),
            ce(4274, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4275, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(4276, ps{p(proj_longlat), p(ellps_wgs66), p(no_defs)}),
            ce(4277, ps{p(proj_longlat), p(ellps_airy), p(srs::dpar::datum_osgb36), p(no_defs)}),
            ce(4278, ps{p(proj_longlat), p(ellps_airy), p(no_defs)}),
            ce(4279, ps{p(proj_longlat), p(ellps_airy), p(no_defs)}),
            ce(4280, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4281, ps{p(proj_longlat), p(a,6378300.789), p(b,6356566.435), p(no_defs)}, towgs84{-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1}),
            ce(4282, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4283, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4284, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(4285, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4286, ps{p(proj_longlat), p(ellps_helmert), p(no_defs)}),
            ce(4287, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{164,138,-189,0,0,0,0}),
            ce(4288, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4289, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4291, ps{p(proj_longlat), p(ellps_grs67), p(no_defs)}),
            ce(4292, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-355,21,72,0,0,0,0}),
            ce(4293, ps{p(proj_longlat), p(ellps_bess_nam), p(no_defs)}),
            ce(4294, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4295, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4296, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4297, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-189,-242,-91,0,0,0,0}),
            ce(4298, ps{p(proj_longlat), p(ellps_evrstss), p(no_defs)}),
            ce(4299, ps{p(proj_longlat), p(a,6377340.189), p(b,6356034.447938534), p(no_defs)}),
            ce(4300, ps{p(proj_longlat), p(a,6377340.189), p(b,6356034.447938534), p(no_defs)}),
            ce(4301, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4302, ps{p(proj_longlat), p(a,6378293.645208759), p(b,6356617.987679838), p(no_defs)}),
            ce(4303, ps{p(proj_longlat), p(ellps_helmert), p(no_defs)}),
            ce(4304, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-73,-247,227,0,0,0,0}),
            ce(4306, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4307, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4308, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4309, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-155,171,37,0,0,0,0}),
            ce(4310, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4311, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-265,120,-358,0,0,0,0}),
            ce(4312, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(4313, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1}),
            ce(4314, ps{p(proj_longlat), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(no_defs)}),
            ce(4315, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-23,259,-9,0,0,0,0}),
            ce(4316, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4317, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(4318, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{-3.2,-5.7,2.8,0,0,0,0}),
            ce(4319, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(4322, ps{p(proj_longlat), p(ellps_wgs72), p(no_defs)}),
            ce(4324, ps{p(proj_longlat), p(ellps_wgs72), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(4326, ps{p(proj_longlat), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(no_defs)}),
            ce(4327, ps{p(proj_longlat), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(no_defs)}),
            //{4328}
            ce(4329, ps{p(proj_longlat), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(no_defs)}),
            //{4330}
            //{4331}
            //{4332}
            //{4333}
            //{4334}
            //{4335}
            //{4336}
            //{4337}
            //{4338}
            ce(4339, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4340}
            ce(4341, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4342}
            ce(4343, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4344}
            ce(4345, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4346}
            ce(4347, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4348}
            ce(4349, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4350}
            ce(4351, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4352}
            ce(4353, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4354}
            ce(4355, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4356}
            ce(4357, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,-0.0,0.0,0.0,0.0}),
            //{4358}
            ce(4359, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0}),
            //{4360}
            ce(4361, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0}),
            //{4362}
            ce(4363, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4364}
            ce(4365, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4366}
            ce(4367, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4368}
            ce(4369, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4370}
            ce(4371, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{2.0,2.0,-2.0,0.0,0.0,0.0,0.0}),
            //{4372}
            ce(4373, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4374}
            ce(4375, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4376}
            ce(4377, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4378}
            ce(4379, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4380}
            ce(4381, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4382}
            ce(4383, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4384}
            //{4385}
            ce(4386, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4387}
            ce(4388, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4389}
            ce(4600, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4601, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4602, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{725,685,536,0,0,0,0}),
            ce(4603, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{72,213.7,93,0,0,0,0}),
            ce(4604, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{174,359,365,0,0,0,0}),
            ce(4605, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4606, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-149,128,296,0,0,0,0}),
            ce(4607, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{195.671,332.517,274.607,0,0,0,0}),
            ce(4608, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4609, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4610, ps{p(proj_longlat), p(a,6378140), p(b,6356755.288157528), p(no_defs)}),
            ce(4611, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425}),
            ce(4612, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4613, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4614, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706}),
            ce(4615, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-499,-249,314,0,0,0,0}),
            ce(4616, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4617, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(4618, ps{p(proj_longlat), p(ellps_aust_sa), p(no_defs)}),
            ce(4619, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4620, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-106,-129,165,0,0,0,0}),
            ce(4621, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{137,248,-430,0,0,0,0}),
            ce(4622, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4623, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-186,230,110,0,0,0,0}),
            ce(4624, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{2,2,-2,0,0,0,0}),
            ce(4625, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4626, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4627, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4628, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{162,117,154,0,0,0,0}),
            ce(4629, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4630, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4631, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{145,-187,103,0,0,0,0}),
            ce(4632, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-382,-59,-262,0,0,0,0}),
            ce(4633, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4634, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4635, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798}),
            ce(4636, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{365,194,166,0,0,0,0}),
            ce(4637, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{325,154,172,0,0,0,0}),
            ce(4638, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{30,430,368,0,0,0,0}),
            ce(4639, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4640, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4641, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4642, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4643, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7}),
            ce(4644, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4645, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4646, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4657, ps{p(proj_longlat), p(a,6377019.27), p(b,6355762.5391), p(no_defs)}, towgs84{-28,199,5,0,0,0,0}),
            ce(4658, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-73,46,-86,0,0,0,0}),
            ce(4659, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4660, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{982.609,552.753,-540.873,32.3934,-153.257,-96.2266,16.805}),
            ce(4661, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4662, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4663, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4664, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4665, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4666, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4667, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4668, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-86,-98,-119,0,0,0,0}),
            ce(4669, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4670, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4671, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(4672, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{175,-38,113,0,0,0,0}),
            ce(4673, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{174.05,-25.49,112.57,-0,-0,0.554,0.2263}),
            ce(4674, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4675, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{-100,-248,259,0,0,0,0}),
            ce(4676, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(4677, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(4678, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{44.585,-131.212,-39.544,0,0,0,0}),
            ce(4679, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-80.01,253.26,291.19,0,0,0,0}),
            ce(4680, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{124.5,-63.5,-281,0,0,0,0}),
            ce(4681, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4682, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}),
            ce(4683, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06}),
            ce(4684, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-133,-321,50,0,0,0,0}),
            ce(4685, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4686, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4687, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(4688, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074}),
            ce(4689, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4690, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4691, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773}),
            ce(4692, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{217.037,86.959,23.956,0,0,0,0}),
            ce(4693, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,-0.15,0.68,0,0,0,0}),
            ce(4694, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4695, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4696, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4697, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4698, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{145,-187,103,0,0,0,0}),
            ce(4699, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-770.1,158.4,-498.2,0,0,0,0}),
            ce(4700, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4701, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-79.9,-158,-168.9,0,0,0,0}),
            ce(4702, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4703, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4704, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4705, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4706, ps{p(proj_longlat), p(ellps_helmert), p(no_defs)}, towgs84{-146.21,112.63,4.05,0,0,0,0}),
            ce(4707, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{114,-116,-333,0,0,0,0}),
            ce(4708, ps{p(proj_longlat), p(ellps_aust_sa), p(no_defs)}, towgs84{-491,-22,435,0,0,0,0}),
            ce(4709, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{145,75,-272,0,0,0,0}),
            ce(4710, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-320,550,-494,0,0,0,0}),
            ce(4711, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{124,-234,-25,0,0,0,0}),
            ce(4712, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-205,107,53,0,0,0,0}),
            ce(4713, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-79,-129,145,0,0,0,0}),
            ce(4714, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-127,-769,472,0,0,0,0}),
            ce(4715, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-104,-129,239,0,0,0,0}),
            ce(4716, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{298,-304,-375,0,0,0,0}),
            ce(4717, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{-2,151,181,0,0,0,0}),
            ce(4718, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4719, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{211,147,111,0,0,0,0}),
            ce(4720, ps{p(proj_longlat), p(ellps_wgs72), p(no_defs)}),
            ce(4721, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{265.025,384.929,-194.046,0,0,0,0}),
            ce(4722, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-794,119,-298,0,0,0,0}),
            ce(4723, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{67.8,106.1,138.8,0,0,0,0}),
            ce(4724, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{208,-435,-229,0,0,0,0}),
            ce(4725, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{189,-79,-202,0,0,0,0}),
            ce(4726, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(4727, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4728, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-307,-92,127,0,0,0,0}),
            ce(4729, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{185,165,42,0,0,0,0}),
            ce(4730, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{170,42,84,0,0,0,0}),
            ce(4731, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{51,391,-36,0,0,0,0}),
            ce(4732, ps{p(proj_longlat), p(a,6378270), p(b,6356794.343434343), p(no_defs)}, towgs84{102,52,-38,0,0,0,0}),
            ce(4733, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{276,-57,149,0,0,0,0}),
            ce(4734, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-632,438,-609,0,0,0,0}),
            ce(4735, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{647,1777,-1124,0,0,0,0}),
            ce(4736, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{260,12,-147,0,0,0,0}),
            ce(4737, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4738, ps{p(proj_longlat), p(a,6378293.645208759), p(b,6356617.987679838), p(no_defs)}),
            ce(4739, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-156,-271,-189,0,0,0,0}),
            ce(4740, ps{p(proj_longlat), p(a,6378136), p(b,6356751.361745712), p(no_defs)}, towgs84{0,0,1.5,-0,-0,0.076,0}),
            ce(4741, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4742, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(4743, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{84.1,-320.1,218.7,0,0,0,0}),
            ce(4744, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(4745, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4746, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(4747, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4748, ps{p(proj_longlat), p(a,6378306.3696), p(b,6356571.996), p(no_defs)}, towgs84{51,391,-36,0,0,0,0}),
            ce(4749, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4750, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{-56.263,16.136,-22.856,0,0,0,0}),
            ce(4751, ps{p(proj_longlat), p(a,6377295.664), p(b,6356094.667915204), p(no_defs)}),
            ce(4752, ps{p(proj_longlat), p(a,6378306.3696), p(b,6356571.996), p(no_defs)}, towgs84{51,391,-36,0,0,0,0}),
            ce(4753, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(4754, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-208.406,-109.878,-2.5764,0,0,0,0}),
            ce(4755, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4756, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}),
            ce(4757, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}),
            ce(4758, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4759, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4760, ps{p(proj_longlat), p(ellps_wgs66), p(no_defs)}),
            ce(4761, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4762, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4763, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4764, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4765, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(4801, ps{p(proj_longlat), p(ellps_bessel), p(pm_bern), p(no_defs)}),
            ce(4802, ps{p(proj_longlat), p(ellps_intl), p(pm_bogota), p(no_defs)}),
            ce(4803, ps{p(proj_longlat), p(ellps_intl), p(pm_lisbon), p(no_defs)}),
            ce(4804, ps{p(proj_longlat), p(ellps_bessel), p(pm_jakarta), p(no_defs)}, towgs84{-587.8,519.75,145.76,0,0,0,0}),
            ce(4805, ps{p(proj_longlat), p(ellps_bessel), p(pm_ferro), p(no_defs)}),
            ce(4806, ps{p(proj_longlat), p(ellps_intl), p(pm_rome), p(no_defs)}),
            ce(4807, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(pm_paris), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(4808, ps{p(proj_longlat), p(ellps_bessel), p(pm_jakarta), p(no_defs)}),
            ce(4809, ps{p(proj_longlat), p(ellps_intl), p(pm_brussels), p(no_defs)}),
            ce(4810, ps{p(proj_longlat), p(ellps_intl), p(pm_paris), p(no_defs)}, towgs84{-189,-242,-91,0,0,0,0}),
            ce(4811, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(pm_paris), p(no_defs)}, towgs84{-73,-247,227,0,0,0,0}),
            ce(4813, ps{p(proj_longlat), p(ellps_bessel), p(pm_jakarta), p(no_defs)}),
            ce(4814, ps{p(proj_longlat), p(ellps_bessel), p(pm_stockholm), p(no_defs)}),
            ce(4815, ps{p(proj_longlat), p(ellps_bessel), p(pm_athens), p(no_defs)}),
            ce(4816, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(pm_paris), p(no_defs)}),
            ce(4817, ps{p(proj_longlat), p(a,6377492.018), p(b,6356173.508712696), p(pm_oslo), p(no_defs)}, towgs84{278.3,93,474.5,7.889,0.05,-6.61,6.21}),
            ce(4818, ps{p(proj_longlat), p(ellps_bessel), p(pm_ferro), p(no_defs)}),
            ce(4819, ps{p(proj_longlat), p(ellps_clrk80), p(pm_paris), p(no_defs)}),
            ce(4820, ps{p(proj_longlat), p(ellps_bessel), p(pm_jakarta), p(no_defs)}),
            ce(4821, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(pm_paris), p(no_defs)}),
            //{4882}
            ce(4883, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4884}
            ce(4885, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4886}
            ce(4887, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4888}
            ce(4889, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4890}
            ce(4891, ps{p(proj_longlat), p(ellps_wgs66), p(no_defs)}),
            //{4892}
            ce(4893, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4894}
            ce(4895, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4896}
            //{4897}
            ce(4898, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4899}
            ce(4900, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-208.4058,-109.8777,-2.5764,0.0,0.0,0.0,0.0}),
            ce(4901, ps{p(proj_longlat), p(a,6376523), p(b,6355862.933255573), p(pm,2.3372291666985), p(no_defs)}),
            ce(4902, ps{p(proj_longlat), p(a,6376523), p(b,6355862.933255573), p(pm_paris), p(no_defs)}),
            ce(4903, ps{p(proj_longlat), p(a,6378298.3), p(b,6356657.142669561), p(pm_madrid), p(no_defs)}),
            ce(4904, ps{p(proj_longlat), p(ellps_bessel), p(pm_lisbon), p(no_defs)}),
            //{4906}
            ce(4907, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4908}
            ce(4909, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4910}
            //{4911}
            //{4912}
            //{4913}
            //{4914}
            //{4915}
            //{4916}
            //{4917}
            //{4918}
            //{4919}
            //{4920}
            ce(4921, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            //{4922}
            ce(4923, ps{p(proj_longlat), p(a,6378136), p(b,6356751.361745712), p(no_defs)}, towgs84{0.0,0.0,1.5,-0.0,0.0,-0.076,0.0}),
            //{4924}
            ce(4925, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4926}
            ce(4927, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4928}
            ce(4929, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            //{4930}
            ce(4931, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4932}
            ce(4933, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4934}
            ce(4935, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4936}
            ce(4937, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4938}
            ce(4939, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4940}
            ce(4941, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4942}
            ce(4943, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4944}
            ce(4945, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4946}
            ce(4947, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4948}
            ce(4949, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4950}
            ce(4951, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4952}
            ce(4953, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,-0.0,0.0,0.0,0.0}),
            //{4954}
            ce(4955, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0}),
            //{4956}
            ce(4957, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0}),
            //{4958}
            ce(4959, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4960}
            ce(4961, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4962}
            ce(4963, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4964}
            ce(4965, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4966}
            ce(4967, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{2.0,2.0,-2.0,0.0,0.0,0.0,0.0}),
            //{4968}
            ce(4969, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4970}
            ce(4971, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4972}
            ce(4973, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4974}
            ce(4975, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4976}
            ce(4977, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4978}
            ce(4979, ps{p(proj_longlat), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(no_defs)}),
            //{4980}
            ce(4981, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4982}
            ce(4983, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4984}
            ce(4985, ps{p(proj_longlat), p(ellps_wgs72), p(no_defs)}, towgs84{0.0,0.0,4.5,0.0,0.0,0.554,0.045171992568114105}),
            //{4986}
            ce(4987, ps{p(proj_longlat), p(ellps_wgs72), p(no_defs)}, towgs84{0.0,0.0,1.9,0.0,0.0,0.814,-0.07838062637389662}),
            //{4988}
            ce(4989, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4990}
            ce(4991, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            //{4992}
            ce(4993, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{44.585,-131.212,-39.544,0.0,0.0,0.0,0.0}),
            //{4994}
            ce(4995, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{-127.62,-67.24,-47.04,-3.068,-4.903,-1.578,-0.21864069462192215}),
            //{4996}
            ce(4997, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            //{4998}
            ce(4999, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.072,-0.507,-0.245,-0.0183,-0.0003,0.007,-0.001918262698097996}),
            //{5600}
            //{5601}
            //{5602}
            //{5603}
            //{5604}
            //{5605}
            //{5606}
            //{5607}
            //{5608}
            //{5609}
            //{5610}
            //{5611}
            //{5612}
            //{5613}
            //{5614}
            //{5615}
            //{5616}
            //{5617}
            //{5618}
            //{5619}
            //{5620}
            //{5701}
            //{5702}
            //{5703}
            //{5704}
            //{5705}
            //{5706}
            //{5709}
            //{5710}
            //{5711}
            //{5712}
            //{5713}
            //{5714}
            //{5715}
            //{5716}
            //{5717}
            //{5718}
            //{5719}
            //{5720}
            //{5721}
            //{5722}
            //{5723}
            //{5724}
            //{5725}
            //{5726}
            //{5727}
            //{5728}
            //{5729}
            //{5730}
            //{5731}
            //{5732}
            //{5733}
            //{5734}
            //{5735}
            //{5736}
            //{5737}
            //{5738}
            //{5739}
            //{5740}
            //{5741}
            //{5742}
            //{5743}
            //{5744}
            //{5745}
            //{5746}
            //{5747}
            //{5748}
            //{5749}
            //{5750}
            //{5751}
            //{5752}
            //{5753}
            //{5754}
            //{5755}
            //{5756}
            //{5757}
            //{5758}
            //{5759}
            //{5760}
            //{5761}
            //{5762}
            //{5763}
            //{5764}
            //{5765}
            //{5766}
            //{5767}
            //{5768}
            //{5769}
            //{5770}
            //{5771}
            //{5772}
            //{5773}
            //{5774}
            //{5775}
            //{5776}
            //{5777}
            //{5778}
            //{5779}
            //{5780}
            //{5781}
            //{5782}
            //{5783}
            //{5784}
            //{5785}
            //{5786}
            //{5787}
            //{5788}
            //{5789}
            //{5790}
            //{5791}
            //{5792}
            //{5793}
            //{5794}
            //{5795}
            //{5796}
            //{5797}
            //{5798}
            //{5799}
            //{5800}
            //{5801}
            //{5802}
            //{5803}
            //{5804}
            //{5805}
            //{5806}
            //{5807}
            //{5808}
            //{5809}
            //{5810}
            //{5811}
            //{5812}
            //{5813}
            //{5814}
            //{5815}
            //{5816}
            //{5817}
            //{5818}
            //{5819}
            //{5820}
            //{5821}
            ce(6247, ps{p(proj_col_urban), p(lon_0,-74.1465916666667), p(lat_0,4.68048611111111), p(x_0,92334.879), p(y_0,109320.965), p(h_0,2550), p(ellps_grs80), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            //{7400}
            //{7401}
            //{7402}
            //{7403}
            //{7404}
            //{7405}
            //{7406}
            //{7407}
            //{7408}
            //{7409}
            //{7410}
            //{7411}
            //{7412}
            //{7413}
            //{7414}
            //{7415}
            //{7416}
            //{7417}
            //{7418}
            //{7419}
            //{7420}
            //{7421}
            //{7422}
            ce(20004, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20005, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20006, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,6500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20007, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,7500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20008, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,8500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20009, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,9500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20010, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,57), p(k,1), p(x_0,10500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20011, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,63), p(k,1), p(x_0,11500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20012, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,69), p(k,1), p(x_0,12500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20013, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,13500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20014, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,14500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20015, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,15500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20016, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,16500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20017, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,17500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20018, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,18500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20019, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,19500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20020, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,20500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20021, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,21500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20022, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,22500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20023, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,23500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20024, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,141), p(k,1), p(x_0,24500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20025, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,147), p(k,1), p(x_0,25500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20026, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,153), p(k,1), p(x_0,26500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20027, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,159), p(k,1), p(x_0,27500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20028, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,165), p(k,1), p(x_0,28500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20029, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,171), p(k,1), p(x_0,29500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20030, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,177), p(k,1), p(x_0,30500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20031, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-177), p(k,1), p(x_0,31500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20032, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-171), p(k,1), p(x_0,32500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20064, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20065, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20066, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20067, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20068, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20069, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20070, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,57), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20071, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,63), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20072, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,69), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20073, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20074, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20075, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20076, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20077, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20078, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20079, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20080, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20081, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20082, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20083, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20084, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,141), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20085, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,147), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20086, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,153), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20087, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,159), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20088, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,165), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20089, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20090, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20091, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20092, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(20135, ps{p(proj_utm), p(zone,35), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(20136, ps{p(proj_utm), p(zone,36), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(20137, ps{p(proj_utm), p(zone,37), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(20138, ps{p(proj_utm), p(zone,38), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(20248, ps{p(proj_utm), p(zone,48), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20249, ps{p(proj_utm), p(zone,49), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20250, ps{p(proj_utm), p(zone,50), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20251, ps{p(proj_utm), p(zone,51), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20252, ps{p(proj_utm), p(zone,52), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20253, ps{p(proj_utm), p(zone,53), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20254, ps{p(proj_utm), p(zone,54), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20255, ps{p(proj_utm), p(zone,55), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20256, ps{p(proj_utm), p(zone,56), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20257, ps{p(proj_utm), p(zone,57), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20258, ps{p(proj_utm), p(zone,58), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20348, ps{p(proj_utm), p(zone,48), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20349, ps{p(proj_utm), p(zone,49), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20350, ps{p(proj_utm), p(zone,50), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20351, ps{p(proj_utm), p(zone,51), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20352, ps{p(proj_utm), p(zone,52), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20353, ps{p(proj_utm), p(zone,53), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20354, ps{p(proj_utm), p(zone,54), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20355, ps{p(proj_utm), p(zone,55), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20356, ps{p(proj_utm), p(zone,56), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20357, ps{p(proj_utm), p(zone,57), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20358, ps{p(proj_utm), p(zone,58), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(20436, ps{p(proj_utm), p(zone,36), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(20437, ps{p(proj_utm), p(zone,37), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(20438, ps{p(proj_utm), p(zone,38), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(20439, ps{p(proj_utm), p(zone,39), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(20440, ps{p(proj_utm), p(zone,40), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(20499, ps{p(proj_utm), p(zone,39), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(20538, ps{p(proj_utm), p(zone,38), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{-43,-163,45,0,0,0,0}),
            ce(20539, ps{p(proj_utm), p(zone,39), p(ellps_krass), p(units_m), p(no_defs)}, towgs84{-43,-163,45,0,0,0,0}),
            ce(20790, ps{p(proj_tmerc), p(lat_0,39.66666666666666), p(lon_0,1), p(k,1), p(x_0,200000), p(y_0,300000), p(ellps_intl), p(pm_lisbon), p(units_m), p(no_defs)}),
            ce(20791, ps{p(proj_tmerc), p(lat_0,39.66666666666666), p(lon_0,1), p(k,1), p(x_0,0), p(y_0,0), p(ellps_intl), p(pm_lisbon), p(units_m), p(no_defs)}),
            ce(20822, ps{p(proj_utm), p(zone,22), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(20823, ps{p(proj_utm), p(zone,23), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(20824, ps{p(proj_utm), p(zone,24), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(20934, ps{p(proj_utm), p(zone,34), p(south), p(a,6378249.145), p(b,6356514.966398753), p(units_m), p(no_defs)}),
            ce(20935, ps{p(proj_utm), p(zone,35), p(south), p(a,6378249.145), p(b,6356514.966398753), p(units_m), p(no_defs)}),
            ce(20936, ps{p(proj_utm), p(zone,36), p(south), p(a,6378249.145), p(b,6356514.966398753), p(units_m), p(no_defs)}),
            ce(21035, ps{p(proj_utm), p(zone,35), p(south), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(21036, ps{p(proj_utm), p(zone,36), p(south), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(21037, ps{p(proj_utm), p(zone,37), p(south), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(21095, ps{p(proj_utm), p(zone,35), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(21096, ps{p(proj_utm), p(zone,36), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(21097, ps{p(proj_utm), p(zone,37), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(21100, ps{p(proj_merc), p(lon_0,110), p(k,0.997), p(x_0,3900000), p(y_0,900000), p(ellps_bessel), p(pm_jakarta), p(units_m), p(no_defs)}),
            ce(21148, ps{p(proj_utm), p(zone,48), p(south), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(21149, ps{p(proj_utm), p(zone,49), p(south), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(21150, ps{p(proj_utm), p(zone,50), p(south), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(21291, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-62), p(k,0.9995000000000001), p(x_0,400000), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{31.95,300.99,419.19,0,0,0,0}),
            ce(21292, ps{p(proj_tmerc), p(lat_0,13.17638888888889), p(lon_0,-59.55972222222222), p(k,0.9999986), p(x_0,30000), p(y_0,75000), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{31.95,300.99,419.19,0,0,0,0}),
            ce(21413, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,13500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21414, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,14500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21415, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,15500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21416, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,16500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21417, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,17500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21418, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,18500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21419, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,19500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21420, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,20500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21421, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,21500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21422, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,22500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21423, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,23500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21453, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21454, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21455, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21456, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21457, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21458, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21459, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21460, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21461, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21462, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21463, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21473, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21474, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21475, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21476, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21477, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21478, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21479, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21480, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21481, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21482, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21483, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(21500, ps{p(proj_lcc), p(lat_1,49.83333333333334), p(lat_2,51.16666666666666), p(lat_0,90), p(lon_0,0), p(x_0,150000), p(y_0,5400000), p(ellps_intl), p(pm_brussels), p(units_m), p(no_defs)}),
            ce(21780, ps{p(proj_somerc), p(lat_0,46.95240555555556), p(lon_0,0), p(k_0,1), p(x_0,0), p(y_0,0), p(ellps_bessel), p(pm_bern), p(units_m), p(no_defs)}),
            ce(21781, ps{p(proj_somerc), p(lat_0,46.95240555555556), p(lon_0,7.439583333333333), p(k_0,1), p(x_0,600000), p(y_0,200000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{674.374,15.056,405.346,0,0,0,0}),
            //{21782}
            ce(21817, ps{p(proj_utm), p(zone,17), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(21818, ps{p(proj_utm), p(zone,18), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(21891, ps{p(proj_tmerc), p(lat_0,4.599047222222222), p(lon_0,-77.08091666666667), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(21892, ps{p(proj_tmerc), p(lat_0,4.599047222222222), p(lon_0,-74.08091666666667), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(21893, ps{p(proj_tmerc), p(lat_0,4.599047222222222), p(lon_0,-71.08091666666667), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(21894, ps{p(proj_tmerc), p(lat_0,4.599047222222222), p(lon_0,-68.08091666666667), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(21896, ps{p(proj_tmerc), p(lat_0,4.599047222222222), p(lon_0,-77.08091666666667), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(21897, ps{p(proj_tmerc), p(lat_0,4.599047222222222), p(lon_0,-74.08091666666667), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(21898, ps{p(proj_tmerc), p(lat_0,4.599047222222222), p(lon_0,-71.08091666666667), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(21899, ps{p(proj_tmerc), p(lat_0,4.599047222222222), p(lon_0,-68.08091666666667), p(k,1), p(x_0,1000000), p(y_0,1000000), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{307,304,-318,0,0,0,0}),
            ce(22032, ps{p(proj_utm), p(zone,32), p(south), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(22033, ps{p(proj_utm), p(zone,33), p(south), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(22091, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,11.5), p(k,0.9996), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(22092, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,0.9996), p(x_0,500000), p(y_0,10000000), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(22171, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-72), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(22172, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-69), p(k,1), p(x_0,2500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(22173, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-66), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(22174, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-63), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(22175, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-60), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(22176, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-57), p(k,1), p(x_0,6500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(22177, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-54), p(k,1), p(x_0,7500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(22181, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-72), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(22182, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-69), p(k,1), p(x_0,2500000), p(y_0,0), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(22183, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-66), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(22184, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-63), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(22185, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-60), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(22186, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-57), p(k,1), p(x_0,6500000), p(y_0,0), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(22187, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-54), p(k,1), p(x_0,7500000), p(y_0,0), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(22191, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-72), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(22192, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-69), p(k,1), p(x_0,2500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(22193, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-66), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(22194, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-63), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(22195, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-60), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(22196, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-57), p(k,1), p(x_0,6500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(22197, ps{p(proj_tmerc), p(lat_0,-90), p(lon_0,-54), p(k,1), p(x_0,7500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(22234, ps{p(proj_utm), p(zone,34), p(south), p(a,6378249.145), p(b,6356514.966398753), p(units_m), p(no_defs)}),
            ce(22235, ps{p(proj_utm), p(zone,35), p(south), p(a,6378249.145), p(b,6356514.966398753), p(units_m), p(no_defs)}),
            ce(22236, ps{p(proj_utm), p(zone,36), p(south), p(a,6378249.145), p(b,6356514.966398753), p(units_m), p(no_defs)}),
            //{22275}
            //{22277}
            //{22279}
            //{22281}
            //{22283}
            //{22285}
            //{22287}
            //{22289}
            //{22291}
            //{22293}
            //{22300}
            ce(22332, ps{p(proj_utm), p(zone,32), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(22391, ps{p(proj_lcc), p(lat_1,36), p(lat_0,36), p(lon_0,9.9), p(k_0,0.999625544), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(22392, ps{p(proj_lcc), p(lat_1,33.3), p(lat_0,33.3), p(lon_0,9.9), p(k_0,0.999625769), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(22521, ps{p(proj_utm), p(zone,21), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-206,172,-6,0,0,0,0}),
            ce(22522, ps{p(proj_utm), p(zone,22), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-206,172,-6,0,0,0,0}),
            ce(22523, ps{p(proj_utm), p(zone,23), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-206,172,-6,0,0,0,0}),
            ce(22524, ps{p(proj_utm), p(zone,24), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-206,172,-6,0,0,0,0}),
            ce(22525, ps{p(proj_utm), p(zone,25), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-206,172,-6,0,0,0,0}),
            ce(22700, ps{p(proj_lcc), p(lat_1,34.65), p(lat_0,34.65), p(lon_0,37.35), p(k_0,0.9996256), p(x_0,300000), p(y_0,300000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(22770, ps{p(proj_lcc), p(lat_1,34.65), p(lat_0,34.65), p(lon_0,37.35), p(k_0,0.9996256), p(x_0,300000), p(y_0,300000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(22780, ps{p(proj_sterea), p(lat_0,34.2), p(lon_0,39.15), p(k,0.9995341), p(x_0,0), p(y_0,0), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(22832, ps{p(proj_utm), p(zone,32), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(22991, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,35), p(k,1), p(x_0,300000), p(y_0,1100000), p(ellps_helmert), p(units_m), p(no_defs)}),
            ce(22992, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,31), p(k,1), p(x_0,615000), p(y_0,810000), p(ellps_helmert), p(units_m), p(no_defs)}),
            ce(22993, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,27), p(k,1), p(x_0,700000), p(y_0,200000), p(ellps_helmert), p(units_m), p(no_defs)}),
            ce(22994, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,27), p(k,1), p(x_0,700000), p(y_0,1200000), p(ellps_helmert), p(units_m), p(no_defs)}),
            ce(23028, ps{p(proj_utm), p(zone,28), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23029, ps{p(proj_utm), p(zone,29), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23030, ps{p(proj_utm), p(zone,30), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23031, ps{p(proj_utm), p(zone,31), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23032, ps{p(proj_utm), p(zone,32), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23033, ps{p(proj_utm), p(zone,33), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23034, ps{p(proj_utm), p(zone,34), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23035, ps{p(proj_utm), p(zone,35), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23036, ps{p(proj_utm), p(zone,36), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23037, ps{p(proj_utm), p(zone,37), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23038, ps{p(proj_utm), p(zone,38), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23090, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,0), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23095, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,5), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(23239, ps{p(proj_utm), p(zone,39), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(23240, ps{p(proj_utm), p(zone,40), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(23433, ps{p(proj_utm), p(zone,33), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(23700, ps{p(proj_somerc), p(lat_0,47.14439372222222), p(lon_0,19.04857177777778), p(k_0,0.99993), p(x_0,650000), p(y_0,200000), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(23830, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,94.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23831, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,97.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23832, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,100.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23833, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,103.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23834, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,106.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23835, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,109.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23836, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,112.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23837, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,115.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23838, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,118.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23839, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,121.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23840, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,124.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23841, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,127.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23842, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,130.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23843, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,133.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23844, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,136.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23845, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,139.5), p(k,0.9999), p(x_0,200000), p(y_0,1500000), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23846, ps{p(proj_utm), p(zone,46), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23847, ps{p(proj_utm), p(zone,47), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23848, ps{p(proj_utm), p(zone,48), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23849, ps{p(proj_utm), p(zone,49), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23850, ps{p(proj_utm), p(zone,50), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23851, ps{p(proj_utm), p(zone,51), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23852, ps{p(proj_utm), p(zone,52), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23853, ps{p(proj_utm), p(zone,53), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23866, ps{p(proj_utm), p(zone,46), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23867, ps{p(proj_utm), p(zone,47), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23868, ps{p(proj_utm), p(zone,48), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23869, ps{p(proj_utm), p(zone,49), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23870, ps{p(proj_utm), p(zone,50), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23871, ps{p(proj_utm), p(zone,51), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23872, ps{p(proj_utm), p(zone,52), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23877, ps{p(proj_utm), p(zone,47), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23878, ps{p(proj_utm), p(zone,48), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23879, ps{p(proj_utm), p(zone,49), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23880, ps{p(proj_utm), p(zone,50), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23881, ps{p(proj_utm), p(zone,51), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23882, ps{p(proj_utm), p(zone,52), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23883, ps{p(proj_utm), p(zone,53), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23884, ps{p(proj_utm), p(zone,54), p(south), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(23886, ps{p(proj_utm), p(zone,46), p(south), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23887, ps{p(proj_utm), p(zone,47), p(south), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23888, ps{p(proj_utm), p(zone,48), p(south), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23889, ps{p(proj_utm), p(zone,49), p(south), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23890, ps{p(proj_utm), p(zone,50), p(south), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23891, ps{p(proj_utm), p(zone,51), p(south), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23892, ps{p(proj_utm), p(zone,52), p(south), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23893, ps{p(proj_utm), p(zone,53), p(south), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23894, ps{p(proj_utm), p(zone,54), p(south), p(a,6378160), p(b,6356774.50408554), p(units_m), p(no_defs)}),
            ce(23946, ps{p(proj_utm), p(zone,46), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}, towgs84{217,823,299,0,0,0,0}),
            ce(23947, ps{p(proj_utm), p(zone,47), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}, towgs84{217,823,299,0,0,0,0}),
            ce(23948, ps{p(proj_utm), p(zone,48), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}, towgs84{217,823,299,0,0,0,0}),
            ce(24047, ps{p(proj_utm), p(zone,47), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}),
            ce(24048, ps{p(proj_utm), p(zone,48), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}),
            ce(24100, ps{p(proj_lcc), p(lat_1,18), p(lat_0,18), p(lon_0,-77), p(k_0,1), p(x_0,167638.49597), p(y_0,121918.90616), p(a,6378249.144808011), p(b,6356514.966204134), p(to_meter,0.3047972654), p(no_defs)}),
            ce(24200, ps{p(proj_lcc), p(lat_1,18), p(lat_0,18), p(lon_0,-77), p(k_0,1), p(x_0,250000), p(y_0,150000), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(24305, ps{p(proj_utm), p(zone,45), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}),
            ce(24306, ps{p(proj_utm), p(zone,46), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}),
            ce(24311, ps{p(proj_utm), p(zone,41), p(a,6377301.243), p(b,6356100.230165384), p(units_m), p(no_defs)}),
            ce(24312, ps{p(proj_utm), p(zone,42), p(a,6377301.243), p(b,6356100.230165384), p(units_m), p(no_defs)}),
            ce(24313, ps{p(proj_utm), p(zone,43), p(a,6377301.243), p(b,6356100.230165384), p(units_m), p(no_defs)}),
            ce(24342, ps{p(proj_utm), p(zone,42), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24343, ps{p(proj_utm), p(zone,43), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24344, ps{p(proj_utm), p(zone,44), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24345, ps{p(proj_utm), p(zone,45), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24346, ps{p(proj_utm), p(zone,46), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24347, ps{p(proj_utm), p(zone,47), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24370, ps{p(proj_lcc), p(lat_1,39.5), p(lat_0,39.5), p(lon_0,68), p(k_0,0.99846154), p(x_0,2153865.73916853), p(y_0,2368292.194628102), p(a,6377299.36559538), p(b,6356098.359005157), p(to_meter,0.9143985307444408), p(no_defs)}),
            ce(24371, ps{p(proj_lcc), p(lat_1,32.5), p(lat_0,32.5), p(lon_0,68), p(k_0,0.99878641), p(x_0,2743195.592233322), p(y_0,914398.5307444407), p(a,6377299.36559538), p(b,6356098.359005157), p(to_meter,0.9143985307444408), p(no_defs)}),
            ce(24372, ps{p(proj_lcc), p(lat_1,26), p(lat_0,26), p(lon_0,74), p(k_0,0.99878641), p(x_0,2743195.592233322), p(y_0,914398.5307444407), p(a,6377299.36559538), p(b,6356098.359005157), p(to_meter,0.9143985307444408), p(no_defs)}),
            ce(24373, ps{p(proj_lcc), p(lat_1,19), p(lat_0,19), p(lon_0,80), p(k_0,0.99878641), p(x_0,2743195.592233322), p(y_0,914398.5307444407), p(a,6377299.36559538), p(b,6356098.359005157), p(to_meter,0.9143985307444408), p(no_defs)}),
            ce(24374, ps{p(proj_lcc), p(lat_1,12), p(lat_0,12), p(lon_0,80), p(k_0,0.99878641), p(x_0,2743195.592233322), p(y_0,914398.5307444407), p(a,6377299.36559538), p(b,6356098.359005157), p(to_meter,0.9143985307444408), p(no_defs)}),
            ce(24375, ps{p(proj_lcc), p(lat_1,26), p(lat_0,26), p(lon_0,90), p(k_0,0.99878641), p(x_0,2743185.69), p(y_0,914395.23), p(a,6377276.345), p(b,6356075.41314024), p(units_m), p(no_defs)}),
            ce(24376, ps{p(proj_lcc), p(lat_1,32.5), p(lat_0,32.5), p(lon_0,68), p(k_0,0.99878641), p(x_0,2743196.4), p(y_0,914398.8), p(a,6377301.243), p(b,6356100.230165384), p(units_m), p(no_defs)}),
            ce(24377, ps{p(proj_lcc), p(lat_1,26), p(lat_0,26), p(lon_0,74), p(k_0,0.99878641), p(x_0,2743196.4), p(y_0,914398.8), p(a,6377301.243), p(b,6356100.230165384), p(units_m), p(no_defs)}),
            ce(24378, ps{p(proj_lcc), p(lat_1,32.5), p(lat_0,32.5), p(lon_0,68), p(k_0,0.99878641), p(x_0,2743195.5), p(y_0,914398.5), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24379, ps{p(proj_lcc), p(lat_1,26), p(lat_0,26), p(lon_0,74), p(k_0,0.99878641), p(x_0,2743195.5), p(y_0,914398.5), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24380, ps{p(proj_lcc), p(lat_1,26), p(lat_0,26), p(lon_0,90), p(k_0,0.99878641), p(x_0,2743195.5), p(y_0,914398.5), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24381, ps{p(proj_lcc), p(lat_1,19), p(lat_0,19), p(lon_0,80), p(k_0,0.99878641), p(x_0,2743195.5), p(y_0,914398.5), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24382, ps{p(proj_lcc), p(lat_1,26), p(lat_0,26), p(lon_0,90), p(k_0,0.99878641), p(x_0,2743195.592233322), p(y_0,914398.5307444407), p(a,6377299.36559538), p(b,6356098.359005157), p(to_meter,0.9143985307444408), p(no_defs)}),
            ce(24383, ps{p(proj_lcc), p(lat_1,12), p(lat_0,12), p(lon_0,80), p(k_0,0.99878641), p(x_0,2743195.5), p(y_0,914398.5), p(a,6377299.151), p(b,6356098.145120132), p(units_m), p(no_defs)}, towgs84{295,736,257,0,0,0,0}),
            ce(24500, ps{p(proj_cass), p(lat_0,1.287646666666667), p(lon_0,103.8530022222222), p(x_0,30000), p(y_0,30000), p(a,6377304.063), p(b,6356103.038993155), p(units_m), p(no_defs)}, towgs84{-11,851,5,0,0,0,0}),
            ce(24547, ps{p(proj_utm), p(zone,47), p(a,6377304.063), p(b,6356103.038993155), p(units_m), p(no_defs)}, towgs84{-11,851,5,0,0,0,0}),
            ce(24548, ps{p(proj_utm), p(zone,48), p(a,6377304.063), p(b,6356103.038993155), p(units_m), p(no_defs)}, towgs84{-11,851,5,0,0,0,0}),
            ce(24571, ps{p(proj_omerc), p(lat_0,4), p(lonc,102.25), p(alpha,323.0257905), p(k,0.99984), p(x_0,804671.2997750348), p(y_0,0), p(a,6377304.063), p(b,6356103.038993155), p(to_meter,20.11678249437587), p(no_defs)}, towgs84{-11,851,5,0,0,0,0}),
            ce(24600, ps{p(proj_lcc), p(lat_1,32.5), p(lat_0,32.5), p(lon_0,45), p(k_0,0.9987864078000001), p(x_0,1500000), p(y_0,1166200), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-294.7,-200.1,525.5,0,0,0,0}),
            ce(24718, ps{p(proj_utm), p(zone,18), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-273.5,110.6,-357.9,0,0,0,0}),
            ce(24719, ps{p(proj_utm), p(zone,19), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-273.5,110.6,-357.9,0,0,0,0}),
            ce(24720, ps{p(proj_utm), p(zone,20), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-273.5,110.6,-357.9,0,0,0,0}),
            ce(24817, ps{p(proj_utm), p(zone,17), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24818, ps{p(proj_utm), p(zone,18), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24819, ps{p(proj_utm), p(zone,19), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24820, ps{p(proj_utm), p(zone,20), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24821, ps{p(proj_utm), p(zone,21), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24877, ps{p(proj_utm), p(zone,17), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24878, ps{p(proj_utm), p(zone,18), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24879, ps{p(proj_utm), p(zone,19), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24880, ps{p(proj_utm), p(zone,20), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24881, ps{p(proj_utm), p(zone,21), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24882, ps{p(proj_utm), p(zone,22), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24891, ps{p(proj_tmerc), p(lat_0,-6), p(lon_0,-80.5), p(k,0.99983008), p(x_0,222000), p(y_0,1426834.743), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24892, ps{p(proj_tmerc), p(lat_0,-9.5), p(lon_0,-76), p(k,0.99932994), p(x_0,720000), p(y_0,1039979.159), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(24893, ps{p(proj_tmerc), p(lat_0,-9.5), p(lon_0,-70.5), p(k,0.99952992), p(x_0,1324000), p(y_0,1040084.558), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(25000, ps{p(proj_tmerc), p(lat_0,4.666666666666667), p(lon_0,-1), p(k,0.99975), p(x_0,274319.51), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}, towgs84{-130,29,364,0,0,0,0}),
            ce(25231, ps{p(proj_utm), p(zone,31), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(25391, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(25392, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,119), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(25393, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,121), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(25394, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(25395, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,125), p(k,0.99995), p(x_0,500000), p(y_0,0), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(25700, ps{p(proj_merc), p(lon_0,110), p(k,0.997), p(x_0,3900000), p(y_0,900000), p(ellps_bessel), p(pm_jakarta), p(units_m), p(no_defs)}, towgs84{-587.8,519.75,145.76,0,0,0,0}),
            ce(25828, ps{p(proj_utm), p(zone,28), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25829, ps{p(proj_utm), p(zone,29), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25830, ps{p(proj_utm), p(zone,30), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25831, ps{p(proj_utm), p(zone,31), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25832, ps{p(proj_utm), p(zone,32), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25833, ps{p(proj_utm), p(zone,33), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25834, ps{p(proj_utm), p(zone,34), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25835, ps{p(proj_utm), p(zone,35), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25836, ps{p(proj_utm), p(zone,36), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25837, ps{p(proj_utm), p(zone,37), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25838, ps{p(proj_utm), p(zone,38), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25884, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(25932, ps{p(proj_utm), p(zone,32), p(south), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(26191, ps{p(proj_lcc), p(lat_1,33.3), p(lat_0,33.3), p(lon_0,-5.4), p(k_0,0.999625769), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{31,146,47,0,0,0,0}),
            ce(26192, ps{p(proj_lcc), p(lat_1,29.7), p(lat_0,29.7), p(lon_0,-5.4), p(k_0,0.9996155960000001), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{31,146,47,0,0,0,0}),
            ce(26193, ps{p(proj_lcc), p(lat_1,26.1), p(lat_0,26.1), p(lon_0,-5.4), p(k_0,0.9996), p(x_0,1200000), p(y_0,400000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{31,146,47,0,0,0,0}),
            ce(26194, ps{p(proj_lcc), p(lat_1,26.1), p(lat_0,26.1), p(lon_0,-5.4), p(k_0,0.999616304), p(x_0,1200000), p(y_0,400000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{31,146,47,0,0,0,0}),
            ce(26195, ps{p(proj_lcc), p(lat_1,22.5), p(lat_0,22.5), p(lon_0,-5.4), p(k_0,0.999616437), p(x_0,1500000), p(y_0,400000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{31,146,47,0,0,0,0}),
            ce(26237, ps{p(proj_utm), p(zone,37), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{639,405,60,0,0,0,0}),
            ce(26331, ps{p(proj_utm), p(zone,31), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(26332, ps{p(proj_utm), p(zone,32), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(26391, ps{p(proj_tmerc), p(lat_0,4), p(lon_0,4.5), p(k,0.99975), p(x_0,230738.26), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(26392, ps{p(proj_tmerc), p(lat_0,4), p(lon_0,8.5), p(k,0.99975), p(x_0,670553.98), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(26393, ps{p(proj_tmerc), p(lat_0,4), p(lon_0,12.5), p(k,0.99975), p(x_0,1110369.7), p(y_0,0), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(26432, ps{p(proj_utm), p(zone,32), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-252.95,-4.11,-96.38,0,0,0,0}),
            ce(26591, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-3.45233333333333), p(k,0.9996), p(x_0,1500000), p(y_0,0), p(ellps_intl), p(pm_rome), p(units_m), p(no_defs)}),
            ce(26592, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,2.54766666666666), p(k,0.9996), p(x_0,2520000), p(y_0,0), p(ellps_intl), p(pm_rome), p(units_m), p(no_defs)}),
            ce(26632, ps{p(proj_utm), p(zone,32), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(26692, ps{p(proj_utm), p(zone,32), p(south), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(26701, ps{p(proj_utm), p(zone,1), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26702, ps{p(proj_utm), p(zone,2), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26703, ps{p(proj_utm), p(zone,3), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26704, ps{p(proj_utm), p(zone,4), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26705, ps{p(proj_utm), p(zone,5), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26706, ps{p(proj_utm), p(zone,6), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26707, ps{p(proj_utm), p(zone,7), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26708, ps{p(proj_utm), p(zone,8), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26709, ps{p(proj_utm), p(zone,9), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26710, ps{p(proj_utm), p(zone,10), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26711, ps{p(proj_utm), p(zone,11), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26712, ps{p(proj_utm), p(zone,12), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26713, ps{p(proj_utm), p(zone,13), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26714, ps{p(proj_utm), p(zone,14), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26715, ps{p(proj_utm), p(zone,15), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26716, ps{p(proj_utm), p(zone,16), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26717, ps{p(proj_utm), p(zone,17), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26718, ps{p(proj_utm), p(zone,18), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26719, ps{p(proj_utm), p(zone,19), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26720, ps{p(proj_utm), p(zone,20), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26721, ps{p(proj_utm), p(zone,21), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26722, ps{p(proj_utm), p(zone,22), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(26729, ps{p(proj_tmerc), p(lat_0,30.5), p(lon_0,-85.83333333333333), p(k,0.99996), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26730, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-87.5), p(k,0.999933333), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26731, ps{p(proj_omerc), p(lat_0,57), p(lonc,-133.6666666666667), p(alpha,323.1301023611111), p(k,0.9999), p(x_0,5000000.001016002), p(y_0,-5000000.001016002), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26732, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-142), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26733, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-146), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26734, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-150), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26735, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-154), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26736, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-158), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26737, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-162), p(k,0.9999), p(x_0,213360.4267208534), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26738, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-166), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26739, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-170), p(k,0.9999), p(x_0,182880.3657607315), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26740, ps{p(proj_lcc), p(lat_1,53.83333333333334), p(lat_2,51.83333333333334), p(lat_0,51), p(lon_0,-176), p(x_0,914401.8288036576), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26741, ps{p(proj_lcc), p(lat_1,41.66666666666666), p(lat_2,40), p(lat_0,39.33333333333334), p(lon_0,-122), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26742, ps{p(proj_lcc), p(lat_1,39.83333333333334), p(lat_2,38.33333333333334), p(lat_0,37.66666666666666), p(lon_0,-122), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26743, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.06666666666667), p(lat_0,36.5), p(lon_0,-120.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26744, ps{p(proj_lcc), p(lat_1,37.25), p(lat_2,36), p(lat_0,35.33333333333334), p(lon_0,-119), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26745, ps{p(proj_lcc), p(lat_1,35.46666666666667), p(lat_2,34.03333333333333), p(lat_0,33.5), p(lon_0,-118), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26746, ps{p(proj_lcc), p(lat_1,33.88333333333333), p(lat_2,32.78333333333333), p(lat_0,32.16666666666666), p(lon_0,-116.25), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26747, ps{p(proj_lcc), p(lat_1,34.41666666666666), p(lat_2,33.86666666666667), p(lat_0,34.13333333333333), p(lon_0,-118.3333333333333), p(x_0,1276106.450596901), p(y_0,127079.524511049), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26748, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-110.1666666666667), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26749, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-111.9166666666667), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26750, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-113.75), p(k,0.999933333), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26751, ps{p(proj_lcc), p(lat_1,36.23333333333333), p(lat_2,34.93333333333333), p(lat_0,34.33333333333334), p(lon_0,-92), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26752, ps{p(proj_lcc), p(lat_1,34.76666666666667), p(lat_2,33.3), p(lat_0,32.66666666666666), p(lon_0,-92), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26753, ps{p(proj_lcc), p(lat_1,39.71666666666667), p(lat_2,40.78333333333333), p(lat_0,39.33333333333334), p(lon_0,-105.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26754, ps{p(proj_lcc), p(lat_1,39.75), p(lat_2,38.45), p(lat_0,37.83333333333334), p(lon_0,-105.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26755, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.23333333333333), p(lat_0,36.66666666666666), p(lon_0,-105.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26756, ps{p(proj_lcc), p(lat_1,41.86666666666667), p(lat_2,41.2), p(lat_0,40.83333333333334), p(lon_0,-72.75), p(x_0,182880.3657607315), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26757, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,-75.41666666666667), p(k,0.999995), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26758, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-81), p(k,0.999941177), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26759, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-82), p(k,0.999941177), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26760, ps{p(proj_lcc), p(lat_1,30.75), p(lat_2,29.58333333333333), p(lat_0,29), p(lon_0,-84.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26766, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-82.16666666666667), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26767, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-84.16666666666667), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26768, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-112.1666666666667), p(k,0.9999473679999999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26769, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-114), p(k,0.9999473679999999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26770, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-115.75), p(k,0.999933333), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26771, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-88.33333333333333), p(k,0.9999749999999999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26772, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-90.16666666666667), p(k,0.999941177), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26773, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.999966667), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26774, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.999966667), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26775, ps{p(proj_lcc), p(lat_1,43.26666666666667), p(lat_2,42.06666666666667), p(lat_0,41.5), p(lon_0,-93.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26776, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.61666666666667), p(lat_0,40), p(lon_0,-93.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26777, ps{p(proj_lcc), p(lat_1,39.78333333333333), p(lat_2,38.71666666666667), p(lat_0,38.33333333333334), p(lon_0,-98), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26778, ps{p(proj_lcc), p(lat_1,38.56666666666667), p(lat_2,37.26666666666667), p(lat_0,36.66666666666666), p(lon_0,-98.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26779, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,38.96666666666667), p(lat_0,37.5), p(lon_0,-84.25), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26780, ps{p(proj_lcc), p(lat_1,36.73333333333333), p(lat_2,37.93333333333333), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26781, ps{p(proj_lcc), p(lat_1,31.16666666666667), p(lat_2,32.66666666666666), p(lat_0,30.66666666666667), p(lon_0,-92.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26782, ps{p(proj_lcc), p(lat_1,29.3), p(lat_2,30.7), p(lat_0,28.66666666666667), p(lon_0,-91.33333333333333), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26783, ps{p(proj_tmerc), p(lat_0,43.83333333333334), p(lon_0,-68.5), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26784, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.999966667), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26785, ps{p(proj_lcc), p(lat_1,38.3), p(lat_2,39.45), p(lat_0,37.83333333333334), p(lon_0,-77), p(x_0,243840.4876809754), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26786, ps{p(proj_lcc), p(lat_1,41.71666666666667), p(lat_2,42.68333333333333), p(lat_0,41), p(lon_0,-71.5), p(x_0,182880.3657607315), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26787, ps{p(proj_lcc), p(lat_1,41.28333333333333), p(lat_2,41.48333333333333), p(lat_0,41), p(lon_0,-70.5), p(x_0,60960.12192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26791, ps{p(proj_lcc), p(lat_1,47.03333333333333), p(lat_2,48.63333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26792, ps{p(proj_lcc), p(lat_1,45.61666666666667), p(lat_2,47.05), p(lat_0,45), p(lon_0,-94.25), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26793, ps{p(proj_lcc), p(lat_1,43.78333333333333), p(lat_2,45.21666666666667), p(lat_0,43), p(lon_0,-94), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26794, ps{p(proj_tmerc), p(lat_0,29.66666666666667), p(lon_0,-88.83333333333333), p(k,0.99996), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26795, ps{p(proj_tmerc), p(lat_0,30.5), p(lon_0,-90.33333333333333), p(k,0.999941177), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26796, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-90.5), p(k,0.999933333), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26797, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-92.5), p(k,0.999933333), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26798, ps{p(proj_tmerc), p(lat_0,36.16666666666666), p(lon_0,-94.5), p(k,0.999941177), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26799, ps{p(proj_lcc), p(lat_1,34.41666666666666), p(lat_2,33.86666666666667), p(lat_0,34.13333333333333), p(lon_0,-118.3333333333333), p(x_0,1276106.450596901), p(y_0,1268253.006858014), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26801, ps{p(proj_tmerc), p(lat_0,41.5), p(lon_0,-83.66666666666667), p(k,0.999942857), p(x_0,152400.3048006096), p(y_0,0), p(a,6378450.047548896), p(b,6356826.621488444), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26802, ps{p(proj_tmerc), p(lat_0,41.5), p(lon_0,-85.75), p(k,0.999909091), p(x_0,152400.3048006096), p(y_0,0), p(a,6378450.047548896), p(b,6356826.621488444), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26803, ps{p(proj_tmerc), p(lat_0,41.5), p(lon_0,-88.75), p(k,0.999909091), p(x_0,152400.3048006096), p(y_0,0), p(a,6378450.047548896), p(b,6356826.621488444), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26811, ps{p(proj_lcc), p(lat_1,45.48333333333333), p(lat_2,47.08333333333334), p(lat_0,44.78333333333333), p(lon_0,-87), p(x_0,609601.2192024384), p(y_0,0), p(a,6378450.047548896), p(b,6356826.621488444), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26812, ps{p(proj_lcc), p(lat_1,44.18333333333333), p(lat_2,45.7), p(lat_0,43.31666666666667), p(lon_0,-84.33333333333333), p(x_0,609601.2192024384), p(y_0,0), p(a,6378450.047548896), p(b,6356826.621488444), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26813, ps{p(proj_lcc), p(lat_1,42.1), p(lat_2,43.66666666666666), p(lat_0,41.5), p(lon_0,-84.33333333333333), p(x_0,609601.2192024384), p(y_0,0), p(a,6378450.047548896), p(b,6356826.621488444), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26814, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26815, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.999966667), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26819, ps{p(proj_lcc), p(lat_1,48.63333333333333), p(lat_2,47.03333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,800000.0000101601), p(y_0,99999.99998984), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26820, ps{p(proj_lcc), p(lat_1,47.05), p(lat_2,45.61666666666667), p(lat_0,45), p(lon_0,-94.25), p(x_0,800000.0000101601), p(y_0,99999.99998984), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26821, ps{p(proj_lcc), p(lat_1,45.21666666666667), p(lat_2,43.78333333333333), p(lat_0,43), p(lon_0,-94), p(x_0,800000.0000101601), p(y_0,99999.99998984), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26822, ps{p(proj_lcc), p(lat_1,43), p(lat_2,40), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000.0000101601), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26823, ps{p(proj_lcc), p(lat_1,40.25), p(lat_2,39), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,1968500), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26824, ps{p(proj_lcc), p(lat_1,38.88333333333333), p(lat_2,37.48333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,1968500), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26825, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26826, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.999966667), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26830, ps{p(proj_lcc), p(lat_1,48.63333333333333), p(lat_2,47.03333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,800000.0000101601), p(y_0,99999.99998984), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26831, ps{p(proj_lcc), p(lat_1,47.05), p(lat_2,45.61666666666667), p(lat_0,45), p(lon_0,-94.25), p(x_0,800000.0000101601), p(y_0,99999.99998984), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26832, ps{p(proj_lcc), p(lat_1,45.21666666666667), p(lat_2,43.78333333333333), p(lat_0,43), p(lon_0,-94), p(x_0,800000.0000101601), p(y_0,99999.99998984), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26833, ps{p(proj_lcc), p(lat_1,43), p(lat_2,40), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000.0000101601), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26834, ps{p(proj_lcc), p(lat_1,40.25), p(lat_2,39), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,1968500), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26835, ps{p(proj_lcc), p(lat_1,38.88333333333333), p(lat_2,37.48333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,1968500), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26836, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26837, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.999966667), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26841, ps{p(proj_lcc), p(lat_1,48.63333333333333), p(lat_2,47.03333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,800000.0000101601), p(y_0,99999.99998984), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26842, ps{p(proj_lcc), p(lat_1,47.05), p(lat_2,45.61666666666667), p(lat_0,45), p(lon_0,-94.25), p(x_0,800000.0000101601), p(y_0,99999.99998984), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26843, ps{p(proj_lcc), p(lat_1,45.21666666666667), p(lat_2,43.78333333333333), p(lat_0,43), p(lon_0,-94), p(x_0,800000.0000101601), p(y_0,99999.99998984), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26844, ps{p(proj_lcc), p(lat_1,43), p(lat_2,40), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000.0000101601), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26845, ps{p(proj_lcc), p(lat_1,40.25), p(lat_2,39), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,1968500), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26846, ps{p(proj_lcc), p(lat_1,38.88333333333333), p(lat_2,37.48333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,1968500), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26847, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26848, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.999966667), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26849, ps{p(proj_lcc), p(lat_1,48.63333333333333), p(lat_2,47.03333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26850, ps{p(proj_lcc), p(lat_1,47.05), p(lat_2,45.61666666666667), p(lat_0,45), p(lon_0,-94.25), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26851, ps{p(proj_lcc), p(lat_1,45.21666666666667), p(lat_2,43.78333333333333), p(lat_0,43), p(lon_0,-94), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26852, ps{p(proj_lcc), p(lat_1,43), p(lat_2,40), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000.00001016), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26853, ps{p(proj_lcc), p(lat_1,40.25), p(lat_2,39), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26854, ps{p(proj_lcc), p(lat_1,38.88333333333333), p(lat_2,37.48333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26855, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26856, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.999966667), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26857, ps{p(proj_lcc), p(lat_1,48.63333333333333), p(lat_2,47.03333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26858, ps{p(proj_lcc), p(lat_1,47.05), p(lat_2,45.61666666666667), p(lat_0,45), p(lon_0,-94.25), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26859, ps{p(proj_lcc), p(lat_1,45.21666666666667), p(lat_2,43.78333333333333), p(lat_0,43), p(lon_0,-94), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26860, ps{p(proj_lcc), p(lat_1,43), p(lat_2,40), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000.00001016), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26861, ps{p(proj_lcc), p(lat_1,40.25), p(lat_2,39), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26862, ps{p(proj_lcc), p(lat_1,38.88333333333333), p(lat_2,37.48333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(26863, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000.0000000001), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26864, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.999966667), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26865, ps{p(proj_lcc), p(lat_1,48.63333333333333), p(lat_2,47.03333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26866, ps{p(proj_lcc), p(lat_1,47.05), p(lat_2,45.61666666666667), p(lat_0,45), p(lon_0,-94.25), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26867, ps{p(proj_lcc), p(lat_1,45.21666666666667), p(lat_2,43.78333333333333), p(lat_0,43), p(lon_0,-94), p(x_0,800000.0000101599), p(y_0,99999.99998983997), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26868, ps{p(proj_lcc), p(lat_1,43), p(lat_2,40), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000.00001016), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26869, ps{p(proj_lcc), p(lat_1,40.25), p(lat_2,39), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26870, ps{p(proj_lcc), p(lat_1,38.88333333333333), p(lat_2,37.48333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(to_meter,0.3048006096012192), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(26891, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-82.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26892, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-81), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26893, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-84), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26894, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-87), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26895, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-90), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26896, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-93), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26897, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-96), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26898, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-53), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26899, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-56), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(26901, ps{p(proj_utm), p(zone,1), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26902, ps{p(proj_utm), p(zone,2), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26903, ps{p(proj_utm), p(zone,3), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26904, ps{p(proj_utm), p(zone,4), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26905, ps{p(proj_utm), p(zone,5), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26906, ps{p(proj_utm), p(zone,6), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26907, ps{p(proj_utm), p(zone,7), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26908, ps{p(proj_utm), p(zone,8), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26909, ps{p(proj_utm), p(zone,9), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26910, ps{p(proj_utm), p(zone,10), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26911, ps{p(proj_utm), p(zone,11), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26912, ps{p(proj_utm), p(zone,12), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26913, ps{p(proj_utm), p(zone,13), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26914, ps{p(proj_utm), p(zone,14), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26915, ps{p(proj_utm), p(zone,15), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26916, ps{p(proj_utm), p(zone,16), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26917, ps{p(proj_utm), p(zone,17), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26918, ps{p(proj_utm), p(zone,18), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26919, ps{p(proj_utm), p(zone,19), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26920, ps{p(proj_utm), p(zone,20), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26921, ps{p(proj_utm), p(zone,21), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26922, ps{p(proj_utm), p(zone,22), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26923, ps{p(proj_utm), p(zone,23), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26929, ps{p(proj_tmerc), p(lat_0,30.5), p(lon_0,-85.83333333333333), p(k,0.99996), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26930, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-87.5), p(k,0.999933333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26931, ps{p(proj_omerc), p(lat_0,57), p(lonc,-133.6666666666667), p(alpha,323.1301023611111), p(k,0.9999), p(x_0,5000000), p(y_0,-5000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26932, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-142), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26933, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-146), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26934, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-150), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26935, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-154), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26936, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-158), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26937, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-162), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26938, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-166), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26939, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-170), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26940, ps{p(proj_lcc), p(lat_1,53.83333333333334), p(lat_2,51.83333333333334), p(lat_0,51), p(lon_0,-176), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26941, ps{p(proj_lcc), p(lat_1,41.66666666666666), p(lat_2,40), p(lat_0,39.33333333333334), p(lon_0,-122), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26942, ps{p(proj_lcc), p(lat_1,39.83333333333334), p(lat_2,38.33333333333334), p(lat_0,37.66666666666666), p(lon_0,-122), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26943, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.06666666666667), p(lat_0,36.5), p(lon_0,-120.5), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26944, ps{p(proj_lcc), p(lat_1,37.25), p(lat_2,36), p(lat_0,35.33333333333334), p(lon_0,-119), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26945, ps{p(proj_lcc), p(lat_1,35.46666666666667), p(lat_2,34.03333333333333), p(lat_0,33.5), p(lon_0,-118), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26946, ps{p(proj_lcc), p(lat_1,33.88333333333333), p(lat_2,32.78333333333333), p(lat_0,32.16666666666666), p(lon_0,-116.25), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26948, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-110.1666666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26949, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-111.9166666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26950, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-113.75), p(k,0.999933333), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26951, ps{p(proj_lcc), p(lat_1,36.23333333333333), p(lat_2,34.93333333333333), p(lat_0,34.33333333333334), p(lon_0,-92), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26952, ps{p(proj_lcc), p(lat_1,34.76666666666667), p(lat_2,33.3), p(lat_0,32.66666666666666), p(lon_0,-92), p(x_0,400000), p(y_0,400000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26953, ps{p(proj_lcc), p(lat_1,40.78333333333333), p(lat_2,39.71666666666667), p(lat_0,39.33333333333334), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26954, ps{p(proj_lcc), p(lat_1,39.75), p(lat_2,38.45), p(lat_0,37.83333333333334), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26955, ps{p(proj_lcc), p(lat_1,38.43333333333333), p(lat_2,37.23333333333333), p(lat_0,36.66666666666666), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26956, ps{p(proj_lcc), p(lat_1,41.86666666666667), p(lat_2,41.2), p(lat_0,40.83333333333334), p(lon_0,-72.75), p(x_0,304800.6096), p(y_0,152400.3048), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26957, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,-75.41666666666667), p(k,0.999995), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26958, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-81), p(k,0.999941177), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26959, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-82), p(k,0.999941177), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26960, ps{p(proj_lcc), p(lat_1,30.75), p(lat_2,29.58333333333333), p(lat_0,29), p(lon_0,-84.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26961, ps{p(proj_tmerc), p(lat_0,18.83333333333333), p(lon_0,-155.5), p(k,0.999966667), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26962, ps{p(proj_tmerc), p(lat_0,20.33333333333333), p(lon_0,-156.6666666666667), p(k,0.999966667), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26963, ps{p(proj_tmerc), p(lat_0,21.16666666666667), p(lon_0,-158), p(k,0.99999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26964, ps{p(proj_tmerc), p(lat_0,21.83333333333333), p(lon_0,-159.5), p(k,0.99999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26965, ps{p(proj_tmerc), p(lat_0,21.66666666666667), p(lon_0,-160.1666666666667), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26966, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-82.16666666666667), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26967, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-84.16666666666667), p(k,0.9999), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26968, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-112.1666666666667), p(k,0.9999473679999999), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26969, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-114), p(k,0.9999473679999999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26970, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-115.75), p(k,0.999933333), p(x_0,800000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26971, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-88.33333333333333), p(k,0.9999749999999999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26972, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-90.16666666666667), p(k,0.999941177), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26973, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.999966667), p(x_0,100000), p(y_0,250000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26974, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.999966667), p(x_0,900000), p(y_0,250000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26975, ps{p(proj_lcc), p(lat_1,43.26666666666667), p(lat_2,42.06666666666667), p(lat_0,41.5), p(lon_0,-93.5), p(x_0,1500000), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26976, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.61666666666667), p(lat_0,40), p(lon_0,-93.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26977, ps{p(proj_lcc), p(lat_1,39.78333333333333), p(lat_2,38.71666666666667), p(lat_0,38.33333333333334), p(lon_0,-98), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26978, ps{p(proj_lcc), p(lat_1,38.56666666666667), p(lat_2,37.26666666666667), p(lat_0,36.66666666666666), p(lon_0,-98.5), p(x_0,400000), p(y_0,400000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26979, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,37.96666666666667), p(lat_0,37.5), p(lon_0,-84.25), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26980, ps{p(proj_lcc), p(lat_1,37.93333333333333), p(lat_2,36.73333333333333), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,500000), p(y_0,500000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26981, ps{p(proj_lcc), p(lat_1,32.66666666666666), p(lat_2,31.16666666666667), p(lat_0,30.5), p(lon_0,-92.5), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26982, ps{p(proj_lcc), p(lat_1,30.7), p(lat_2,29.3), p(lat_0,28.5), p(lon_0,-91.33333333333333), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26983, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26984, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.999966667), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26985, ps{p(proj_lcc), p(lat_1,39.45), p(lat_2,38.3), p(lat_0,37.66666666666666), p(lon_0,-77), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26986, ps{p(proj_lcc), p(lat_1,42.68333333333333), p(lat_2,41.71666666666667), p(lat_0,41), p(lon_0,-71.5), p(x_0,200000), p(y_0,750000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26987, ps{p(proj_lcc), p(lat_1,41.48333333333333), p(lat_2,41.28333333333333), p(lat_0,41), p(lon_0,-70.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26988, ps{p(proj_lcc), p(lat_1,47.08333333333334), p(lat_2,45.48333333333333), p(lat_0,44.78333333333333), p(lon_0,-87), p(x_0,8000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26989, ps{p(proj_lcc), p(lat_1,45.7), p(lat_2,44.18333333333333), p(lat_0,43.31666666666667), p(lon_0,-84.36666666666666), p(x_0,6000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26990, ps{p(proj_lcc), p(lat_1,43.66666666666666), p(lat_2,42.1), p(lat_0,41.5), p(lon_0,-84.36666666666666), p(x_0,4000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26991, ps{p(proj_lcc), p(lat_1,48.63333333333333), p(lat_2,47.03333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26992, ps{p(proj_lcc), p(lat_1,47.05), p(lat_2,45.61666666666667), p(lat_0,45), p(lon_0,-94.25), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26993, ps{p(proj_lcc), p(lat_1,45.21666666666667), p(lat_2,43.78333333333333), p(lat_0,43), p(lon_0,-94), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26994, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-88.83333333333333), p(k,0.99995), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26995, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-90.33333333333333), p(k,0.99995), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26996, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-90.5), p(k,0.999933333), p(x_0,250000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26997, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-92.5), p(k,0.999933333), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(26998, ps{p(proj_tmerc), p(lat_0,36.16666666666666), p(lon_0,-94.5), p(k,0.999941177), p(x_0,850000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(27037, ps{p(proj_utm), p(zone,37), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(27038, ps{p(proj_utm), p(zone,38), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(27039, ps{p(proj_utm), p(zone,39), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(27040, ps{p(proj_utm), p(zone,40), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(27120, ps{p(proj_utm), p(zone,20), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(27200, ps{p(proj_nzmg), p(lat_0,-41), p(lon_0,173), p(x_0,2510000), p(y_0,6023150), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27205, ps{p(proj_tmerc), p(lat_0,-36.87986527777778), p(lon_0,174.7643393611111), p(k,0.9999), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27206, ps{p(proj_tmerc), p(lat_0,-37.76124980555556), p(lon_0,176.46619725), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27207, ps{p(proj_tmerc), p(lat_0,-38.62470277777778), p(lon_0,177.8856362777778), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27208, ps{p(proj_tmerc), p(lat_0,-39.65092930555556), p(lon_0,176.6736805277778), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27209, ps{p(proj_tmerc), p(lat_0,-39.13575830555556), p(lon_0,174.22801175), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27210, ps{p(proj_tmerc), p(lat_0,-39.51247038888889), p(lon_0,175.6400368055556), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27211, ps{p(proj_tmerc), p(lat_0,-40.24194713888889), p(lon_0,175.4880996111111), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27212, ps{p(proj_tmerc), p(lat_0,-40.92553263888889), p(lon_0,175.6473496666667), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27213, ps{p(proj_tmerc), p(lat_0,-41.30131963888888), p(lon_0,174.7766231111111), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27214, ps{p(proj_tmerc), p(lat_0,-40.71475905555556), p(lon_0,172.6720465), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27215, ps{p(proj_tmerc), p(lat_0,-41.27454472222222), p(lon_0,173.2993168055555), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27216, ps{p(proj_tmerc), p(lat_0,-41.28991152777778), p(lon_0,172.1090281944444), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27217, ps{p(proj_tmerc), p(lat_0,-41.81080286111111), p(lon_0,171.5812600555556), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27218, ps{p(proj_tmerc), p(lat_0,-42.33369427777778), p(lon_0,171.5497713055556), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27219, ps{p(proj_tmerc), p(lat_0,-42.68911658333333), p(lon_0,173.0101333888889), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27220, ps{p(proj_tmerc), p(lat_0,-41.54448666666666), p(lon_0,173.8020741111111), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27221, ps{p(proj_tmerc), p(lat_0,-42.88632236111111), p(lon_0,170.9799935), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27222, ps{p(proj_tmerc), p(lat_0,-43.11012813888889), p(lon_0,170.2609258333333), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27223, ps{p(proj_tmerc), p(lat_0,-43.97780288888889), p(lon_0,168.606267), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27224, ps{p(proj_tmerc), p(lat_0,-43.59063758333333), p(lon_0,172.7271935833333), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27225, ps{p(proj_tmerc), p(lat_0,-43.74871155555556), p(lon_0,171.3607484722222), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27226, ps{p(proj_tmerc), p(lat_0,-44.40222036111111), p(lon_0,171.0572508333333), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27227, ps{p(proj_tmerc), p(lat_0,-44.73526797222222), p(lon_0,169.4677550833333), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27228, ps{p(proj_tmerc), p(lat_0,-45.13290258333333), p(lon_0,168.3986411944444), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27229, ps{p(proj_tmerc), p(lat_0,-45.56372616666666), p(lon_0,167.7388617777778), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27230, ps{p(proj_tmerc), p(lat_0,-45.81619661111111), p(lon_0,170.6285951666667), p(k,1), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27231, ps{p(proj_tmerc), p(lat_0,-45.86151336111111), p(lon_0,170.2825891111111), p(k,0.99996), p(x_0,300000), p(y_0,700000), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27232, ps{p(proj_tmerc), p(lat_0,-46.60000961111111), p(lon_0,168.342872), p(k,1), p(x_0,300002.66), p(y_0,699999.58), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27258, ps{p(proj_utm), p(zone,58), p(south), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27259, ps{p(proj_utm), p(zone,59), p(south), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27260, ps{p(proj_utm), p(zone,60), p(south), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(units_m), p(no_defs)}),
            ce(27291, ps{p(proj_tmerc), p(lat_0,-39), p(lon_0,175.5), p(k,1), p(x_0,274319.5243848086), p(y_0,365759.3658464114), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(to_meter,0.9143984146160287), p(no_defs)}),
            ce(27292, ps{p(proj_tmerc), p(lat_0,-44), p(lon_0,171.5), p(k,1), p(x_0,457199.2073080143), p(y_0,457199.2073080143), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(to_meter,0.9143984146160287), p(no_defs)}),
            ce(27391, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,-4.666666666666667), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(pm_oslo), p(units_m), p(no_defs)}, towgs84{278.3,93,474.5,7.889,0.05,-6.61,6.21}),
            ce(27392, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,-2.333333333333333), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(pm_oslo), p(units_m), p(no_defs)}, towgs84{278.3,93,474.5,7.889,0.05,-6.61,6.21}),
            ce(27393, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(pm_oslo), p(units_m), p(no_defs)}, towgs84{278.3,93,474.5,7.889,0.05,-6.61,6.21}),
            ce(27394, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,2.5), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(pm_oslo), p(units_m), p(no_defs)}, towgs84{278.3,93,474.5,7.889,0.05,-6.61,6.21}),
            ce(27395, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,6.166666666666667), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(pm_oslo), p(units_m), p(no_defs)}, towgs84{278.3,93,474.5,7.889,0.05,-6.61,6.21}),
            ce(27396, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,10.16666666666667), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(pm_oslo), p(units_m), p(no_defs)}, towgs84{278.3,93,474.5,7.889,0.05,-6.61,6.21}),
            ce(27397, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,14.16666666666667), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(pm_oslo), p(units_m), p(no_defs)}, towgs84{278.3,93,474.5,7.889,0.05,-6.61,6.21}),
            ce(27398, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,18.33333333333333), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(pm_oslo), p(units_m), p(no_defs)}, towgs84{278.3,93,474.5,7.889,0.05,-6.61,6.21}),
            ce(27429, ps{p(proj_utm), p(zone,29), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(27492, ps{p(proj_tmerc), p(lat_0,39.66666666666666), p(lon_0,-8.131906111111112), p(k,1), p(x_0,180.598), p(y_0,-86.98999999999999), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(27493, ps{p(proj_tmerc), p(lat_0,39.66666666666666), p(lon_0,-8.131906111111112), p(k,1), p(x_0,180.598), p(y_0,-86.98999999999999), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(27500, ps{p(proj_lcc), p(lat_1,49.5), p(lat_0,49.5), p(lon_0,5.4), p(k_0,0.99950908), p(x_0,500000), p(y_0,300000), p(a,6376523), p(b,6355862.933255573), p(pm,2.3372291666985), p(units_m), p(no_defs)}),
            ce(27561, ps{p(proj_lcc), p(lat_1,49.50000000000001), p(lat_0,49.50000000000001), p(lon_0,0), p(k_0,0.999877341), p(x_0,600000), p(y_0,200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27562, ps{p(proj_lcc), p(lat_1,46.8), p(lat_0,46.8), p(lon_0,0), p(k_0,0.99987742), p(x_0,600000), p(y_0,200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27563, ps{p(proj_lcc), p(lat_1,44.10000000000001), p(lat_0,44.10000000000001), p(lon_0,0), p(k_0,0.999877499), p(x_0,600000), p(y_0,200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27564, ps{p(proj_lcc), p(lat_1,42.16500000000001), p(lat_0,42.16500000000001), p(lon_0,0), p(k_0,0.99994471), p(x_0,234.358), p(y_0,185861.369), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27571, ps{p(proj_lcc), p(lat_1,49.50000000000001), p(lat_0,49.50000000000001), p(lon_0,0), p(k_0,0.999877341), p(x_0,600000), p(y_0,1200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27572, ps{p(proj_lcc), p(lat_1,46.8), p(lat_0,46.8), p(lon_0,0), p(k_0,0.99987742), p(x_0,600000), p(y_0,2200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27573, ps{p(proj_lcc), p(lat_1,44.10000000000001), p(lat_0,44.10000000000001), p(lon_0,0), p(k_0,0.999877499), p(x_0,600000), p(y_0,3200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27574, ps{p(proj_lcc), p(lat_1,42.16500000000001), p(lat_0,42.16500000000001), p(lon_0,0), p(k_0,0.99994471), p(x_0,234.358), p(y_0,4185861.369), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27581, ps{p(proj_lcc), p(lat_1,49.50000000000001), p(lat_0,49.50000000000001), p(lon_0,0), p(k_0,0.999877341), p(x_0,600000), p(y_0,1200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27582, ps{p(proj_lcc), p(lat_1,46.8), p(lat_0,46.8), p(lon_0,0), p(k_0,0.99987742), p(x_0,600000), p(y_0,2200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27583, ps{p(proj_lcc), p(lat_1,44.10000000000001), p(lat_0,44.10000000000001), p(lon_0,0), p(k_0,0.999877499), p(x_0,600000), p(y_0,3200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27584, ps{p(proj_lcc), p(lat_1,42.16500000000001), p(lat_0,42.16500000000001), p(lon_0,0), p(k_0,0.99994471), p(x_0,234.358), p(y_0,4185861.369), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27591, ps{p(proj_lcc), p(lat_1,49.50000000000001), p(lat_0,49.50000000000001), p(lon_0,0), p(k_0,0.999877341), p(x_0,600000), p(y_0,200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27592, ps{p(proj_lcc), p(lat_1,46.8), p(lat_0,46.8), p(lon_0,0), p(k_0,0.99987742), p(x_0,600000), p(y_0,200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27593, ps{p(proj_lcc), p(lat_1,44.10000000000001), p(lat_0,44.10000000000001), p(lon_0,0), p(k_0,0.999877499), p(x_0,600000), p(y_0,200000), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27594, ps{p(proj_lcc), p(lat_1,42.16500000000001), p(lat_0,42.16500000000001), p(lon_0,0), p(k_0,0.99994471), p(x_0,234.358), p(y_0,185861.369), p(a,6378249.2), p(b,6356515), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-168,-60,320,0,0,0,0}),
            ce(27700, ps{p(proj_tmerc), p(lat_0,49), p(lon_0,-2), p(k,0.9996012717), p(x_0,400000), p(y_0,-100000), p(ellps_airy), p(srs::dpar::datum_osgb36), p(units_m), p(no_defs)}),
            ce(28191, ps{p(proj_cass), p(lat_0,31.73409694444445), p(lon_0,35.21208055555556), p(x_0,170251.555), p(y_0,126867.909), p(a,6378300.789), p(b,6356566.435), p(units_m), p(no_defs)}, towgs84{-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1}),
            ce(28192, ps{p(proj_tmerc), p(lat_0,31.73409694444445), p(lon_0,35.21208055555556), p(k,1), p(x_0,170251.555), p(y_0,1126867.909), p(a,6378300.789), p(b,6356566.435), p(units_m), p(no_defs)}, towgs84{-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1}),
            ce(28193, ps{p(proj_cass), p(lat_0,31.73409694444445), p(lon_0,35.21208055555556), p(x_0,170251.555), p(y_0,1126867.909), p(a,6378300.789), p(b,6356566.435), p(units_m), p(no_defs)}, towgs84{-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1}),
            ce(28232, ps{p(proj_utm), p(zone,32), p(south), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(28348, ps{p(proj_utm), p(zone,48), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28349, ps{p(proj_utm), p(zone,49), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28350, ps{p(proj_utm), p(zone,50), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28351, ps{p(proj_utm), p(zone,51), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28352, ps{p(proj_utm), p(zone,52), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28353, ps{p(proj_utm), p(zone,53), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28354, ps{p(proj_utm), p(zone,54), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28355, ps{p(proj_utm), p(zone,55), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28356, ps{p(proj_utm), p(zone,56), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28357, ps{p(proj_utm), p(zone,57), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28358, ps{p(proj_utm), p(zone,58), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(28402, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,1), p(x_0,2500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28403, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28404, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28405, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28406, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,6500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28407, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,7500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28408, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,8500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28409, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,9500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28410, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,57), p(k,1), p(x_0,10500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28411, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,63), p(k,1), p(x_0,11500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28412, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,69), p(k,1), p(x_0,12500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28413, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,13500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28414, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,14500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28415, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,15500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28416, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,16500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28417, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,17500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28418, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,18500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28419, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,19500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28420, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,20500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28421, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,21500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28422, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,22500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28423, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,23500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28424, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,141), p(k,1), p(x_0,24500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28425, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,147), p(k,1), p(x_0,25500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28426, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,153), p(k,1), p(x_0,26500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28427, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,159), p(k,1), p(x_0,27500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28428, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,165), p(k,1), p(x_0,28500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28429, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,171), p(k,1), p(x_0,29500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28430, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,177), p(k,1), p(x_0,30500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28431, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-177), p(k,1), p(x_0,31500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28432, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-171), p(k,1), p(x_0,32500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28462, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28463, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28464, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28465, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,27), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28466, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,33), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28467, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,39), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28468, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,45), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28469, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,51), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28470, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,57), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28471, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,63), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28472, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,69), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28473, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,75), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28474, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,81), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28475, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,87), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28476, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,93), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28477, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,99), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28478, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,105), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28479, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,111), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28480, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,117), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28481, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,123), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28482, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,129), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28483, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,135), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28484, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,141), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28485, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,147), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28486, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,153), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28487, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,159), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28488, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,165), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28489, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28490, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28491, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-177), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28492, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-171), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(28600, ps{p(proj_tmerc), p(lat_0,24.45), p(lon_0,51.21666666666667), p(k,0.99999), p(x_0,200000), p(y_0,300000), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(28991, ps{p(proj_sterea), p(lat_0,52.15616055555555), p(lon_0,5.38763888888889), p(k,0.9999079), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(28992, ps{p(proj_sterea), p(lat_0,52.15616055555555), p(lon_0,5.38763888888889), p(k,0.9999079), p(x_0,155000), p(y_0,463000), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(29100, ps{p(proj_poly), p(lat_0,0), p(lon_0,-54), p(x_0,5000000), p(y_0,10000000), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29101, ps{p(proj_poly), p(lat_0,0), p(lon_0,-54), p(x_0,5000000), p(y_0,10000000), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29118, ps{p(proj_utm), p(zone,18), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29119, ps{p(proj_utm), p(zone,19), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29120, ps{p(proj_utm), p(zone,20), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29121, ps{p(proj_utm), p(zone,21), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29122, ps{p(proj_utm), p(zone,22), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29168, ps{p(proj_utm), p(zone,18), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29169, ps{p(proj_utm), p(zone,19), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29170, ps{p(proj_utm), p(zone,20), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29171, ps{p(proj_utm), p(zone,21), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29172, ps{p(proj_utm), p(zone,22), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29177, ps{p(proj_utm), p(zone,17), p(south), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29178, ps{p(proj_utm), p(zone,18), p(south), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29179, ps{p(proj_utm), p(zone,19), p(south), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29180, ps{p(proj_utm), p(zone,20), p(south), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29181, ps{p(proj_utm), p(zone,21), p(south), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29182, ps{p(proj_utm), p(zone,22), p(south), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29183, ps{p(proj_utm), p(zone,23), p(south), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29184, ps{p(proj_utm), p(zone,24), p(south), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29185, ps{p(proj_utm), p(zone,25), p(south), p(ellps_grs67), p(units_m), p(no_defs)}),
            ce(29187, ps{p(proj_utm), p(zone,17), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29188, ps{p(proj_utm), p(zone,18), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29189, ps{p(proj_utm), p(zone,19), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29190, ps{p(proj_utm), p(zone,20), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29191, ps{p(proj_utm), p(zone,21), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29192, ps{p(proj_utm), p(zone,22), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29193, ps{p(proj_utm), p(zone,23), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29194, ps{p(proj_utm), p(zone,24), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29195, ps{p(proj_utm), p(zone,25), p(south), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(29220, ps{p(proj_utm), p(zone,20), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-355,21,72,0,0,0,0}),
            ce(29221, ps{p(proj_utm), p(zone,21), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-355,21,72,0,0,0,0}),
            ce(29333, ps{p(proj_utm), p(zone,33), p(south), p(ellps_bess_nam), p(units_m), p(no_defs)}),
            //{29371}
            //{29373}
            //{29375}
            //{29377}
            //{29379}
            //{29381}
            //{29383}
            //{29385}
            ce(29635, ps{p(proj_utm), p(zone,35), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(29636, ps{p(proj_utm), p(zone,36), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(29700, ps{p(proj_omerc), p(lat_0,-18.9), p(lonc,44.10000000000001), p(alpha,18.9), p(k,0.9995000000000001), p(x_0,400000), p(y_0,800000), p(ellps_intl), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-189,-242,-91,0,0,0,0}),
            //{29701}
            ce(29702, ps{p(proj_omerc), p(lat_0,-18.9), p(lonc,44.10000000000001), p(alpha,18.9), p(k,0.9995000000000001), p(x_0,400000), p(y_0,800000), p(ellps_intl), p(pm_paris), p(units_m), p(no_defs)}, towgs84{-189,-242,-91,0,0,0,0}),
            ce(29738, ps{p(proj_utm), p(zone,38), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-189,-242,-91,0,0,0,0}),
            ce(29739, ps{p(proj_utm), p(zone,39), p(south), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-189,-242,-91,0,0,0,0}),
            ce(29849, ps{p(proj_utm), p(zone,49), p(ellps_evrstss), p(units_m), p(no_defs)}),
            ce(29850, ps{p(proj_utm), p(zone,50), p(ellps_evrstss), p(units_m), p(no_defs)}),
            ce(29871, ps{p(proj_omerc), p(lat_0,4), p(lonc,115), p(alpha,53.31582047222222), p(k,0.99984), p(x_0,590476.8714630401), p(y_0,442857.653094361), p(ellps_evrstss), p(to_meter,20.11676512155263), p(no_defs)}),
            ce(29872, ps{p(proj_omerc), p(lat_0,4), p(lonc,115), p(alpha,53.31582047222222), p(k,0.99984), p(x_0,590476.8727431979), p(y_0,442857.6545573985), p(ellps_evrstss), p(to_meter,0.3047994715386762), p(no_defs)}),
            ce(29873, ps{p(proj_omerc), p(lat_0,4), p(lonc,115), p(alpha,53.31582047222222), p(k,0.99984), p(x_0,590476.87), p(y_0,442857.65), p(ellps_evrstss), p(units_m), p(no_defs)}),
            ce(29900, ps{p(proj_tmerc), p(lat_0,53.5), p(lon_0,-8), p(k,1.000035), p(x_0,200000), p(y_0,250000), p(a,6377340.189), p(b,6356034.447938534), p(units_m), p(no_defs)}),
            ce(29901, ps{p(proj_tmerc), p(lat_0,53.5), p(lon_0,-8), p(k,1), p(x_0,200000), p(y_0,250000), p(ellps_airy), p(units_m), p(no_defs)}, towgs84{482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15}),
            ce(29902, ps{p(proj_tmerc), p(lat_0,53.5), p(lon_0,-8), p(k,1.000035), p(x_0,200000), p(y_0,250000), p(a,6377340.189), p(b,6356034.447938534), p(units_m), p(no_defs)}),
            ce(29903, ps{p(proj_tmerc), p(lat_0,53.5), p(lon_0,-8), p(k,1.000035), p(x_0,200000), p(y_0,250000), p(a,6377340.189), p(b,6356034.447938534), p(units_m), p(no_defs)}),
            ce(30161, ps{p(proj_tmerc), p(lat_0,33), p(lon_0,129.5), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30162, ps{p(proj_tmerc), p(lat_0,33), p(lon_0,131), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30163, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,132.1666666666667), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30164, ps{p(proj_tmerc), p(lat_0,33), p(lon_0,133.5), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30165, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,134.3333333333333), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30166, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,136), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30167, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,137.1666666666667), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30168, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,138.5), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30169, ps{p(proj_tmerc), p(lat_0,36), p(lon_0,139.8333333333333), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30170, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,140.8333333333333), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30171, ps{p(proj_tmerc), p(lat_0,44), p(lon_0,140.25), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30172, ps{p(proj_tmerc), p(lat_0,44), p(lon_0,142.25), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30173, ps{p(proj_tmerc), p(lat_0,44), p(lon_0,144.25), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30174, ps{p(proj_tmerc), p(lat_0,26), p(lon_0,142), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30175, ps{p(proj_tmerc), p(lat_0,26), p(lon_0,127.5), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30176, ps{p(proj_tmerc), p(lat_0,26), p(lon_0,124), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30177, ps{p(proj_tmerc), p(lat_0,26), p(lon_0,131), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30178, ps{p(proj_tmerc), p(lat_0,20), p(lon_0,136), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30179, ps{p(proj_tmerc), p(lat_0,26), p(lon_0,154), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(30200, ps{p(proj_cass), p(lat_0,10.44166666666667), p(lon_0,-61.33333333333334), p(x_0,86501.46392051999), p(y_0,65379.0134283), p(a,6378293.645208759), p(b,6356617.987679838), p(to_meter,0.201166195164), p(no_defs)}),
            ce(30339, ps{p(proj_utm), p(zone,39), p(ellps_helmert), p(units_m), p(no_defs)}),
            ce(30340, ps{p(proj_utm), p(zone,40), p(ellps_helmert), p(units_m), p(no_defs)}),
            ce(30491, ps{p(proj_lcc), p(lat_1,36), p(lat_0,36), p(lon_0,2.7), p(k_0,0.999625544), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{-73,-247,227,0,0,0,0}),
            ce(30492, ps{p(proj_lcc), p(lat_1,33.3), p(lat_0,33.3), p(lon_0,2.7), p(k_0,0.999625769), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{-73,-247,227,0,0,0,0}),
            ce(30493, ps{p(proj_lcc), p(lat_1,36), p(lat_0,36), p(lon_0,2.7), p(k_0,0.999625544), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(30494, ps{p(proj_lcc), p(lat_1,33.3), p(lat_0,33.3), p(lon_0,2.7), p(k_0,0.999625769), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(30729, ps{p(proj_utm), p(zone,29), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(30730, ps{p(proj_utm), p(zone,30), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(30731, ps{p(proj_utm), p(zone,31), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(30732, ps{p(proj_utm), p(zone,32), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(30791, ps{p(proj_lcc), p(lat_1,36), p(lat_0,36), p(lon_0,2.7), p(k_0,0.999625544), p(x_0,500135), p(y_0,300090), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(30792, ps{p(proj_lcc), p(lat_1,33.3), p(lat_0,33.3), p(lon_0,2.7), p(k_0,0.999625769), p(x_0,500135), p(y_0,300090), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(30800, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15.80827777777778), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(31028, ps{p(proj_utm), p(zone,28), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}),
            ce(31121, ps{p(proj_utm), p(zone,21), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-265,120,-358,0,0,0,0}),
            ce(31154, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-54), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-265,120,-358,0,0,0,0}),
            ce(31170, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-55.68333333333333), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-265,120,-358,0,0,0,0}),
            ce(31171, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-55.68333333333333), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{-265,120,-358,0,0,0,0}),
            ce(31251, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,28), p(k,1), p(x_0,0), p(y_0,-5000000), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31252, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,31), p(k,1), p(x_0,0), p(y_0,-5000000), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31253, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,34), p(k,1), p(x_0,0), p(y_0,-5000000), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31254, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,10.33333333333333), p(k,1), p(x_0,0), p(y_0,-5000000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31255, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,13.33333333333333), p(k,1), p(x_0,0), p(y_0,-5000000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31256, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,16.33333333333333), p(k,1), p(x_0,0), p(y_0,-5000000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31257, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,10.33333333333333), p(k,1), p(x_0,150000), p(y_0,-5000000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31258, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,13.33333333333333), p(k,1), p(x_0,450000), p(y_0,-5000000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31259, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,16.33333333333333), p(k,1), p(x_0,750000), p(y_0,-5000000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31265, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31266, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,1), p(x_0,6500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31267, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,1), p(x_0,7500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31268, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,1), p(x_0,8500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31275, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,0.9999), p(x_0,5500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31276, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,18), p(k,0.9999), p(x_0,6500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31277, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,0.9999), p(x_0,7500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31278, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,21), p(k,0.9999), p(x_0,7500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31279, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,24), p(k,0.9999), p(x_0,8500000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31281, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,28), p(k,1), p(x_0,0), p(y_0,0), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31282, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,31), p(k,1), p(x_0,0), p(y_0,0), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31283, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,34), p(k,1), p(x_0,0), p(y_0,0), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31284, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,10.33333333333333), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31285, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,13.33333333333333), p(k,1), p(x_0,450000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31286, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,16.33333333333333), p(k,1), p(x_0,750000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31287, ps{p(proj_lcc), p(lat_1,49), p(lat_2,46), p(lat_0,47.5), p(lon_0,13.33333333333333), p(x_0,400000), p(y_0,400000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31288, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,28), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31289, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,31), p(k,1), p(x_0,450000), p(y_0,0), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31290, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,34), p(k,1), p(x_0,750000), p(y_0,0), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31291, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,28), p(k,1), p(x_0,0), p(y_0,0), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31292, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,31), p(k,1), p(x_0,0), p(y_0,0), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31293, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,34), p(k,1), p(x_0,0), p(y_0,0), p(ellps_bessel), p(pm_ferro), p(units_m), p(no_defs)}),
            ce(31294, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,10.33333333333333), p(k,1), p(x_0,150000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31295, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,13.33333333333333), p(k,1), p(x_0,450000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31296, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,16.33333333333333), p(k,1), p(x_0,750000), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            ce(31297, ps{p(proj_lcc), p(lat_1,49), p(lat_2,46), p(lat_0,47.5), p(lon_0,13.33333333333333), p(x_0,400000), p(y_0,400000), p(ellps_bessel), p(units_m), p(no_defs)}, towgs84{577.326,90.129,463.919,5.137,1.474,5.297,2.4232}),
            //{31300}
            ce(31370, ps{p(proj_lcc), p(lat_1,51.16666723333333), p(lat_2,49.8333339), p(lat_0,90), p(lon_0,4.367486666666666), p(x_0,150000.013), p(y_0,5400088.438), p(ellps_intl), p(units_m), p(no_defs)}, towgs84{106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1}),
            ce(31461, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,3), p(k,1), p(x_0,1500000), p(y_0,0), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(units_m), p(no_defs)}),
            ce(31462, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,6), p(k,1), p(x_0,2500000), p(y_0,0), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(units_m), p(no_defs)}),
            ce(31463, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(units_m), p(no_defs)}),
            ce(31464, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(units_m), p(no_defs)}),
            ce(31465, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(units_m), p(no_defs)}),
            ce(31466, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,6), p(k,1), p(x_0,2500000), p(y_0,0), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(units_m), p(no_defs)}),
            ce(31467, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,1), p(x_0,3500000), p(y_0,0), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(units_m), p(no_defs)}),
            ce(31468, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,12), p(k,1), p(x_0,4500000), p(y_0,0), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(units_m), p(no_defs)}),
            ce(31469, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,1), p(x_0,5500000), p(y_0,0), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(units_m), p(no_defs)}),
            ce(31528, ps{p(proj_utm), p(zone,28), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{-23,259,-9,0,0,0,0}),
            ce(31529, ps{p(proj_utm), p(zone,29), p(a,6378249.2), p(b,6356515), p(units_m), p(no_defs)}, towgs84{-23,259,-9,0,0,0,0}),
            ce(31600, ps{p(proj_sterea), p(lat_0,45.9), p(lon_0,25.39246588888889), p(k,0.9996667), p(x_0,500000), p(y_0,500000), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(31700, ps{p(proj_sterea), p(lat_0,46), p(lon_0,25), p(k,0.99975), p(x_0,500000), p(y_0,500000), p(ellps_krass), p(units_m), p(no_defs)}),
            ce(31838, ps{p(proj_utm), p(zone,38), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{-3.2,-5.7,2.8,0,0,0,0}),
            ce(31839, ps{p(proj_utm), p(zone,39), p(ellps_wgs84), p(units_m), p(no_defs)}, towgs84{-3.2,-5.7,2.8,0,0,0,0}),
            ce(31900, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,48), p(k,0.9996), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(31901, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,48), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(31965, ps{p(proj_utm), p(zone,11), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31966, ps{p(proj_utm), p(zone,12), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31967, ps{p(proj_utm), p(zone,13), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31968, ps{p(proj_utm), p(zone,14), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31969, ps{p(proj_utm), p(zone,15), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31970, ps{p(proj_utm), p(zone,16), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31971, ps{p(proj_utm), p(zone,17), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31972, ps{p(proj_utm), p(zone,18), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31973, ps{p(proj_utm), p(zone,19), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31974, ps{p(proj_utm), p(zone,20), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31975, ps{p(proj_utm), p(zone,21), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31976, ps{p(proj_utm), p(zone,22), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31977, ps{p(proj_utm), p(zone,17), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31978, ps{p(proj_utm), p(zone,18), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31979, ps{p(proj_utm), p(zone,19), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31980, ps{p(proj_utm), p(zone,20), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31981, ps{p(proj_utm), p(zone,21), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31982, ps{p(proj_utm), p(zone,22), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31983, ps{p(proj_utm), p(zone,23), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31984, ps{p(proj_utm), p(zone,24), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31985, ps{p(proj_utm), p(zone,25), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31986, ps{p(proj_utm), p(zone,17), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31987, ps{p(proj_utm), p(zone,18), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31988, ps{p(proj_utm), p(zone,19), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31989, ps{p(proj_utm), p(zone,20), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31990, ps{p(proj_utm), p(zone,21), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31991, ps{p(proj_utm), p(zone,22), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31992, ps{p(proj_utm), p(zone,17), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31993, ps{p(proj_utm), p(zone,18), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31994, ps{p(proj_utm), p(zone,19), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31995, ps{p(proj_utm), p(zone,20), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31996, ps{p(proj_utm), p(zone,21), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31997, ps{p(proj_utm), p(zone,22), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31998, ps{p(proj_utm), p(zone,23), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(31999, ps{p(proj_utm), p(zone,24), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(32000, ps{p(proj_utm), p(zone,25), p(south), p(ellps_grs80), p(units_m), p(no_defs)}, towgs84{0,0,0,0,0,0,0}),
            ce(32001, ps{p(proj_lcc), p(lat_1,48.71666666666667), p(lat_2,47.85), p(lat_0,47), p(lon_0,-109.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32002, ps{p(proj_lcc), p(lat_1,47.88333333333333), p(lat_2,46.45), p(lat_0,45.83333333333334), p(lon_0,-109.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32003, ps{p(proj_lcc), p(lat_1,46.4), p(lat_2,44.86666666666667), p(lat_0,44), p(lon_0,-109.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32005, ps{p(proj_lcc), p(lat_1,41.85), p(lat_2,42.81666666666667), p(lat_0,41.33333333333334), p(lon_0,-100), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32006, ps{p(proj_lcc), p(lat_1,40.28333333333333), p(lat_2,41.71666666666667), p(lat_0,39.66666666666666), p(lon_0,-99.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32007, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-115.5833333333333), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32008, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-116.6666666666667), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32009, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-118.5833333333333), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32010, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-71.66666666666667), p(k,0.999966667), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32011, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.66666666666667), p(k,0.9999749999999999), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32012, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-104.3333333333333), p(k,0.999909091), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32013, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-106.25), p(k,0.9999), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32014, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-107.8333333333333), p(k,0.999916667), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32015, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-74.33333333333333), p(k,0.999966667), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32016, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-76.58333333333333), p(k,0.9999375), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32017, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-78.58333333333333), p(k,0.9999375), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32018, ps{p(proj_lcc), p(lat_1,41.03333333333333), p(lat_2,40.66666666666666), p(lat_0,40.5), p(lon_0,-74), p(x_0,304800.6096012192), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32019, ps{p(proj_lcc), p(lat_1,34.33333333333334), p(lat_2,36.16666666666666), p(lat_0,33.75), p(lon_0,-79), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32020, ps{p(proj_lcc), p(lat_1,47.43333333333333), p(lat_2,48.73333333333333), p(lat_0,47), p(lon_0,-100.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32021, ps{p(proj_lcc), p(lat_1,46.18333333333333), p(lat_2,47.48333333333333), p(lat_0,45.66666666666666), p(lon_0,-100.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32022, ps{p(proj_lcc), p(lat_1,40.43333333333333), p(lat_2,41.7), p(lat_0,39.66666666666666), p(lon_0,-82.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32023, ps{p(proj_lcc), p(lat_1,38.73333333333333), p(lat_2,40.03333333333333), p(lat_0,38), p(lon_0,-82.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32024, ps{p(proj_lcc), p(lat_1,35.56666666666667), p(lat_2,36.76666666666667), p(lat_0,35), p(lon_0,-98), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32025, ps{p(proj_lcc), p(lat_1,33.93333333333333), p(lat_2,35.23333333333333), p(lat_0,33.33333333333334), p(lon_0,-98), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32026, ps{p(proj_lcc), p(lat_1,44.33333333333334), p(lat_2,46), p(lat_0,43.66666666666666), p(lon_0,-120.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32027, ps{p(proj_lcc), p(lat_1,42.33333333333334), p(lat_2,44), p(lat_0,41.66666666666666), p(lon_0,-120.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32028, ps{p(proj_lcc), p(lat_1,40.88333333333333), p(lat_2,41.95), p(lat_0,40.16666666666666), p(lon_0,-77.75), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32029, ps{p(proj_lcc), p(lat_1,39.93333333333333), p(lat_2,40.8), p(lat_0,39.33333333333334), p(lon_0,-77.75), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32030, ps{p(proj_tmerc), p(lat_0,41.08333333333334), p(lon_0,-71.5), p(k,0.9999938), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32031, ps{p(proj_lcc), p(lat_1,33.76666666666667), p(lat_2,34.96666666666667), p(lat_0,33), p(lon_0,-81), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32033, ps{p(proj_lcc), p(lat_1,32.33333333333334), p(lat_2,33.66666666666666), p(lat_0,31.83333333333333), p(lon_0,-81), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32034, ps{p(proj_lcc), p(lat_1,44.41666666666666), p(lat_2,45.68333333333333), p(lat_0,43.83333333333334), p(lon_0,-100), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32035, ps{p(proj_lcc), p(lat_1,42.83333333333334), p(lat_2,44.4), p(lat_0,42.33333333333334), p(lon_0,-100.3333333333333), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32036, ps{p(proj_lcc), p(lat_1,35.25), p(lat_2,36.41666666666666), p(lat_0,34.66666666666666), p(lon_0,-86), p(x_0,30480.06096012192), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32037, ps{p(proj_lcc), p(lat_1,34.65), p(lat_2,36.18333333333333), p(lat_0,34), p(lon_0,-101.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32038, ps{p(proj_lcc), p(lat_1,32.13333333333333), p(lat_2,33.96666666666667), p(lat_0,31.66666666666667), p(lon_0,-97.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32039, ps{p(proj_lcc), p(lat_1,30.11666666666667), p(lat_2,31.88333333333333), p(lat_0,29.66666666666667), p(lon_0,-100.3333333333333), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32040, ps{p(proj_lcc), p(lat_1,28.38333333333333), p(lat_2,30.28333333333333), p(lat_0,27.83333333333333), p(lon_0,-99), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32041, ps{p(proj_lcc), p(lat_1,26.16666666666667), p(lat_2,27.83333333333333), p(lat_0,25.66666666666667), p(lon_0,-98.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32042, ps{p(proj_lcc), p(lat_1,40.71666666666667), p(lat_2,41.78333333333333), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32043, ps{p(proj_lcc), p(lat_1,39.01666666666667), p(lat_2,40.65), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32044, ps{p(proj_lcc), p(lat_1,37.21666666666667), p(lat_2,38.35), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32045, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-72.5), p(k,0.999964286), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32046, ps{p(proj_lcc), p(lat_1,38.03333333333333), p(lat_2,39.2), p(lat_0,37.66666666666666), p(lon_0,-78.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32047, ps{p(proj_lcc), p(lat_1,36.76666666666667), p(lat_2,37.96666666666667), p(lat_0,36.33333333333334), p(lon_0,-78.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32048, ps{p(proj_lcc), p(lat_1,47.5), p(lat_2,48.73333333333333), p(lat_0,47), p(lon_0,-120.8333333333333), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32049, ps{p(proj_lcc), p(lat_1,45.83333333333334), p(lat_2,47.33333333333334), p(lat_0,45.33333333333334), p(lon_0,-120.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32050, ps{p(proj_lcc), p(lat_1,39), p(lat_2,40.25), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32051, ps{p(proj_lcc), p(lat_1,37.48333333333333), p(lat_2,38.88333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32052, ps{p(proj_lcc), p(lat_1,45.56666666666667), p(lat_2,46.76666666666667), p(lat_0,45.16666666666666), p(lon_0,-90), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32053, ps{p(proj_lcc), p(lat_1,44.25), p(lat_2,45.5), p(lat_0,43.83333333333334), p(lon_0,-90), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32054, ps{p(proj_lcc), p(lat_1,42.73333333333333), p(lat_2,44.06666666666667), p(lat_0,42), p(lon_0,-90), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32055, ps{p(proj_tmerc), p(lat_0,40.66666666666666), p(lon_0,-105.1666666666667), p(k,0.999941177), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32056, ps{p(proj_tmerc), p(lat_0,40.66666666666666), p(lon_0,-107.3333333333333), p(k,0.999941177), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32057, ps{p(proj_tmerc), p(lat_0,40.66666666666666), p(lon_0,-108.75), p(k,0.999941177), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32058, ps{p(proj_tmerc), p(lat_0,40.66666666666666), p(lon_0,-110.0833333333333), p(k,0.999941177), p(x_0,152400.3048006096), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32061, ps{p(proj_lcc), p(lat_1,16.81666666666667), p(lat_0,16.81666666666667), p(lon_0,-90.33333333333333), p(k_0,0.99992226), p(x_0,500000), p(y_0,292209.579), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(32062, ps{p(proj_lcc), p(lat_1,14.9), p(lat_0,14.9), p(lon_0,-90.33333333333333), p(k_0,0.99989906), p(x_0,500000), p(y_0,325992.681), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(32064, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-99), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32065, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-93), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32066, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-87), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32067, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-81), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32074, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-99), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32075, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-93), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32076, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-87), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32077, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-81), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32081, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-53), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(32082, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-56), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(32083, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-58.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(32084, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-61.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(32085, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-64.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(32086, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-67.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(32098, ps{p(proj_lcc), p(lat_1,60), p(lat_2,46), p(lat_0,44), p(lon_0,-68.5), p(x_0,0), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(32099, ps{p(proj_lcc), p(lat_1,27.83333333333333), p(lat_2,26.16666666666667), p(lat_0,25.66666666666667), p(lon_0,-91.33333333333333), p(x_0,609601.2192024384), p(y_0,0), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32100, ps{p(proj_lcc), p(lat_1,49), p(lat_2,45), p(lat_0,44.25), p(lon_0,-109.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32104, ps{p(proj_lcc), p(lat_1,43), p(lat_2,40), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32107, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-115.5833333333333), p(k,0.9999), p(x_0,200000), p(y_0,8000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32108, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-116.6666666666667), p(k,0.9999), p(x_0,500000), p(y_0,6000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32109, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-118.5833333333333), p(k,0.9999), p(x_0,800000), p(y_0,4000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32110, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-71.66666666666667), p(k,0.999966667), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32111, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32112, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-104.3333333333333), p(k,0.999909091), p(x_0,165000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32113, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-106.25), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32114, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-107.8333333333333), p(k,0.999916667), p(x_0,830000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32115, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32116, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-76.58333333333333), p(k,0.9999375), p(x_0,250000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32117, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-78.58333333333333), p(k,0.9999375), p(x_0,350000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32118, ps{p(proj_lcc), p(lat_1,41.03333333333333), p(lat_2,40.66666666666666), p(lat_0,40.16666666666666), p(lon_0,-74), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32119, ps{p(proj_lcc), p(lat_1,36.16666666666666), p(lat_2,34.33333333333334), p(lat_0,33.75), p(lon_0,-79), p(x_0,609601.22), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32120, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.43333333333333), p(lat_0,47), p(lon_0,-100.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32121, ps{p(proj_lcc), p(lat_1,47.48333333333333), p(lat_2,46.18333333333333), p(lat_0,45.66666666666666), p(lon_0,-100.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32122, ps{p(proj_lcc), p(lat_1,41.7), p(lat_2,40.43333333333333), p(lat_0,39.66666666666666), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32123, ps{p(proj_lcc), p(lat_1,40.03333333333333), p(lat_2,38.73333333333333), p(lat_0,38), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32124, ps{p(proj_lcc), p(lat_1,36.76666666666667), p(lat_2,35.56666666666667), p(lat_0,35), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32125, ps{p(proj_lcc), p(lat_1,35.23333333333333), p(lat_2,33.93333333333333), p(lat_0,33.33333333333334), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32126, ps{p(proj_lcc), p(lat_1,46), p(lat_2,44.33333333333334), p(lat_0,43.66666666666666), p(lon_0,-120.5), p(x_0,2500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32127, ps{p(proj_lcc), p(lat_1,44), p(lat_2,42.33333333333334), p(lat_0,41.66666666666666), p(lon_0,-120.5), p(x_0,1500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32128, ps{p(proj_lcc), p(lat_1,41.95), p(lat_2,40.88333333333333), p(lat_0,40.16666666666666), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32129, ps{p(proj_lcc), p(lat_1,40.96666666666667), p(lat_2,39.93333333333333), p(lat_0,39.33333333333334), p(lon_0,-77.75), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32130, ps{p(proj_tmerc), p(lat_0,41.08333333333334), p(lon_0,-71.5), p(k,0.99999375), p(x_0,100000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32133, ps{p(proj_lcc), p(lat_1,34.83333333333334), p(lat_2,32.5), p(lat_0,31.83333333333333), p(lon_0,-81), p(x_0,609600), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32134, ps{p(proj_lcc), p(lat_1,45.68333333333333), p(lat_2,44.41666666666666), p(lat_0,43.83333333333334), p(lon_0,-100), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32135, ps{p(proj_lcc), p(lat_1,44.4), p(lat_2,42.83333333333334), p(lat_0,42.33333333333334), p(lon_0,-100.3333333333333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32136, ps{p(proj_lcc), p(lat_1,36.41666666666666), p(lat_2,35.25), p(lat_0,34.33333333333334), p(lon_0,-86), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32137, ps{p(proj_lcc), p(lat_1,36.18333333333333), p(lat_2,34.65), p(lat_0,34), p(lon_0,-101.5), p(x_0,200000), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32138, ps{p(proj_lcc), p(lat_1,33.96666666666667), p(lat_2,32.13333333333333), p(lat_0,31.66666666666667), p(lon_0,-98.5), p(x_0,600000), p(y_0,2000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32139, ps{p(proj_lcc), p(lat_1,31.88333333333333), p(lat_2,30.11666666666667), p(lat_0,29.66666666666667), p(lon_0,-100.3333333333333), p(x_0,700000), p(y_0,3000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32140, ps{p(proj_lcc), p(lat_1,30.28333333333333), p(lat_2,28.38333333333333), p(lat_0,27.83333333333333), p(lon_0,-99), p(x_0,600000), p(y_0,4000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32141, ps{p(proj_lcc), p(lat_1,27.83333333333333), p(lat_2,26.16666666666667), p(lat_0,25.66666666666667), p(lon_0,-98.5), p(x_0,300000), p(y_0,5000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32142, ps{p(proj_lcc), p(lat_1,41.78333333333333), p(lat_2,40.71666666666667), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32143, ps{p(proj_lcc), p(lat_1,40.65), p(lat_2,39.01666666666667), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000), p(y_0,2000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32144, ps{p(proj_lcc), p(lat_1,38.35), p(lat_2,37.21666666666667), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000), p(y_0,3000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32145, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-72.5), p(k,0.999964286), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32146, ps{p(proj_lcc), p(lat_1,39.2), p(lat_2,38.03333333333333), p(lat_0,37.66666666666666), p(lon_0,-78.5), p(x_0,3500000), p(y_0,2000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32147, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,36.76666666666667), p(lat_0,36.33333333333334), p(lon_0,-78.5), p(x_0,3500000), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32148, ps{p(proj_lcc), p(lat_1,48.73333333333333), p(lat_2,47.5), p(lat_0,47), p(lon_0,-120.8333333333333), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32149, ps{p(proj_lcc), p(lat_1,47.33333333333334), p(lat_2,45.83333333333334), p(lat_0,45.33333333333334), p(lon_0,-120.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32150, ps{p(proj_lcc), p(lat_1,40.25), p(lat_2,39), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32151, ps{p(proj_lcc), p(lat_1,38.88333333333333), p(lat_2,37.48333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32152, ps{p(proj_lcc), p(lat_1,46.76666666666667), p(lat_2,45.56666666666667), p(lat_0,45.16666666666666), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32153, ps{p(proj_lcc), p(lat_1,45.5), p(lat_2,44.25), p(lat_0,43.83333333333334), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32154, ps{p(proj_lcc), p(lat_1,44.06666666666667), p(lat_2,42.73333333333333), p(lat_0,42), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32155, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-105.1666666666667), p(k,0.9999375), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32156, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-107.3333333333333), p(k,0.9999375), p(x_0,400000), p(y_0,100000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32157, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-108.75), p(k,0.9999375), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32158, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-110.0833333333333), p(k,0.9999375), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32161, ps{p(proj_lcc), p(lat_1,18.43333333333333), p(lat_2,18.03333333333333), p(lat_0,17.83333333333333), p(lon_0,-66.43333333333334), p(x_0,200000), p(y_0,200000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32164, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-99), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32165, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-93), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32166, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-87), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32167, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-81), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32180, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-55.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32181, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-53), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32182, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-56), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32183, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-58.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32184, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-61.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32185, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-64.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32186, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-67.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32187, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-70.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32188, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-73.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32189, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-76.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32190, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-79.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32191, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-82.5), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32192, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-81), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32193, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-84), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32194, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-87), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32195, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-90), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32196, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-93), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32197, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-96), p(k,0.9999), p(x_0,304800), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32198, ps{p(proj_lcc), p(lat_1,60), p(lat_2,46), p(lat_0,44), p(lon_0,-68.5), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32199, ps{p(proj_lcc), p(lat_1,27.83333333333333), p(lat_2,26.16666666666667), p(lat_0,25.5), p(lon_0,-91.33333333333333), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(32201, ps{p(proj_utm), p(zone,1), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32202, ps{p(proj_utm), p(zone,2), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32203, ps{p(proj_utm), p(zone,3), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32204, ps{p(proj_utm), p(zone,4), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32205, ps{p(proj_utm), p(zone,5), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32206, ps{p(proj_utm), p(zone,6), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32207, ps{p(proj_utm), p(zone,7), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32208, ps{p(proj_utm), p(zone,8), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32209, ps{p(proj_utm), p(zone,9), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32210, ps{p(proj_utm), p(zone,10), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32211, ps{p(proj_utm), p(zone,11), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32212, ps{p(proj_utm), p(zone,12), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32213, ps{p(proj_utm), p(zone,13), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32214, ps{p(proj_utm), p(zone,14), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32215, ps{p(proj_utm), p(zone,15), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32216, ps{p(proj_utm), p(zone,16), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32217, ps{p(proj_utm), p(zone,17), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32218, ps{p(proj_utm), p(zone,18), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32219, ps{p(proj_utm), p(zone,19), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32220, ps{p(proj_utm), p(zone,20), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32221, ps{p(proj_utm), p(zone,21), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32222, ps{p(proj_utm), p(zone,22), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32223, ps{p(proj_utm), p(zone,23), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32224, ps{p(proj_utm), p(zone,24), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32225, ps{p(proj_utm), p(zone,25), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32226, ps{p(proj_utm), p(zone,26), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32227, ps{p(proj_utm), p(zone,27), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32228, ps{p(proj_utm), p(zone,28), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32229, ps{p(proj_utm), p(zone,29), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32230, ps{p(proj_utm), p(zone,30), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32231, ps{p(proj_utm), p(zone,31), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32232, ps{p(proj_utm), p(zone,32), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32233, ps{p(proj_utm), p(zone,33), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32234, ps{p(proj_utm), p(zone,34), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32235, ps{p(proj_utm), p(zone,35), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32236, ps{p(proj_utm), p(zone,36), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32237, ps{p(proj_utm), p(zone,37), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32238, ps{p(proj_utm), p(zone,38), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32239, ps{p(proj_utm), p(zone,39), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32240, ps{p(proj_utm), p(zone,40), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32241, ps{p(proj_utm), p(zone,41), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32242, ps{p(proj_utm), p(zone,42), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32243, ps{p(proj_utm), p(zone,43), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32244, ps{p(proj_utm), p(zone,44), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32245, ps{p(proj_utm), p(zone,45), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32246, ps{p(proj_utm), p(zone,46), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32247, ps{p(proj_utm), p(zone,47), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32248, ps{p(proj_utm), p(zone,48), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32249, ps{p(proj_utm), p(zone,49), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32250, ps{p(proj_utm), p(zone,50), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32251, ps{p(proj_utm), p(zone,51), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32252, ps{p(proj_utm), p(zone,52), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32253, ps{p(proj_utm), p(zone,53), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32254, ps{p(proj_utm), p(zone,54), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32255, ps{p(proj_utm), p(zone,55), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32256, ps{p(proj_utm), p(zone,56), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32257, ps{p(proj_utm), p(zone,57), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32258, ps{p(proj_utm), p(zone,58), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32259, ps{p(proj_utm), p(zone,59), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32260, ps{p(proj_utm), p(zone,60), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32301, ps{p(proj_utm), p(zone,1), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32302, ps{p(proj_utm), p(zone,2), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32303, ps{p(proj_utm), p(zone,3), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32304, ps{p(proj_utm), p(zone,4), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32305, ps{p(proj_utm), p(zone,5), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32306, ps{p(proj_utm), p(zone,6), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32307, ps{p(proj_utm), p(zone,7), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32308, ps{p(proj_utm), p(zone,8), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32309, ps{p(proj_utm), p(zone,9), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32310, ps{p(proj_utm), p(zone,10), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32311, ps{p(proj_utm), p(zone,11), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32312, ps{p(proj_utm), p(zone,12), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32313, ps{p(proj_utm), p(zone,13), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32314, ps{p(proj_utm), p(zone,14), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32315, ps{p(proj_utm), p(zone,15), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32316, ps{p(proj_utm), p(zone,16), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32317, ps{p(proj_utm), p(zone,17), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32318, ps{p(proj_utm), p(zone,18), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32319, ps{p(proj_utm), p(zone,19), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32320, ps{p(proj_utm), p(zone,20), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32321, ps{p(proj_utm), p(zone,21), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32322, ps{p(proj_utm), p(zone,22), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32323, ps{p(proj_utm), p(zone,23), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32324, ps{p(proj_utm), p(zone,24), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32325, ps{p(proj_utm), p(zone,25), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32326, ps{p(proj_utm), p(zone,26), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32327, ps{p(proj_utm), p(zone,27), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32328, ps{p(proj_utm), p(zone,28), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32329, ps{p(proj_utm), p(zone,29), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32330, ps{p(proj_utm), p(zone,30), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32331, ps{p(proj_utm), p(zone,31), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32332, ps{p(proj_utm), p(zone,32), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32333, ps{p(proj_utm), p(zone,33), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32334, ps{p(proj_utm), p(zone,34), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32335, ps{p(proj_utm), p(zone,35), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32336, ps{p(proj_utm), p(zone,36), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32337, ps{p(proj_utm), p(zone,37), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32338, ps{p(proj_utm), p(zone,38), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32339, ps{p(proj_utm), p(zone,39), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32340, ps{p(proj_utm), p(zone,40), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32341, ps{p(proj_utm), p(zone,41), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32342, ps{p(proj_utm), p(zone,42), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32343, ps{p(proj_utm), p(zone,43), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32344, ps{p(proj_utm), p(zone,44), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32345, ps{p(proj_utm), p(zone,45), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32346, ps{p(proj_utm), p(zone,46), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32347, ps{p(proj_utm), p(zone,47), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32348, ps{p(proj_utm), p(zone,48), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32349, ps{p(proj_utm), p(zone,49), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32350, ps{p(proj_utm), p(zone,50), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32351, ps{p(proj_utm), p(zone,51), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32352, ps{p(proj_utm), p(zone,52), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32353, ps{p(proj_utm), p(zone,53), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32354, ps{p(proj_utm), p(zone,54), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32355, ps{p(proj_utm), p(zone,55), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32356, ps{p(proj_utm), p(zone,56), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32357, ps{p(proj_utm), p(zone,57), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32358, ps{p(proj_utm), p(zone,58), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32359, ps{p(proj_utm), p(zone,59), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32360, ps{p(proj_utm), p(zone,60), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}),
            ce(32401, ps{p(proj_utm), p(zone,1), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32402, ps{p(proj_utm), p(zone,2), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32403, ps{p(proj_utm), p(zone,3), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32404, ps{p(proj_utm), p(zone,4), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32405, ps{p(proj_utm), p(zone,5), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32406, ps{p(proj_utm), p(zone,6), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32407, ps{p(proj_utm), p(zone,7), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32408, ps{p(proj_utm), p(zone,8), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32409, ps{p(proj_utm), p(zone,9), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32410, ps{p(proj_utm), p(zone,10), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32411, ps{p(proj_utm), p(zone,11), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32412, ps{p(proj_utm), p(zone,12), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32413, ps{p(proj_utm), p(zone,13), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32414, ps{p(proj_utm), p(zone,14), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32415, ps{p(proj_utm), p(zone,15), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32416, ps{p(proj_utm), p(zone,16), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32417, ps{p(proj_utm), p(zone,17), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32418, ps{p(proj_utm), p(zone,18), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32419, ps{p(proj_utm), p(zone,19), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32420, ps{p(proj_utm), p(zone,20), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32421, ps{p(proj_utm), p(zone,21), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32422, ps{p(proj_utm), p(zone,22), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32423, ps{p(proj_utm), p(zone,23), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32424, ps{p(proj_utm), p(zone,24), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32425, ps{p(proj_utm), p(zone,25), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32426, ps{p(proj_utm), p(zone,26), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32427, ps{p(proj_utm), p(zone,27), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32428, ps{p(proj_utm), p(zone,28), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32429, ps{p(proj_utm), p(zone,29), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32430, ps{p(proj_utm), p(zone,30), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32431, ps{p(proj_utm), p(zone,31), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32432, ps{p(proj_utm), p(zone,32), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32433, ps{p(proj_utm), p(zone,33), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32434, ps{p(proj_utm), p(zone,34), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32435, ps{p(proj_utm), p(zone,35), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32436, ps{p(proj_utm), p(zone,36), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32437, ps{p(proj_utm), p(zone,37), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32438, ps{p(proj_utm), p(zone,38), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32439, ps{p(proj_utm), p(zone,39), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32440, ps{p(proj_utm), p(zone,40), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32441, ps{p(proj_utm), p(zone,41), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32442, ps{p(proj_utm), p(zone,42), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32443, ps{p(proj_utm), p(zone,43), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32444, ps{p(proj_utm), p(zone,44), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32445, ps{p(proj_utm), p(zone,45), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32446, ps{p(proj_utm), p(zone,46), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32447, ps{p(proj_utm), p(zone,47), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32448, ps{p(proj_utm), p(zone,48), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32449, ps{p(proj_utm), p(zone,49), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32450, ps{p(proj_utm), p(zone,50), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32451, ps{p(proj_utm), p(zone,51), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32452, ps{p(proj_utm), p(zone,52), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32453, ps{p(proj_utm), p(zone,53), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32454, ps{p(proj_utm), p(zone,54), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32455, ps{p(proj_utm), p(zone,55), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32456, ps{p(proj_utm), p(zone,56), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32457, ps{p(proj_utm), p(zone,57), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32458, ps{p(proj_utm), p(zone,58), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32459, ps{p(proj_utm), p(zone,59), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32460, ps{p(proj_utm), p(zone,60), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32501, ps{p(proj_utm), p(zone,1), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32502, ps{p(proj_utm), p(zone,2), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32503, ps{p(proj_utm), p(zone,3), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32504, ps{p(proj_utm), p(zone,4), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32505, ps{p(proj_utm), p(zone,5), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32506, ps{p(proj_utm), p(zone,6), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32507, ps{p(proj_utm), p(zone,7), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32508, ps{p(proj_utm), p(zone,8), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32509, ps{p(proj_utm), p(zone,9), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32510, ps{p(proj_utm), p(zone,10), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32511, ps{p(proj_utm), p(zone,11), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32512, ps{p(proj_utm), p(zone,12), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32513, ps{p(proj_utm), p(zone,13), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32514, ps{p(proj_utm), p(zone,14), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32515, ps{p(proj_utm), p(zone,15), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32516, ps{p(proj_utm), p(zone,16), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32517, ps{p(proj_utm), p(zone,17), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32518, ps{p(proj_utm), p(zone,18), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32519, ps{p(proj_utm), p(zone,19), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32520, ps{p(proj_utm), p(zone,20), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32521, ps{p(proj_utm), p(zone,21), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32522, ps{p(proj_utm), p(zone,22), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32523, ps{p(proj_utm), p(zone,23), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32524, ps{p(proj_utm), p(zone,24), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32525, ps{p(proj_utm), p(zone,25), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32526, ps{p(proj_utm), p(zone,26), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32527, ps{p(proj_utm), p(zone,27), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32528, ps{p(proj_utm), p(zone,28), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32529, ps{p(proj_utm), p(zone,29), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32530, ps{p(proj_utm), p(zone,30), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32531, ps{p(proj_utm), p(zone,31), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32532, ps{p(proj_utm), p(zone,32), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32533, ps{p(proj_utm), p(zone,33), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32534, ps{p(proj_utm), p(zone,34), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32535, ps{p(proj_utm), p(zone,35), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32536, ps{p(proj_utm), p(zone,36), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32537, ps{p(proj_utm), p(zone,37), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32538, ps{p(proj_utm), p(zone,38), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32539, ps{p(proj_utm), p(zone,39), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32540, ps{p(proj_utm), p(zone,40), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32541, ps{p(proj_utm), p(zone,41), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32542, ps{p(proj_utm), p(zone,42), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32543, ps{p(proj_utm), p(zone,43), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32544, ps{p(proj_utm), p(zone,44), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32545, ps{p(proj_utm), p(zone,45), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32546, ps{p(proj_utm), p(zone,46), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32547, ps{p(proj_utm), p(zone,47), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32548, ps{p(proj_utm), p(zone,48), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32549, ps{p(proj_utm), p(zone,49), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32550, ps{p(proj_utm), p(zone,50), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32551, ps{p(proj_utm), p(zone,51), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32552, ps{p(proj_utm), p(zone,52), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32553, ps{p(proj_utm), p(zone,53), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32554, ps{p(proj_utm), p(zone,54), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32555, ps{p(proj_utm), p(zone,55), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32556, ps{p(proj_utm), p(zone,56), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32557, ps{p(proj_utm), p(zone,57), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32558, ps{p(proj_utm), p(zone,58), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32559, ps{p(proj_utm), p(zone,59), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            ce(32560, ps{p(proj_utm), p(zone,60), p(south), p(ellps_wgs72), p(units_m), p(no_defs)}, towgs84{0,0,1.9,0,0,0.814,-0.38}),
            //{32600}
            ce(32601, ps{p(proj_utm), p(zone,1), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32602, ps{p(proj_utm), p(zone,2), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32603, ps{p(proj_utm), p(zone,3), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32604, ps{p(proj_utm), p(zone,4), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32605, ps{p(proj_utm), p(zone,5), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32606, ps{p(proj_utm), p(zone,6), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32607, ps{p(proj_utm), p(zone,7), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32608, ps{p(proj_utm), p(zone,8), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32609, ps{p(proj_utm), p(zone,9), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32610, ps{p(proj_utm), p(zone,10), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32611, ps{p(proj_utm), p(zone,11), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32612, ps{p(proj_utm), p(zone,12), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32613, ps{p(proj_utm), p(zone,13), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32614, ps{p(proj_utm), p(zone,14), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32615, ps{p(proj_utm), p(zone,15), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32616, ps{p(proj_utm), p(zone,16), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32617, ps{p(proj_utm), p(zone,17), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32618, ps{p(proj_utm), p(zone,18), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32619, ps{p(proj_utm), p(zone,19), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32620, ps{p(proj_utm), p(zone,20), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32621, ps{p(proj_utm), p(zone,21), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32622, ps{p(proj_utm), p(zone,22), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32623, ps{p(proj_utm), p(zone,23), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32624, ps{p(proj_utm), p(zone,24), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32625, ps{p(proj_utm), p(zone,25), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32626, ps{p(proj_utm), p(zone,26), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32627, ps{p(proj_utm), p(zone,27), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32628, ps{p(proj_utm), p(zone,28), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32629, ps{p(proj_utm), p(zone,29), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32630, ps{p(proj_utm), p(zone,30), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32631, ps{p(proj_utm), p(zone,31), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32632, ps{p(proj_utm), p(zone,32), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32633, ps{p(proj_utm), p(zone,33), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32634, ps{p(proj_utm), p(zone,34), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32635, ps{p(proj_utm), p(zone,35), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32636, ps{p(proj_utm), p(zone,36), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32637, ps{p(proj_utm), p(zone,37), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32638, ps{p(proj_utm), p(zone,38), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32639, ps{p(proj_utm), p(zone,39), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32640, ps{p(proj_utm), p(zone,40), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32641, ps{p(proj_utm), p(zone,41), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32642, ps{p(proj_utm), p(zone,42), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32643, ps{p(proj_utm), p(zone,43), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32644, ps{p(proj_utm), p(zone,44), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32645, ps{p(proj_utm), p(zone,45), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32646, ps{p(proj_utm), p(zone,46), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32647, ps{p(proj_utm), p(zone,47), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32648, ps{p(proj_utm), p(zone,48), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32649, ps{p(proj_utm), p(zone,49), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32650, ps{p(proj_utm), p(zone,50), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32651, ps{p(proj_utm), p(zone,51), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32652, ps{p(proj_utm), p(zone,52), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32653, ps{p(proj_utm), p(zone,53), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32654, ps{p(proj_utm), p(zone,54), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32655, ps{p(proj_utm), p(zone,55), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32656, ps{p(proj_utm), p(zone,56), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32657, ps{p(proj_utm), p(zone,57), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32658, ps{p(proj_utm), p(zone,58), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32659, ps{p(proj_utm), p(zone,59), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32660, ps{p(proj_utm), p(zone,60), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32661, ps{p(proj_stere), p(lat_0,90), p(lat_ts,90), p(lon_0,0), p(k,0.994), p(x_0,2000000), p(y_0,2000000), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32662, ps{p(proj_eqc), p(lat_ts,0), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            //{32663}
            ce(32664, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-99), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32665, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-93), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32666, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-87), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(32667, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,-81), p(k,0.9996), p(x_0,500000.001016002), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(to_meter,0.3048006096012192), p(no_defs)}),
            //{32700}
            ce(32701, ps{p(proj_utm), p(zone,1), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32702, ps{p(proj_utm), p(zone,2), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32703, ps{p(proj_utm), p(zone,3), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32704, ps{p(proj_utm), p(zone,4), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32705, ps{p(proj_utm), p(zone,5), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32706, ps{p(proj_utm), p(zone,6), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32707, ps{p(proj_utm), p(zone,7), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32708, ps{p(proj_utm), p(zone,8), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32709, ps{p(proj_utm), p(zone,9), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32710, ps{p(proj_utm), p(zone,10), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32711, ps{p(proj_utm), p(zone,11), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32712, ps{p(proj_utm), p(zone,12), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32713, ps{p(proj_utm), p(zone,13), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32714, ps{p(proj_utm), p(zone,14), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32715, ps{p(proj_utm), p(zone,15), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32716, ps{p(proj_utm), p(zone,16), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32717, ps{p(proj_utm), p(zone,17), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32718, ps{p(proj_utm), p(zone,18), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32719, ps{p(proj_utm), p(zone,19), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32720, ps{p(proj_utm), p(zone,20), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32721, ps{p(proj_utm), p(zone,21), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32722, ps{p(proj_utm), p(zone,22), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32723, ps{p(proj_utm), p(zone,23), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32724, ps{p(proj_utm), p(zone,24), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32725, ps{p(proj_utm), p(zone,25), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32726, ps{p(proj_utm), p(zone,26), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32727, ps{p(proj_utm), p(zone,27), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32728, ps{p(proj_utm), p(zone,28), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32729, ps{p(proj_utm), p(zone,29), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32730, ps{p(proj_utm), p(zone,30), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32731, ps{p(proj_utm), p(zone,31), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32732, ps{p(proj_utm), p(zone,32), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32733, ps{p(proj_utm), p(zone,33), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32734, ps{p(proj_utm), p(zone,34), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32735, ps{p(proj_utm), p(zone,35), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32736, ps{p(proj_utm), p(zone,36), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32737, ps{p(proj_utm), p(zone,37), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32738, ps{p(proj_utm), p(zone,38), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32739, ps{p(proj_utm), p(zone,39), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32740, ps{p(proj_utm), p(zone,40), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32741, ps{p(proj_utm), p(zone,41), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32742, ps{p(proj_utm), p(zone,42), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32743, ps{p(proj_utm), p(zone,43), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32744, ps{p(proj_utm), p(zone,44), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32745, ps{p(proj_utm), p(zone,45), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32746, ps{p(proj_utm), p(zone,46), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32747, ps{p(proj_utm), p(zone,47), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32748, ps{p(proj_utm), p(zone,48), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32749, ps{p(proj_utm), p(zone,49), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32750, ps{p(proj_utm), p(zone,50), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32751, ps{p(proj_utm), p(zone,51), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32752, ps{p(proj_utm), p(zone,52), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32753, ps{p(proj_utm), p(zone,53), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32754, ps{p(proj_utm), p(zone,54), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32755, ps{p(proj_utm), p(zone,55), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32756, ps{p(proj_utm), p(zone,56), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32757, ps{p(proj_utm), p(zone,57), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32758, ps{p(proj_utm), p(zone,58), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32759, ps{p(proj_utm), p(zone,59), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32760, ps{p(proj_utm), p(zone,60), p(south), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32761, ps{p(proj_stere), p(lat_0,-90), p(lat_ts,-90), p(lon_0,0), p(k,0.994), p(x_0,2000000), p(y_0,2000000), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(32766, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,36), p(k,0.9996), p(x_0,500000), p(y_0,10000000), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(61206405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(61216405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-199.87,74.79,246.62,0.0,0.0,0.0,0.0}),
            ce(61226405, ps{p(proj_longlat), p(a,6378135), p(b,6356750.304921594), p(no_defs)}),
            ce(61236405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-96.062,-82.428,-121.753,4.801,-0.345,1.376,0.30857215014565614}),
            ce(61246405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{414.1,41.3,603.1,-0.855,-2.141,7.023,0.0}),
            ce(61266405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61266413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61276405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{-82.875,-57.097,-156.768,-2.158,-1.524,0.982,-0.07404906544270759}),
            ce(61286405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(61296405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(61306405, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,-0.0,0.0,0.0,0.0}),
            ce(61306413, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,-0.0,0.0,0.0,0.0}),
            ce(61316405, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}, towgs84{182.0,915.0,344.0,0.0,0.0,0.0,0.0}),
            ce(61326405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-244.72,-162.773,400.75,0.0,0.0,0.0,0.0}),
            ce(61336405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.055,-0.541,-0.185,0.0183,0.0003,0.007,-0.002887707287459349}),
            ce(61346405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-191.808,-250.512,167.861,-0.792,-1.653,8.558,4.270300283733636}),
            ce(61356405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{58.0,-283.0,-182.0,0.0,0.0,0.0,0.0}),
            ce(61366405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(61376405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(61386405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(61396405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{11.0,72.0,-101.0,0.0,0.0,0.0,0.0}),
            ce(61406405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0}),
            ce(61406413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0}),
            ce(61416405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-48.0,55.0,52.0,0.0,0.0,0.0,0.0}),
            ce(61426405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-125.0,53.0,467.0,0.0,0.0,0.0,0.0}),
            ce(61436405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-124.76,53.0,466.79,0.0,0.0,0.0,0.0}),
            ce(61446405, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}, towgs84{214.0,804.0,268.0,0.0,0.0,0.0,0.0}),
            ce(61456405, ps{p(proj_longlat), p(a,6377301.243), p(b,6356100.230165384), p(no_defs)}, towgs84{275.57,676.78,229.6,0.0,0.0,0.0,0.0}),
            ce(61466405, ps{p(proj_longlat), p(a,6377299.151), p(b,6356098.145120132), p(no_defs)}, towgs84{295.0,736.0,257.0,0.0,0.0,0.0,0.0}),
            ce(61476405, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{-17.51,-108.32,-62.39,0.0,0.0,0.0,0.0}),
            ce(61486405, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61486413, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61496405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{674.4,15.1,405.3,0.0,0.0,0.0,0.0}),
            ce(61506405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{674.374,15.056,405.346,0.0,0.0,0.0,0.0}),
            ce(61516405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61516413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61526405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0}),
            ce(61526413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0}),
            ce(61536405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-133.63,-157.5,-158.62,0.0,0.0,0.0,0.0}),
            ce(61546405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-123.02,-158.95,-168.47,0.0,0.0,0.0,0.0}),
            ce(61556405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-83.0,37.0,124.0,0.0,0.0,0.0,0.0}),
            ce(61566405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{559.0,68.7,451.5,7.92,4.073,4.251,1.1777720436709203}),
            ce(61576405, ps{p(proj_longlat), p(a,6378293.645208759), p(b,6356617.987679838), p(no_defs)}),
            ce(61586405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-0.465,372.095,171.736,0.0,0.0,0.0,0.0}),
            ce(61596405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-114.7,-98.5,-150.7,0.0,0.0,0.0,0.0}),
            ce(61606405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(61616405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{27.5,14.0,186.4,0.0,0.0,0.0,0.0}),
            ce(61626405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(61636405, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61636413, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61646405, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{-76.0,-138.0,67.0,0.0,0.0,0.0,0.0}),
            ce(61656405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-173.0,253.0,27.0,0.0,0.0,0.0,0.0}),
            ce(61666405, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61676405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61676413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61686405, ps{p(proj_longlat), p(a,6378300), p(b,6356751.689189189), p(no_defs)}, towgs84{-199.0,32.0,322.0,0.0,0.0,0.0,0.0}),
            ce(61696405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{-115.0,118.0,426.0,0.0,0.0,0.0,0.0}),
            ce(61706405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61706413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61716405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61716413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61736405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61736413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61746405, ps{p(proj_longlat), p(a,6378300), p(b,6356751.689189189), p(no_defs)}),
            ce(61756405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-88.0,4.0,101.0,0.0,0.0,0.0,0.0}),
            ce(61766405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61766413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61786405, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{24.0,-123.0,-94.0,0.02,0.25,0.13,0.226891286871806}),
            ce(61796405, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.17326243724756094}),
            ce(61806405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61806413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61816405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-193.0,13.7,-39.3,-0.41,-2.933,2.688,0.08869386668625144}),
            ce(61826405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-422.651,-172.995,84.02,0.0,0.0,0.0,0.0}),
            ce(61836405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-104.0,167.0,-38.0,0.0,0.0,0.0,0.0}),
            ce(61846405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-203.0,141.0,53.0,0.0,0.0,0.0,0.0}),
            ce(61886405, ps{p(proj_longlat), p(ellps_airy), p(no_defs)}, towgs84{482.5,-130.6,564.6,-1.042,-0.214,-0.631,1.6810581709138355}),
            ce(61896405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61896413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61906405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61906413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(61916405, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(61926405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-206.1,-174.7,-87.7,0.0,0.0,0.0,0.0}),
            ce(61936405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-70.9,-151.8,-41.4,0.0,0.0,0.0,0.0}),
            ce(61946405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{163.511,127.533,-159.789,0.0,0.0,0.814,-0.12375888374825782}),
            ce(61956405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{105.0,326.0,-102.5,0.0,0.0,0.814,-0.12375888374825782}),
            ce(61966405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-45.0,417.0,-3.5,0.0,0.0,0.814,-0.12375888374825782}),
            ce(61976405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(61986405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(61996405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(62006405, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(62016405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-165.0,-11.0,206.0,0.0,0.0,0.0,0.0}),
            ce(62026405, ps{p(proj_longlat), p(ellps_aust_sa), p(no_defs)}, towgs84{-124.133,-42.003,137.4,-0.008,-0.557,-0.178,-0.3824149507821167}),
            ce(62036405, ps{p(proj_longlat), p(ellps_aust_sa), p(no_defs)}, towgs84{-117.763,-51.51,139.061,0.292,-0.443,-0.277,-0.03939657799319541}),
            ce(62046405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-18.944,-379.364,-24.063,0.04,0.764,-6.431,0.7543103964456315}),
            ce(62056405, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{-43.0,-163.0,45.0,0.0,0.0,0.0,0.0}),
            ce(62066405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(62076405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-288.885,-91.744,126.244,-1.691,-0.41,0.211,-0.948405579124149}),
            ce(62086405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-161.0,310.0,-145.0,0.0,0.0,0.0,0.0}),
            ce(62096405, ps{p(proj_longlat), p(a,6378249.145), p(b,6356514.966398753), p(no_defs)}, towgs84{-138.0,-105.0,-289.0,0.0,0.0,0.0,0.0}),
            ce(62106405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-157.0,-2.0,-299.0,0.0,0.0,0.0,0.0}),
            ce(62116405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{-377.7,675.1,-52.2,0.0,0.0,0.0,0.0}),
            ce(62126405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{31.95,300.99,419.19,0.0,0.0,0.0,0.0}),
            ce(62136405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-106.0,-87.0,188.0,0.0,0.0,0.0,0.0}),
            ce(62146405, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{15.8,-154.4,-82.3,0.0,0.0,0.0,0.0}),
            ce(62156405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(62166405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{-73.0,213.0,296.0,0.0,0.0,0.0,0.0}),
            ce(62186405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{304.5,306.5,-318.1,0.0,0.0,0.0,0.0}),
            ce(62196405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{-384.0,664.0,-48.0,0.0,0.0,0.0,0.0}),
            ce(62206405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-50.9,-347.6,-231.0,0.0,0.0,0.0,0.0}),
            ce(62216405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-154.5,150.7,100.4,0.0,0.0,0.0,0.0}),
            ce(62226405, ps{p(proj_longlat), p(a,6378249.145), p(b,6356514.966398753), p(no_defs)}, towgs84{-136.0,-108.0,-292.0,0.0,0.0,0.0,0.0}),
            ce(62236405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-260.1,5.5,432.2,0.0,0.0,0.0,0.0}),
            ce(62246405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-134.0,229.0,-29.0,0.0,0.0,0.0,0.0}),
            ce(62256405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-206.0,172.0,-6.0,0.0,0.0,0.0,0.0}),
            ce(62276405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-83.58,-397.54,458.78,-17.595,-2.847,4.256,0.6652040001468859}),
            ce(62296405, ps{p(proj_longlat), p(ellps_helmert), p(no_defs)}, towgs84{-130.0,110.0,-13.0,0.0,0.0,0.0,0.0}),
            ce(62306405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-157.89,-17.16,-78.41,2.118,2.697,-1.434,-1.1097046576093785}),
            ce(62316405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-82.981,-99.719,-110.709,-0.10470001565102613,0.031001600378938583,0.08040202147511816,-0.06482902860346239}),
            ce(62326405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-346.0,-1.0,224.0,0.0,0.0,0.0,0.0}),
            ce(62336405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-133.0,-321.0,50.0,0.0,0.0,0.0,0.0}),
            ce(62366405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-637.0,-549.0,-203.0,0.0,0.0,0.0,0.0}),
            ce(62376405, ps{p(proj_longlat), p(ellps_grs67), p(no_defs)}, towgs84{57.01,-69.97,-9.29,0.0,0.0,0.0,0.0}),
            ce(62386405, ps{p(proj_longlat), p(a,6378160), p(b,6356774.50408554), p(no_defs)}, towgs84{-1.977,-13.06,-9.993,0.364,-0.254,-0.689,-0.2138966040782389}),
            ce(62396405, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}, towgs84{217.0,823.0,299.0,0.0,0.0,0.0,0.0}),
            ce(62406405, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}, towgs84{204.64,834.74,293.8,0.0,0.0,0.0,0.0}),
            ce(62416405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(62426405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{-33.722,153.789,94.959,-8.581,4.478,-4.54,1.8460700159115124}),
            ce(62436405, ps{p(proj_longlat), p(a,6377299.36559538), p(b,6356098.357204818), p(no_defs)}),
            ce(62446405, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}, towgs84{-97.0,787.0,86.0,0.0,0.0,0.0,0.0}),
            ce(62456405, ps{p(proj_longlat), p(a,6377304.063), p(b,6356103.038993155), p(no_defs)}, towgs84{-11.0,851.0,5.0,0.0,0.0,0.0,0.0}),
            ce(62466405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-294.7,-200.1,525.5,0.0,0.0,0.0,0.0}),
            ce(62476405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-273.5,110.6,-357.9,0.0,0.0,0.0,0.0}),
            ce(62486405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-307.7,265.3,-363.5,0.0,0.0,0.0,0.0}),
            ce(62496405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(62506405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-130.0,29.0,364.0,0.0,0.0,0.0,0.0}),
            ce(62516405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-90.0,40.0,88.0,0.0,0.0,0.0,0.0}),
            ce(62526405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(62536405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{-133.0,-77.0,-51.0,0.0,0.0,0.0,0.0}),
            ce(62546405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{18.38,192.45,96.82,0.056,-0.142,-0.2,-0.0002681442481212253}),
            ce(62556405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-333.0,-222.0,114.0,0.0,0.0,0.0,0.0}),
            ce(62566405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{41.0,-220.0,-134.0,0.0,0.0,0.0,0.0}),
            ce(62576405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{-587.8,519.75,145.76,0.0,0.0,0.0,0.0}),
            ce(62586405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(62586413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(62596405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-254.1,-5.36,-100.29,0.0,0.0,0.0,0.0}),
            ce(62616405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{31.0,146.0,47.0,0.0,0.0,0.0,0.0}),
            ce(62626405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{639.0,405.0,60.0,0.0,0.0,0.0,0.0}),
            ce(62636405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-90.2,-87.32,114.17,0.0,0.0,0.0,0.0}),
            ce(62646405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-252.95,-4.11,-96.38,0.0,0.0,0.0,0.0}),
            ce(62656405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-50.2,-50.4,84.8,-0.69,-2.012,0.459,-5.791915759418465}),
            ce(62666405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-80.7,-132.5,41.1,0.0,0.0,0.0,0.0}),
            ce(62676405, ps{p(proj_longlat), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(no_defs)}),
            ce(62686405, ps{p(proj_longlat), p(a,6378450.047548896), p(b,6356826.621488444), p(no_defs)}),
            ce(62696405, ps{p(proj_longlat), p(ellps_grs80), p(srs::dpar::datum_nad83), p(no_defs)}),
            ce(62706405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-245.0,-153.9,382.8,0.0,0.0,0.0,0.0}),
            ce(62716405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-2.0,374.0,172.0,0.0,0.0,0.0,0.0}),
            ce(62726405, ps{p(proj_longlat), p(ellps_intl), p(srs::dpar::datum_nzgd49), p(no_defs)}),
            ce(62736405, ps{p(proj_longlat), p(a,6377492.018), p(b,6356173.508712696), p(no_defs)}, towgs84{278.3,93.0,474.5,7.889,0.05,-6.61,1.2809044467944684}),
            ce(62746405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-239.749,88.181,30.488,0.263,-0.082,-1.211,0.4597642531247778}),
            ce(62756405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-168.0,-60.0,320.0,0.0,0.0,0.0,0.0}),
            ce(62766405, ps{p(proj_longlat), p(ellps_wgs66), p(no_defs)}),
            ce(62776405, ps{p(proj_longlat), p(ellps_airy), p(srs::dpar::datum_osgb36), p(no_defs)}),
            ce(62786405, ps{p(proj_longlat), p(ellps_airy), p(no_defs)}),
            ce(62796405, ps{p(proj_longlat), p(ellps_airy), p(no_defs)}),
            ce(62806405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(62816405, ps{p(proj_longlat), p(a,6378300.789), p(b,6356566.435), p(no_defs)}, towgs84{-275.7224,94.7824,340.8944,-8.001,-4.42,-11.821,0.20626480624709637}),
            ce(62826405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-178.3,-316.7,-131.5,5.278,6.077,10.979,3.953271276531849}),
            ce(62836405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(62836413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(62846405, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{-40.595,-18.55,-69.339,2.508,-1.832,2.611,-0.8867324020562674}),
            ce(62856405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-128.033,-283.697,21.052,0.0,0.0,0.0,0.0}),
            ce(62866405, ps{p(proj_longlat), p(ellps_helmert), p(no_defs)}),
            ce(62886405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(62896405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{565.04,49.91,465.84,-0.40939438743923684,-0.35970519561431136,1.868491000350572,0.8409828680306614}),
            ce(62926405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-355.0,21.0,72.0,0.0,0.0,0.0,0.0}),
            ce(62936405, ps{p(proj_longlat), p(ellps_bess_nam), p(no_defs)}, towgs84{616.0,97.0,-251.0,0.0,0.0,0.0,0.0}),
            ce(62956405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(62976405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-189.0,-242.0,-91.0,0.0,0.0,0.0,0.0}),
            ce(62986405, ps{p(proj_longlat), p(ellps_evrstss), p(no_defs)}, towgs84{-533.4,669.2,-52.5,0.0,0.0,4.28,1.9388891787227058}),
            ce(62996405, ps{p(proj_longlat), p(a,6377340.189), p(b,6356034.447938534), p(no_defs)}, towgs84{482.5,-130.6,564.6,-1.042,-0.214,-0.631,1.6810581709138355}),
            ce(63006405, ps{p(proj_longlat), p(a,6377340.189), p(b,6356034.447938534), p(no_defs)}, towgs84{482.5,-130.6,564.6,-1.042,-0.214,-0.631,1.6810581709138355}),
            ce(63016405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{-147.0,506.0,687.0,0.0,0.0,0.0,0.0}),
            ce(63026405, ps{p(proj_longlat), p(a,6378293.645208759), p(b,6356617.987679838), p(no_defs)}, towgs84{-61.702,284.488,472.052,0.0,0.0,0.0,0.0}),
            ce(63036405, ps{p(proj_longlat), p(ellps_helmert), p(no_defs)}),
            ce(63046405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-73.0,-247.0,227.0,0.0,0.0,0.0,0.0}),
            ce(63066405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(63076405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-169.559,-72.34,303.102,0.0,0.0,0.0,0.0}),
            ce(63086405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(63096405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-155.0,171.0,37.0,0.0,0.0,0.0,0.0}),
            ce(63106405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}),
            ce(63116405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-265.0,120.0,-358.0,0.0,0.0,0.0,0.0}),
            ce(63126405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{426.9,142.6,460.1,4.91,4.49,-12.42,3.5271281868253483}),
            ce(63136405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-106.8686,52.2978,-103.7239,0.3366,0.457,-1.8422,0.26292574852317374}),
            ce(63146405, ps{p(proj_longlat), p(ellps_bessel), p(srs::dpar::datum_potsdam), p(no_defs)}),
            ce(63156405, ps{p(proj_longlat), p(a,6378249.2), p(b,6356515), p(no_defs)}, towgs84{-23.0,259.0,-9.0,0.0,0.0,0.0,0.0}),
            ce(63166405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{103.25,-100.4,-307.19,0.0,0.0,0.0,0.0}),
            ce(63176405, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}, towgs84{28.0,-121.0,-77.0,0.0,0.0,0.0,0.0}),
            ce(63186405, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{-3.2,-5.7,2.8,0.0,0.0,0.0,0.0}),
            ce(63196405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{226.702,-193.337,-35.371,-2.229,4.391,-9.238,0.20209825716090501}),
            ce(63226405, ps{p(proj_longlat), p(ellps_wgs72), p(no_defs)}, towgs84{0.0,0.0,4.5,0.0,0.0,0.554,0.045171992568114105}),
            ce(63246405, ps{p(proj_longlat), p(ellps_wgs72), p(no_defs)}, towgs84{0.0,0.0,1.9,0.0,0.0,0.814,-0.07838062637389662}),
            ce(63266405, ps{p(proj_longlat), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(no_defs)}),
            //{63266406}
            //{63266407}
            //{63266408}
            //{63266409}
            //{63266410}
            ce(63266411, ps{p(proj_longlat), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(no_defs)}),
            //{63266412}
            ce(63266413, ps{p(proj_longlat), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(no_defs)}),
            //{63266414}
            //{63266415}
            //{63266416}
            //{63266417}
            //{63266418}
            ce(63266419, ps{p(proj_longlat), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(no_defs)}),
            //{63266420}
            ce(66006405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(66016405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-255.0,-15.0,71.0,0.0,0.0,0.0,0.0}),
            ce(66026405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{725.0,685.0,536.0,0.0,0.0,0.0,0.0}),
            ce(66036405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{72.0,213.7,93.0,0.0,0.0,0.0,0.0}),
            ce(66046405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{174.0,359.0,365.0,0.0,0.0,0.0,0.0}),
            ce(66056405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{9.0,183.0,236.0,0.0,0.0,0.0,0.0}),
            ce(66066405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-149.0,128.0,296.0,0.0,0.0,0.0,0.0}),
            ce(66076405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{195.671,332.517,274.607,0.0,0.0,0.0,0.0}),
            ce(66086405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(66096405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(66106405, ps{p(proj_longlat), p(a,6378140), p(b,6356755.288157528), p(no_defs)}),
            ce(66116405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-162.619,-276.959,-161.764,0.067753,-2.243649,-1.158827,-0.22570443917666022}),
            ce(66126405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66126413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66136405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{-404.78,685.68,45.47,0.0,0.0,0.0,0.0}),
            ce(66146405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-119.4248,-303.65872,-11.00061,1.164298,0.174458,1.096259,0.7543238036580374}),
            ce(66156405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-499.0,-249.0,314.0,0.0,0.0,0.0,0.0}),
            ce(66166405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-289.0,-124.0,60.0,0.0,0.0,0.0,0.0}),
            ce(66186405, ps{p(proj_longlat), p(ellps_aust_sa), p(no_defs)}, towgs84{-66.87,4.37,-38.52,0.0,0.0,0.0,0.0}),
            ce(66196405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66196413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66206405, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}, towgs84{-106.0,-129.0,165.0,0.0,0.0,0.0,0.0}),
            ce(66216405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{137.0,248.0,-430.0,0.0,0.0,0.0,0.0}),
            ce(66226405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-472.29,-5.63,-304.12,0.4362,-0.8374,0.2563,0.39157310817948776}),
            ce(66236405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-186.0,230.0,110.0,0.0,0.0,0.0,0.0}),
            ce(66246405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{2.0,2.0,-2.0,0.0,0.0,0.0,0.0}),
            ce(66246413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{2.0,2.0,-2.0,0.0,0.0,0.0,0.0}),
            ce(66256405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{126.93,547.94,130.41,-2.7867,5.1612,-0.8584,2.851136537311739}),
            ce(66266405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{94.0,-948.0,-1262.0,0.0,0.0,0.0,0.0}),
            ce(66276405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66276413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66286405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{162.0,117.0,154.0,0.0,0.0,0.0,0.0}),
            ce(66296405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{72.438,345.918,79.486,1.6045,-0.8823,-0.5565,0.2835316026672587}),
            ce(66306405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{259.551,297.612,197.833,-1.4866,2.1224,0.4612,5.574285762347154}),
            ce(66316405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{145.0,-187.0,103.0,0.0,0.0,0.0,0.0}),
            ce(66326405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-382.0,-59.0,-262.0,0.0,0.0,0.0,0.0}),
            ce(66336405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{335.47,222.58,-230.94,0.0,0.0,0.0,0.0}),
            ce(66346405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-11.64,-348.6,291.98,0.0,0.0,0.0,0.0}),
            ce(66356405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,0.9240250790257423}),
            ce(66366405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{365.0,194.0,166.0,0.0,0.0,0.0,0.0}),
            ce(66376405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{325.0,154.0,172.0,0.0,0.0,0.0,0.0}),
            ce(66386405, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}, towgs84{30.0,430.0,368.0,0.0,0.0,0.0,0.0}),
            ce(66396405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{253.0,-132.0,-127.0,0.0,0.0,0.0,0.0}),
            ce(66406405, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66406413, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66416405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{287.58,177.78,-135.41,0.0,0.0,0.0,0.0}),
            ce(66426405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-13.0,-348.0,292.0,0.0,0.0,0.0,0.0}),
            ce(66436405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-23.039820110761912}),
            ce(66446405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-10.18,-350.43,291.37,0.0,0.0,0.0,0.0}),
            ce(66456405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66456413, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66466405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(66576405, ps{p(proj_longlat), p(a,6377019.27), p(b,6355762.5391), p(no_defs)}, towgs84{-28.0,199.0,5.0,0.0,0.0,0.0,0.0}),
            ce(66586405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-73.0,46.0,-86.0,0.0,0.0,0.0,0.0}),
            ce(66596405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66596413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66606405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{982.6087,552.753,-540.873,6.681626625276941,-31.61149240864225,-19.848161004816845,3.466280068982454}),
            ce(66616405, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66616413, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(66636405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-210.502,-66.902,-48.476,2.094,15.067,5.817,0.10003843102984174}),
            ce(66646405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-208.719,129.685,52.092,-0.195,0.014,-0.327,0.040840431636925086}),
            ce(66656405, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}, towgs84{-103.088,162.481,-28.276,0.167,-0.082,-0.168,-0.31022226859563296}),
            ce(66666405, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}, towgs84{631.392,-66.551,481.442,1.09,4.445,4.487,-0.9137530916746368}),
            ce(66676405, ps{p(proj_longlat), p(ellps_wgs84), p(no_defs)}, towgs84{0.0,0.0,0.0,0.0,0.0,0.0,0.0}),
            ce(68016405, ps{p(proj_longlat), p(ellps_bessel), p(pm_bern), p(no_defs)}),
            ce(68026405, ps{p(proj_longlat), p(ellps_intl), p(pm_bogota), p(no_defs)}),
            ce(68036405, ps{p(proj_longlat), p(ellps_intl), p(pm_lisbon), p(no_defs)}),
            ce(68046405, ps{p(proj_longlat), p(ellps_bessel), p(pm_jakarta), p(no_defs)}),
            ce(68056405, ps{p(proj_longlat), p(ellps_bessel), p(pm_ferro), p(no_defs)}),
            ce(68066405, ps{p(proj_longlat), p(ellps_intl), p(pm_rome), p(no_defs)}),
            ce(68086405, ps{p(proj_longlat), p(ellps_bessel), p(pm_jakarta), p(no_defs)}),
            ce(68096405, ps{p(proj_longlat), p(ellps_intl), p(pm_brussels), p(no_defs)}),
            ce(68136405, ps{p(proj_longlat), p(ellps_bessel), p(pm_jakarta), p(no_defs)}),
            ce(68146405, ps{p(proj_longlat), p(ellps_bessel), p(pm_stockholm), p(no_defs)}),
            ce(68156405, ps{p(proj_longlat), p(ellps_bessel), p(pm_athens), p(no_defs)}),
            ce(68186405, ps{p(proj_longlat), p(ellps_bessel), p(pm_ferro), p(no_defs)}),
            ce(68206405, ps{p(proj_longlat), p(ellps_bessel), p(pm_jakarta), p(no_defs)}),
            ce(69036405, ps{p(proj_longlat), p(a,6378298.3), p(b,6356657.142669561), p(pm_madrid), p(no_defs)})
        };

        const auto it = std::lower_bound(arr.begin(), arr.end(), code, code_element_less{});
        return it != arr.end() && it->code == code ? it->to_parameters() : srs::dpar::parameters<>();
    }

}
#endif // DOXYGEN_NO_DETAIL


}}} // namespace boost::geometry::projections

#endif
