#ifndef BOOST_UUID_NAMESPACES_HPP_INCLUDED
#define BOOST_UUID_NAMESPACES_HPP_INCLUDED

// Copyright 2010 Andy Tompkins
// Copyright 2024 Peter Dimov
// Distributed under the Boost Software License, Version 1.0.
// https://www.boost.org/LICENSE_1_0.txt

#include <boost/uuid/uuid.hpp>
#include <boost/config.hpp>

namespace boost {
namespace uuids {
namespace ns {

BOOST_CXX14_CONSTEXPR inline uuid dns() noexcept
{
    return {{
        0x6b, 0xa7, 0xb8, 0x10, 0x9d, 0xad, 0x11, 0xd1,
        0x80, 0xb4, 0x00, 0xc0, 0x4f, 0xd4, 0x30, 0xc8 }};
}

BOOST_CXX14_CONSTEXPR inline uuid url() noexcept
{
    return {{
        0x6b, 0xa7, 0xb8, 0x11, 0x9d, 0xad, 0x11, 0xd1,
        0x80, 0xb4, 0x00, 0xc0, 0x4f, 0xd4, 0x30, 0xc8 }};
}

BOOST_CXX14_CONSTEXPR inline uuid oid() noexcept
{
    return {{
        0x6b, 0xa7, 0xb8, 0x12, 0x9d, 0xad, 0x11, 0xd1,
        0x80, 0xb4, 0x00, 0xc0, 0x4f, 0xd4, 0x30, 0xc8 }};
}

BOOST_CXX14_CONSTEXPR inline uuid x500dn() noexcept
{
    return {{
        0x6b, 0xa7, 0xb8, 0x14, 0x9d, 0xad, 0x11, 0xd1,
        0x80, 0xb4, 0x00, 0xc0, 0x4f, 0xd4, 0x30, 0xc8 }};
}

}}} // namespace boost::uuids::ns

#endif // BOOST_UUID_NAMESPACES_HPP_INCLUDED
