# ![Boost.Utility](doc/logo.png)

Boost.Utility, part of collection of the [Boost C++ Libraries](https://github.com/boostorg), provides a number of smaller components, too small to be called libraries in their own right. See the documentation for the list of components.

### Directories

* **doc** - Documentation sources
* **include** - Interface headers of Boost.Utility
* **test** - Boost.Utility unit tests

### More information

* [Documentation](https://boost.org/libs/utility)
* [Report bugs](https://github.com/boostorg/utility/issues/new). Be sure to mention Boost version, Boost.Utility component, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).

### Build status

Branch          | GitHub Actions | AppVeyor | Test Matrix | Dependencies |
:-------------: | -------------- | -------- | ----------- | ------------ |
[`master`](https://github.com/boostorg/utility/tree/master) | [![GitHub Actions](https://github.com/boostorg/utility/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/boostorg/utility/actions?query=branch%3Amaster) | [![AppVeyor](https://ci.appveyor.com/api/projects/status/g09ehuy2o6aq42th/branch/master?svg=true)](https://ci.appveyor.com/project/Lastique/utility/branch/master) | [![Tests](https://img.shields.io/badge/matrix-master-brightgreen.svg)](https://regression.boost.io/master/developer/utility.html) | [![Dependencies](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/utility.html)
[`develop`](https://github.com/boostorg/utility/tree/develop) | [![GitHub Actions](https://github.com/boostorg/utility/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/boostorg/utility/actions?query=branch%3Adevelop) | [![AppVeyor](https://ci.appveyor.com/api/projects/status/g09ehuy2o6aq42th/branch/develop?svg=true)](https://ci.appveyor.com/project/Lastique/utility/branch/develop) | [![Tests](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](https://regression.boost.io/develop/developer/utility.html) | [![Dependencies](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/utility.html)

### License

Distributed under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).
